/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayCopyOnWriteNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.AllocationTracing;

@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayDupNode
extends RubyBaseNode {
    public abstract RubyArray executeDup(RubyArray var1);

    @Specialization(guards={"from.size == cachedSize", "cachedSize <= MAX_EXPLODE_SIZE"}, limit="getCacheLimit()")
    RubyArray dupProfiledSize(RubyArray from, @Bind(value="from.getStore()") Object fromStore, @CachedLibrary(value="fromStore") ArrayStoreLibrary fromStores, @CachedLibrary(limit="1") ArrayStoreLibrary toStores, @Cached(value="from.size") int cachedSize) {
        return this.copyArraySmall(this.getLanguage(), fromStores, toStores, fromStore, cachedSize);
    }

    @ExplodeLoop
    private RubyArray copyArraySmall(RubyLanguage language, ArrayStoreLibrary fromStores, ArrayStoreLibrary toStores, Object fromStore, int cachedSize) {
        Object copy = fromStores.unsharedAllocator(fromStore).allocate(cachedSize);
        for (int i = 0; i < cachedSize; ++i) {
            toStores.write(copy, i, fromStores.read(fromStore, i));
        }
        return this.allocateArray(this.coreLibrary().arrayClass, copy, cachedSize);
    }

    @Specialization(replaces={"dupProfiledSize"})
    RubyArray dup(RubyArray from, @Bind(value="from.getStore()") Object fromStore, @Cached ArrayCopyOnWriteNode cowNode) {
        int size = from.size;
        Object copy = cowNode.execute(from, 0, from.size);
        return this.allocateArray(this.coreLibrary().arrayClass, copy, size);
    }

    private RubyArray allocateArray(RubyClass rubyClass, Object store, int size) {
        RubyArray array = new RubyArray(rubyClass, this.getLanguage().arrayShape, store, size);
        AllocationTracing.trace(array, this);
        return array;
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.ARRAY_DUP_CACHE;
    }
}

