/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.LazyArrayEachIteratorNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.yield.CallBlockNode;

@ImportStatic(value={ArrayGuards.class})
@ReportPolymorphism
@GenerateInline(inlineByDefault=true)
public abstract class ArrayEachIteratorNode
extends RubyBaseNode {
    public final RubyArray executeCached(RubyArray array, Object state, int startAt, ArrayElementConsumerNode consumerNode) {
        return this.execute(this, array, state, startAt, consumerNode);
    }

    public abstract RubyArray execute(Node var1, RubyArray var2, Object var3, int var4, ArrayElementConsumerNode var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(limit="storageStrategyLimit()")
    static RubyArray iterateMany(Node node, RubyArray array, Object state, int startAt, ArrayElementConsumerNode consumerNode, @CachedLibrary(value="array.getStore()") ArrayStoreLibrary stores, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedIntValueProfile arraySizeProfile, @Cached InlinedConditionProfile strategyMatchProfile, @Cached LazyArrayEachIteratorNode lazyArrayEachIteratorNode, @Cached BooleanCastNode booleanCastNode, @Cached CallBlockNode yieldNode) {
        int i = startAt;
        try {
            while (loopProfile.inject(node, i < arraySizeProfile.profile(node, array.size))) {
                Object store = array.getStore();
                if (!strategyMatchProfile.profile(node, stores.accepts(store))) {
                    RubyArray rubyArray = lazyArrayEachIteratorNode.get(node).executeCached(array, state, i, consumerNode);
                    return rubyArray;
                }
                consumerNode.accept(node, yieldNode, array, state, stores.read(store, i), i, booleanCastNode);
                TruffleSafepoint.poll((Node)node);
                ++i;
            }
        }
        finally {
            ArrayEachIteratorNode.profileAndReportLoopCount(node, loopProfile, i - startAt);
        }
        return array;
    }

    public static interface ArrayElementConsumerNode
    extends NodeInterface {
        public void accept(Node var1, CallBlockNode var2, RubyArray var3, Object var4, Object var5, int var6, BooleanCastNode var7);
    }
}

