/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.array.ArrayFindPatternNodeGen;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.locals.WriteLocalNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChild(value="valueNode", type=RubyNode.class)
public abstract class ArrayFindPatternNode
extends RubyContextSourceNode {
    @Node.Children
    final WriteLocalNode[] writeSlots;
    @Node.Children
    final RubyNode[] conditions;
    @Node.Child
    WriteLocalNode writeLeftSlot;
    @Node.Child
    RubyNode leftCondition;
    @Node.Child
    WriteLocalNode writeRightSlot;
    @Node.Child
    RubyNode rightCondition;

    protected ArrayFindPatternNode(WriteLocalNode[] writeSlots, RubyNode[] conditions, WriteLocalNode writeLeftSlot, RubyNode leftCondition, WriteLocalNode writeRightSlot, RubyNode rightCondition) {
        this.writeSlots = writeSlots;
        this.conditions = conditions;
        this.writeLeftSlot = writeLeftSlot;
        this.leftCondition = leftCondition;
        this.writeRightSlot = writeRightSlot;
        this.rightCondition = rightCondition;
    }

    abstract RubyNode getValueNode();

    @Specialization
    boolean findPattern(VirtualFrame frame, RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(limit="storageStrategyLimit()") ArrayStoreLibrary stores, @Cached ArrayIndexNodes.ReadSliceNormalizedNode readSliceNormalizedNode) {
        int size = array.size;
        int limit = size - this.writeSlots.length;
        block0: for (int start = 0; start <= limit; ++start) {
            for (int i = 0; i < this.writeSlots.length; ++i) {
                Object element = stores.read(store, start + i);
                this.writeSlots[i].assign(frame, element);
                if (!((Boolean)this.conditions[i].execute(frame)).booleanValue()) continue block0;
            }
            this.writeLeftSlot.assign(frame, readSliceNormalizedNode.executeReadSlice(array, 0, start));
            if (!((Boolean)this.leftCondition.execute(frame)).booleanValue()) continue;
            int from = start + this.writeSlots.length;
            this.writeRightSlot.assign(frame, readSliceNormalizedNode.executeReadSlice(array, from, size - from));
            if (!((Boolean)this.rightCondition.execute(frame)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RubyNode cloneUninitialized() {
        WriteLocalNode[] writeSlotsCopies = new WriteLocalNode[this.writeSlots.length];
        for (int i = 0; i < this.writeSlots.length; ++i) {
            writeSlotsCopies[i] = (WriteLocalNode)this.writeSlots[i].cloneUninitialized();
        }
        return ArrayFindPatternNodeGen.create(writeSlotsCopies, ArrayFindPatternNode.cloneUninitialized(this.conditions), (WriteLocalNode)this.writeLeftSlot.cloneUninitialized(), this.leftCondition.cloneUninitialized(), (WriteLocalNode)this.writeRightSlot.cloneUninitialized(), this.rightCondition.cloneUninitialized(), this.getValueNode()).copyFlags(this);
    }
}

