/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayTruncateNodeGen;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayTruncateNode
extends RubyBaseNode {
    public static ArrayTruncateNode create() {
        return ArrayTruncateNodeGen.create();
    }

    public abstract void execute(RubyArray var1, int var2);

    @Specialization(guards={"array.size > size", "stores.isMutable(store)"}, limit="storageStrategyLimit()")
    void truncate(RubyArray array, int size, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        int oldSize = array.size;
        array.size = size;
        stores.clear(store, size, oldSize - size);
    }

    @Specialization(guards={"array.size > size", "!stores.isMutable(store)"}, limit="storageStrategyLimit()")
    void truncateCopy(RubyArray array, int size, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        Object newStore = stores.allocateForNewStore(store, store, size);
        stores.copyContents(store, 0, newStore, 0, size);
        ArrayHelpers.setStoreAndSize(array, newStore, size);
    }

    @Specialization(guards={"array.size <= size"})
    @ReportPolymorphism.Exclude
    void doNothing(RubyArray array, int size) {
    }
}

