/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.DelegatedArrayStorage;
import org.truffleruby.core.array.library.DoubleArrayStore;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.core.array.library.ZeroLengthArrayStore;

@GeneratedBy(value=DoubleArrayStore.class)
final class DoubleArrayStoreGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<ArrayStoreLibrary> ARRAY_STORE_LIBRARY_ = LibraryFactory.resolve(ArrayStoreLibrary.class);

    private DoubleArrayStoreGen() {
    }

    static {
        LibraryExport.register(DoubleArrayStore.class, (LibraryExport[])new LibraryExport[]{new ArrayStoreLibraryExports()});
    }

    @GeneratedBy(value=DoubleArrayStore.class)
    private static final class ArrayStoreLibraryExports
    extends LibraryExport<ArrayStoreLibrary> {
        private ArrayStoreLibraryExports() {
            super(ArrayStoreLibrary.class, double[].class, true, false, 0);
        }

        protected ArrayStoreLibrary createUncached(Object receiver) {
            assert (receiver instanceof double[]);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected ArrayStoreLibrary createCached(Object receiver) {
            assert (receiver instanceof double[]);
            return new Cached();
        }

        @GeneratedBy(value=DoubleArrayStore.class)
        @DenyReplace
        private static final class Uncached
        extends ArrayStoreLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof double[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof double[];
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean acceptsAllValues(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                double[] arg0Value = (double[])arg0Value_;
                if (arg1Value instanceof ZeroLengthArrayStore) {
                    ZeroLengthArrayStore arg1Value_ = (ZeroLengthArrayStore)arg1Value;
                    return DoubleArrayStore.AcceptsAllValues.acceptsZeroValues(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof double[]) {
                    double[] arg1Value_ = (double[])arg1Value;
                    return DoubleArrayStore.AcceptsAllValues.acceptsDoubleValues(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof DelegatedArrayStorage) {
                    DelegatedArrayStorage arg1Value_ = (DelegatedArrayStorage)arg1Value;
                    return DoubleArrayStore.AcceptsAllValues.acceptsDelegateValues(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof SharedArrayStorage) {
                    SharedArrayStorage arg1Value_ = (SharedArrayStorage)arg1Value;
                    return DoubleArrayStore.AcceptsAllValues.acceptsSharedValues(arg0Value, arg1Value_, (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached());
                }
                return DoubleArrayStore.AcceptsAllValues.acceptsOtherValues(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyContents(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                double[] arg0Value = (double[])arg0Value_;
                if (arg2Value instanceof double[]) {
                    double[] arg2Value_ = (double[])arg2Value;
                    DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (!DoubleArrayStore.CopyContents.isDoubleStore(arg2Value)) {
                    DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, LoopConditionProfile.getUncached(), (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg2Value));
                    return;
                }
                throw Uncached.newUnsupportedSpecializationException5LILII((Node)this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                double[] arg0Value = (double[])arg0Value_;
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    return DoubleArrayStore.GeneralizeForValue.generalize(arg0Value, arg1Value_);
                }
                return DoubleArrayStore.GeneralizeForValue.generalize(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                double[] arg0Value = (double[])arg0Value_;
                if (arg1Value instanceof int[]) {
                    int[] arg1Value_ = (int[])arg1Value;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof long[]) {
                    long[] arg1Value_ = (long[])arg1Value;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof double[]) {
                    double[] arg1Value_ = (double[])arg1Value;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Object[]) {
                    Object[] arg1Value_ = (Object[])arg1Value;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value, (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg1Value));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object allocateForNewValue(Object arg0Value_, Object arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                double[] arg0Value = (double[])arg0Value_;
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    return DoubleArrayStore.AllocateForNewValue.allocateForNewStore(arg0Value, arg1Value_, arg2Value);
                }
                return DoubleArrayStore.AllocateForNewValue.allocateForNewStore(arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object allocateForNewStore(Object arg0Value_, Object arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                double[] arg0Value = (double[])arg0Value_;
                if (arg1Value instanceof ZeroLengthArrayStore) {
                    ZeroLengthArrayStore arg1Value_ = (ZeroLengthArrayStore)arg1Value;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof int[]) {
                    int[] arg1Value_ = (int[])arg1Value;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof long[]) {
                    long[] arg1Value_ = (long[])arg1Value;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof double[]) {
                    double[] arg1Value_ = (double[])arg1Value;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof Object[]) {
                    Object[] arg1Value_ = (Object[])arg1Value;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (!ArrayGuards.basicStore(arg1Value) && !ArrayGuards.zeroLengthStore(arg1Value)) {
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value, arg2Value, (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg1Value));
                }
                throw Uncached.newUnsupportedSpecializationException3LLI((Node)this, arg0Value, arg1Value, arg2Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDefaultValue(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                double[] arg0Value = (double[])arg0Value_;
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    return DoubleArrayStore.IsDefaultValue.isDefaultValue(arg0Value, arg1Value_);
                }
                return DoubleArrayStore.IsDefaultValue.isDefaultValue(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object read(Object receiver, int index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.read((double[])receiver, index);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean acceptsValue(Object receiver, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.acceptsValue((double[])receiver, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.isMutable((double[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPrimitive(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.isPrimitive((double[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public String toString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.toString((double[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void write(Object receiver, int index, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                DoubleArrayStore.write((double[])receiver, index, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int capacity(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.capacity((double[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object expand(Object receiver, int capacity) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.expand((double[])receiver, capacity);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] boxedCopyOfRange(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.boxedCopyOfRange((double[])receiver, start, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void clear(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                DoubleArrayStore.clear((double[])receiver, start, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fill(Object receiver, int start, int length, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                DoubleArrayStore.fill((double[])receiver, start, length, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object toJavaArrayCopy(Object receiver, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.toJavaArrayCopy((double[])receiver, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void sort(Object receiver, int size) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                DoubleArrayStore.sort((double[])receiver, size);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Iterable<Object> getIterable(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.getIterable((double[])receiver, start, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.generalizeForSharing((double[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return DoubleArrayStore.allocator((double[])receiver);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException5LILII(Node thisNode_, Object arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException3LLI(Node thisNode_, Object arg0Value, Object arg1Value, int arg2Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }
        }

        @GeneratedBy(value=DoubleArrayStore.class)
        private static final class Cached
        extends ArrayStoreLibrary {
            static final InlineSupport.ReferenceField<CopyContentsCopyContents1Data> COPY_CONTENTS_COPY_CONTENTS1_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"copyContents_copyContents1_cache", CopyContentsCopyContents1Data.class);
            static final InlineSupport.ReferenceField<GeneralizeForStoreGeneralize4Data> GENERALIZE_FOR_STORE_GENERALIZE4_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"generalizeForStore_generalize4_cache", GeneralizeForStoreGeneralize4Data.class);
            static final InlineSupport.ReferenceField<AllocateForNewStoreAllocate5Data> ALLOCATE_FOR_NEW_STORE_ALLOCATE5_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"allocateForNewStore_allocate5_cache", AllocateForNewStoreAllocate5Data.class);
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private ArrayStoreLibrary acceptsAllValues_acceptsSharedValues_stores_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private CopyContentsCopyContents1Data copyContents_copyContents1_cache;
            @CompilerDirectives.CompilationFinal
            private LoopConditionProfile copyContents_copyContents2_loopProfile_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private GeneralizeForStoreGeneralize4Data generalizeForStore_generalize4_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private AllocateForNewStoreAllocate5Data allocateForNewStore_allocate5_cache;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof double[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof double[];
            }

            private boolean acceptsAllValuesFallbackGuard_(int state_0, double[] arg0Value, Object arg1Value) {
                if ((state_0 & 1) == 0 && arg1Value instanceof ZeroLengthArrayStore) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg1Value instanceof double[]) {
                    return false;
                }
                if ((state_0 & 4) == 0 && arg1Value instanceof DelegatedArrayStorage) {
                    return false;
                }
                return (state_0 & 8) != 0 || !(arg1Value instanceof SharedArrayStorage);
            }

            @Override
            public boolean acceptsAllValues(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                double[] arg0Value = (double[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof ZeroLengthArrayStore) {
                        ZeroLengthArrayStore arg1Value_ = (ZeroLengthArrayStore)arg1Value;
                        return DoubleArrayStore.AcceptsAllValues.acceptsZeroValues(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && arg1Value instanceof double[]) {
                        double[] arg1Value_ = (double[])arg1Value;
                        return DoubleArrayStore.AcceptsAllValues.acceptsDoubleValues(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 4) != 0 && arg1Value instanceof DelegatedArrayStorage) {
                        DelegatedArrayStorage arg1Value_ = (DelegatedArrayStorage)arg1Value;
                        return DoubleArrayStore.AcceptsAllValues.acceptsDelegateValues(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 8) != 0 && arg1Value instanceof SharedArrayStorage) {
                        SharedArrayStorage arg1Value_ = (SharedArrayStorage)arg1Value;
                        ArrayStoreLibrary stores__ = this.acceptsAllValues_acceptsSharedValues_stores_;
                        if (stores__ != null) {
                            return DoubleArrayStore.AcceptsAllValues.acceptsSharedValues(arg0Value, arg1Value_, stores__);
                        }
                    }
                    if ((state_0 & 0x10) != 0 && this.acceptsAllValuesFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return DoubleArrayStore.AcceptsAllValues.acceptsOtherValues(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.acceptsAllValuesAndSpecialize(arg0Value, arg1Value);
            }

            private boolean acceptsAllValuesAndSpecialize(double[] arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof ZeroLengthArrayStore) {
                    ZeroLengthArrayStore arg1Value_ = (ZeroLengthArrayStore)arg1Value;
                    this.state_0_ = state_0 |= 1;
                    return DoubleArrayStore.AcceptsAllValues.acceptsZeroValues(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof double[]) {
                    double[] arg1Value_ = (double[])arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return DoubleArrayStore.AcceptsAllValues.acceptsDoubleValues(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof DelegatedArrayStorage) {
                    DelegatedArrayStorage arg1Value_ = (DelegatedArrayStorage)arg1Value;
                    this.state_0_ = state_0 |= 4;
                    return DoubleArrayStore.AcceptsAllValues.acceptsDelegateValues(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof SharedArrayStorage) {
                    SharedArrayStorage arg1Value_ = (SharedArrayStorage)arg1Value;
                    ArrayStoreLibrary stores__ = (ArrayStoreLibrary)this.insert((Node)((ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(stores__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.acceptsAllValues_acceptsSharedValues_stores_ = stores__;
                    this.state_0_ = state_0 |= 8;
                    return DoubleArrayStore.AcceptsAllValues.acceptsSharedValues(arg0Value, arg1Value_, stores__);
                }
                this.state_0_ = state_0 |= 0x10;
                return DoubleArrayStore.AcceptsAllValues.acceptsOtherValues(arg0Value, arg1Value);
            }

            @Override
            @ExplodeLoop
            public void copyContents(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                double[] arg0Value = (double[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xE0) != 0) {
                    if ((state_0 & 0x20) != 0 && arg2Value instanceof double[]) {
                        double[] arg2Value_ = (double[])arg2Value;
                        DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 0xC0) != 0) {
                        LoopConditionProfile loopProfile__;
                        if ((state_0 & 0x40) != 0) {
                            CopyContentsCopyContents1Data s1_ = this.copyContents_copyContents1_cache;
                            while (s1_ != null) {
                                if (s1_.destStores_.accepts(arg2Value) && !DoubleArrayStore.CopyContents.isDoubleStore(arg2Value)) {
                                    DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.loopProfile_, s1_.destStores_);
                                    return;
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0x80) != 0 && (loopProfile__ = this.copyContents_copyContents2_loopProfile_) != null && !DoubleArrayStore.CopyContents.isDoubleStore(arg2Value)) {
                            this.copyContents_CopyContents2Boundary(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, loopProfile__);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.copyContentsAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private void copyContents_CopyContents2Boundary(int state_0, double[] arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, LoopConditionProfile loopProfile__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    ArrayStoreLibrary destStores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg2Value);
                    DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, loopProfile__, destStores__);
                    return;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void copyContentsAndSpecialize(double[] arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value) {
                LoopConditionProfile loopProfile__;
                int state_0 = this.state_0_;
                if (arg2Value instanceof double[]) {
                    double[] arg2Value_ = (double[])arg2Value;
                    this.state_0_ = state_0 |= 0x20;
                    DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if ((state_0 & 0x80) == 0) {
                    CopyContentsCopyContents1Data s1_;
                    block9: {
                        CopyContentsCopyContents1Data s1_original;
                        do {
                            int count1_ = 0;
                            s1_original = s1_ = (CopyContentsCopyContents1Data)((Object)COPY_CONTENTS_COPY_CONTENTS1_CACHE_UPDATER.getVolatile((Node)this));
                            while (s1_ != null && (!s1_.destStores_.accepts(arg2Value) || DoubleArrayStore.CopyContents.isDoubleStore(arg2Value))) {
                                ++count1_;
                                s1_ = s1_.next_;
                            }
                            if (s1_ != null || DoubleArrayStore.CopyContents.isDoubleStore(arg2Value) || count1_ >= ArrayGuards.storageStrategyLimit()) break block9;
                            s1_ = (CopyContentsCopyContents1Data)this.insert(new CopyContentsCopyContents1Data(s1_original));
                            loopProfile__ = LoopConditionProfile.create();
                            Objects.requireNonNull(loopProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.loopProfile_ = loopProfile__;
                            ArrayStoreLibrary destStores__ = (ArrayStoreLibrary)s1_.insert((Node)((ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.create(arg2Value)));
                            Objects.requireNonNull(destStores__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.destStores_ = destStores__;
                        } while (!COPY_CONTENTS_COPY_CONTENTS1_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                        this.state_0_ = state_0 |= 0x40;
                    }
                    if (s1_ != null) {
                        DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.loopProfile_, s1_.destStores_);
                        return;
                    }
                }
                ArrayStoreLibrary destStores__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (!DoubleArrayStore.CopyContents.isDoubleStore(arg2Value)) {
                        loopProfile__ = LoopConditionProfile.create();
                        Objects.requireNonNull(loopProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.copyContents_copyContents2_loopProfile_ = loopProfile__;
                        destStores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg2Value);
                        this.copyContents_copyContents1_cache = null;
                        state_0 &= 0xFFFFFFBF;
                        this.state_0_ = state_0 |= 0x80;
                        DoubleArrayStore.CopyContents.copyContents(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, loopProfile__, destStores__);
                        return;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
            }

            private boolean generalizeForValueFallbackGuard_(int state_0, double[] arg0Value, Object arg1Value) {
                return (state_0 & 0x100) != 0 || !(arg1Value instanceof Double);
            }

            @Override
            public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                double[] arg0Value = (double[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x300) != 0) {
                    if ((state_0 & 0x100) != 0 && arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return DoubleArrayStore.GeneralizeForValue.generalize(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x200) != 0 && this.generalizeForValueFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return DoubleArrayStore.GeneralizeForValue.generalize(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.generalizeForValueAndSpecialize(arg0Value, arg1Value);
            }

            private ArrayStoreLibrary.ArrayAllocator generalizeForValueAndSpecialize(double[] arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    this.state_0_ = state_0 |= 0x100;
                    return DoubleArrayStore.GeneralizeForValue.generalize(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 0x200;
                return DoubleArrayStore.GeneralizeForValue.generalize(arg0Value, arg1Value);
            }

            @Override
            @ExplodeLoop
            public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                double[] arg0Value = (double[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xFC00) != 0) {
                    if ((state_0 & 0x400) != 0 && arg1Value instanceof int[]) {
                        int[] arg1Value_ = (int[])arg1Value;
                        return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x800) != 0 && arg1Value instanceof long[]) {
                        long[] arg1Value_ = (long[])arg1Value;
                        return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x1000) != 0 && arg1Value instanceof double[]) {
                        double[] arg1Value_ = (double[])arg1Value;
                        return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x2000) != 0 && arg1Value instanceof Object[]) {
                        Object[] arg1Value_ = (Object[])arg1Value;
                        return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0xC000) != 0) {
                        if ((state_0 & 0x4000) != 0) {
                            GeneralizeForStoreGeneralize4Data s4_ = this.generalizeForStore_generalize4_cache;
                            while (s4_ != null) {
                                if (s4_.newStores_.accepts(arg1Value)) {
                                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value, s4_.newStores_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0x8000) != 0) {
                            return this.generalizeForStore_Generalize5Boundary(state_0, arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.generalizeForStoreAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private ArrayStoreLibrary.ArrayAllocator generalizeForStore_Generalize5Boundary(int state_0, double[] arg0Value, Object arg1Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    ArrayStoreLibrary newStores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg1Value);
                    ArrayStoreLibrary.ArrayAllocator arrayAllocator = DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value, newStores__);
                    return arrayAllocator;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ArrayStoreLibrary.ArrayAllocator generalizeForStoreAndSpecialize(double[] arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof int[]) {
                    int[] arg1Value_ = (int[])arg1Value;
                    this.state_0_ = state_0 |= 0x400;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof long[]) {
                    long[] arg1Value_ = (long[])arg1Value;
                    this.state_0_ = state_0 |= 0x800;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof double[]) {
                    double[] arg1Value_ = (double[])arg1Value;
                    this.state_0_ = state_0 |= 0x1000;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Object[]) {
                    Object[] arg1Value_ = (Object[])arg1Value;
                    this.state_0_ = state_0 |= 0x2000;
                    return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x8000) == 0) {
                    GeneralizeForStoreGeneralize4Data s4_;
                    block11: {
                        GeneralizeForStoreGeneralize4Data s4_original;
                        do {
                            int count4_ = 0;
                            s4_original = s4_ = (GeneralizeForStoreGeneralize4Data)((Object)GENERALIZE_FOR_STORE_GENERALIZE4_CACHE_UPDATER.getVolatile((Node)this));
                            while (s4_ != null && !s4_.newStores_.accepts(arg1Value)) {
                                ++count4_;
                                s4_ = s4_.next_;
                            }
                            if (s4_ != null || count4_ >= ArrayGuards.storageStrategyLimit()) break block11;
                            s4_ = (GeneralizeForStoreGeneralize4Data)this.insert(new GeneralizeForStoreGeneralize4Data(s4_original));
                            ArrayStoreLibrary newStores__ = (ArrayStoreLibrary)s4_.insert((Node)((ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.create(arg1Value)));
                            Objects.requireNonNull(newStores__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s4_.newStores_ = newStores__;
                        } while (!GENERALIZE_FOR_STORE_GENERALIZE4_CACHE_UPDATER.compareAndSet((Node)this, (Object)s4_original, (Object)s4_));
                        this.state_0_ = state_0 |= 0x4000;
                    }
                    if (s4_ != null) {
                        return DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value, s4_.newStores_);
                    }
                }
                ArrayStoreLibrary newStores__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    newStores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg1Value);
                    this.generalizeForStore_generalize4_cache = null;
                    state_0 &= 0xFFFFBFFF;
                    this.state_0_ = state_0 |= 0x8000;
                    ArrayStoreLibrary.ArrayAllocator arrayAllocator = DoubleArrayStore.GeneralizeForStore.generalize(arg0Value, arg1Value, newStores__);
                    return arrayAllocator;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            private boolean allocateForNewValueFallbackGuard_(int state_0, double[] arg0Value, Object arg1Value, int arg2Value) {
                return (state_0 & 0x10000) != 0 || !(arg1Value instanceof Double);
            }

            @Override
            public Object allocateForNewValue(Object arg0Value_, Object arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                double[] arg0Value = (double[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x30000) != 0) {
                    if ((state_0 & 0x10000) != 0 && arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return DoubleArrayStore.AllocateForNewValue.allocateForNewStore(arg0Value, arg1Value_, arg2Value);
                    }
                    if ((state_0 & 0x20000) != 0 && this.allocateForNewValueFallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                        return DoubleArrayStore.AllocateForNewValue.allocateForNewStore(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.allocateForNewValueAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object allocateForNewValueAndSpecialize(double[] arg0Value, Object arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    this.state_0_ = state_0 |= 0x10000;
                    return DoubleArrayStore.AllocateForNewValue.allocateForNewStore(arg0Value, arg1Value_, arg2Value);
                }
                this.state_0_ = state_0 |= 0x20000;
                return DoubleArrayStore.AllocateForNewValue.allocateForNewStore(arg0Value, arg1Value, arg2Value);
            }

            @Override
            @ExplodeLoop
            public Object allocateForNewStore(Object arg0Value_, Object arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                double[] arg0Value = (double[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1FC0000) != 0) {
                    if ((state_0 & 0x40000) != 0 && arg1Value instanceof ZeroLengthArrayStore) {
                        ZeroLengthArrayStore arg1Value_ = (ZeroLengthArrayStore)arg1Value;
                        return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                    }
                    if ((state_0 & 0x80000) != 0 && arg1Value instanceof int[]) {
                        int[] arg1Value_ = (int[])arg1Value;
                        return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                    }
                    if ((state_0 & 0x100000) != 0 && arg1Value instanceof long[]) {
                        long[] arg1Value_ = (long[])arg1Value;
                        return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                    }
                    if ((state_0 & 0x200000) != 0 && arg1Value instanceof double[]) {
                        double[] arg1Value_ = (double[])arg1Value;
                        return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                    }
                    if ((state_0 & 0x400000) != 0 && arg1Value instanceof Object[]) {
                        Object[] arg1Value_ = (Object[])arg1Value;
                        return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                    }
                    if ((state_0 & 0x1800000) != 0) {
                        if ((state_0 & 0x800000) != 0) {
                            AllocateForNewStoreAllocate5Data s5_ = this.allocateForNewStore_allocate5_cache;
                            while (s5_ != null) {
                                if (s5_.newStores_.accepts(arg1Value) && !ArrayGuards.basicStore(arg1Value) && !ArrayGuards.zeroLengthStore(arg1Value)) {
                                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value, arg2Value, s5_.newStores_);
                                }
                                s5_ = s5_.next_;
                            }
                        }
                        if ((state_0 & 0x1000000) != 0 && !ArrayGuards.basicStore(arg1Value) && !ArrayGuards.zeroLengthStore(arg1Value)) {
                            return this.allocateForNewStore_Allocate6Boundary(state_0, arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.allocateForNewStoreAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object allocateForNewStore_Allocate6Boundary(int state_0, double[] arg0Value, Object arg1Value, int arg2Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    ArrayStoreLibrary newStores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg1Value);
                    Object object = DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value, arg2Value, newStores__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object allocateForNewStoreAndSpecialize(double[] arg0Value, Object arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof ZeroLengthArrayStore) {
                    ZeroLengthArrayStore arg1Value_ = (ZeroLengthArrayStore)arg1Value;
                    this.state_0_ = state_0 |= 0x40000;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof int[]) {
                    int[] arg1Value_ = (int[])arg1Value;
                    this.state_0_ = state_0 |= 0x80000;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof long[]) {
                    long[] arg1Value_ = (long[])arg1Value;
                    this.state_0_ = state_0 |= 0x100000;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof double[]) {
                    double[] arg1Value_ = (double[])arg1Value;
                    this.state_0_ = state_0 |= 0x200000;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if (arg1Value instanceof Object[]) {
                    Object[] arg1Value_ = (Object[])arg1Value;
                    this.state_0_ = state_0 |= 0x400000;
                    return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value_, arg2Value);
                }
                if ((state_0 & 0x1000000) == 0) {
                    AllocateForNewStoreAllocate5Data s5_;
                    block13: {
                        AllocateForNewStoreAllocate5Data s5_original;
                        do {
                            int count5_ = 0;
                            s5_original = s5_ = (AllocateForNewStoreAllocate5Data)((Object)ALLOCATE_FOR_NEW_STORE_ALLOCATE5_CACHE_UPDATER.getVolatile((Node)this));
                            while (s5_ != null && (!s5_.newStores_.accepts(arg1Value) || ArrayGuards.basicStore(arg1Value) || ArrayGuards.zeroLengthStore(arg1Value))) {
                                ++count5_;
                                s5_ = s5_.next_;
                            }
                            if (s5_ != null || ArrayGuards.basicStore(arg1Value) || ArrayGuards.zeroLengthStore(arg1Value) || count5_ >= ArrayGuards.storageStrategyLimit()) break block13;
                            s5_ = (AllocateForNewStoreAllocate5Data)this.insert(new AllocateForNewStoreAllocate5Data(s5_original));
                            ArrayStoreLibrary newStores__ = (ArrayStoreLibrary)s5_.insert((Node)((ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.create(arg1Value)));
                            Objects.requireNonNull(newStores__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s5_.newStores_ = newStores__;
                        } while (!ALLOCATE_FOR_NEW_STORE_ALLOCATE5_CACHE_UPDATER.compareAndSet((Node)this, (Object)s5_original, (Object)s5_));
                        this.state_0_ = state_0 |= 0x800000;
                    }
                    if (s5_ != null) {
                        return DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value, arg2Value, s5_.newStores_);
                    }
                }
                ArrayStoreLibrary newStores__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (!ArrayGuards.basicStore(arg1Value) && !ArrayGuards.zeroLengthStore(arg1Value)) {
                        newStores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(arg1Value);
                        this.allocateForNewStore_allocate5_cache = null;
                        state_0 &= 0xFF7FFFFF;
                        this.state_0_ = state_0 |= 0x1000000;
                        Object object = DoubleArrayStore.AllocateForNewStore.allocate(arg0Value, arg1Value, arg2Value, newStores__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            private boolean isDefaultValueFallbackGuard_(int state_0, double[] arg0Value, Object arg1Value) {
                return (state_0 & 0x2000000) != 0 || !(arg1Value instanceof Double);
            }

            @Override
            public boolean isDefaultValue(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                double[] arg0Value = (double[])arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x6000000) != 0) {
                    if ((state_0 & 0x2000000) != 0 && arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return DoubleArrayStore.IsDefaultValue.isDefaultValue(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x4000000) != 0 && this.isDefaultValueFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return DoubleArrayStore.IsDefaultValue.isDefaultValue(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isDefaultValueAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isDefaultValueAndSpecialize(double[] arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    this.state_0_ = state_0 |= 0x2000000;
                    return DoubleArrayStore.IsDefaultValue.isDefaultValue(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 0x4000000;
                return DoubleArrayStore.IsDefaultValue.isDefaultValue(arg0Value, arg1Value);
            }

            @Override
            public Object read(Object receiver, int index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.read((double[])receiver, index);
            }

            @Override
            public boolean acceptsValue(Object receiver, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.acceptsValue((double[])receiver, value);
            }

            @Override
            public boolean isMutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.isMutable((double[])receiver);
            }

            @Override
            public boolean isPrimitive(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.isPrimitive((double[])receiver);
            }

            @Override
            public String toString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.toString((double[])receiver);
            }

            @Override
            public void write(Object receiver, int index, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                DoubleArrayStore.write((double[])receiver, index, value);
            }

            @Override
            public int capacity(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.capacity((double[])receiver);
            }

            @Override
            public Object expand(Object receiver, int capacity) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.expand((double[])receiver, capacity);
            }

            @Override
            public Object[] boxedCopyOfRange(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.boxedCopyOfRange((double[])receiver, start, length);
            }

            @Override
            public void clear(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                DoubleArrayStore.clear((double[])receiver, start, length);
            }

            @Override
            public void fill(Object receiver, int start, int length, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                DoubleArrayStore.fill((double[])receiver, start, length, value);
            }

            @Override
            public Object toJavaArrayCopy(Object receiver, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.toJavaArrayCopy((double[])receiver, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void sort(Object receiver, int size) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                DoubleArrayStore.sort((double[])receiver, size);
            }

            @Override
            public Iterable<Object> getIterable(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.getIterable((double[])receiver, start, length);
            }

            @Override
            public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.generalizeForSharing((double[])receiver);
            }

            @Override
            public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ArrayStoreLibraryExports.assertAdopted((Node)((Node)this)));
                return DoubleArrayStore.allocator((double[])receiver);
            }

            @GeneratedBy(value=DoubleArrayStore.class)
            @DenyReplace
            private static final class CopyContentsCopyContents1Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                CopyContentsCopyContents1Data next_;
                @CompilerDirectives.CompilationFinal
                LoopConditionProfile loopProfile_;
                @Node.Child
                ArrayStoreLibrary destStores_;

                CopyContentsCopyContents1Data(CopyContentsCopyContents1Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=DoubleArrayStore.class)
            @DenyReplace
            private static final class GeneralizeForStoreGeneralize4Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                GeneralizeForStoreGeneralize4Data next_;
                @Node.Child
                ArrayStoreLibrary newStores_;

                GeneralizeForStoreGeneralize4Data(GeneralizeForStoreGeneralize4Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=DoubleArrayStore.class)
            @DenyReplace
            private static final class AllocateForNewStoreAllocate5Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                AllocateForNewStoreAllocate5Data next_;
                @Node.Child
                ArrayStoreLibrary newStores_;

                AllocateForNewStoreAllocate5Data(AllocateForNewStoreAllocate5Data next_) {
                    this.next_ = next_;
                }
            }
        }
    }
}

