/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.DelegatedArrayStorage;
import org.truffleruby.core.array.library.ObjectArrayStore;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.core.array.library.ZeroLengthArrayStore;
import org.truffleruby.language.RubyBaseNode;

@ExportLibrary(value=ArrayStoreLibrary.class, receiverType=long[].class)
@GenerateUncached
public final class LongArrayStore {
    public static final ArrayStoreLibrary.ArrayAllocator LONG_ARRAY_ALLOCATOR = new LongArrayAllocator();

    @ExportMessage
    static long read(long[] store, int index) {
        return store[index];
    }

    @ExportMessage
    static boolean acceptsValue(long[] store, Object value) {
        return value instanceof Long || value instanceof Integer;
    }

    @ExportMessage
    static boolean isMutable(long[] store) {
        return true;
    }

    @ExportMessage
    static boolean isPrimitive(long[] store) {
        return true;
    }

    @ExportMessage
    static String toString(long[] store) {
        return "long[]";
    }

    @ExportMessage
    static int capacity(long[] store) {
        return store.length;
    }

    @ExportMessage
    static long[] expand(long[] store, int newCapacity) {
        return ArrayUtils.grow(store, newCapacity);
    }

    @ExportMessage
    static Object[] boxedCopyOfRange(long[] store, int start, int length) {
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = store[start + i];
        }
        return result;
    }

    @ExportMessage
    static void clear(long[] store, int start, int length) {
    }

    @ExportMessage
    static long[] toJavaArrayCopy(long[] store, int length) {
        return ArrayUtils.extractRange(store, 0, length);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static void sort(long[] store, int size) {
        Arrays.sort(store, 0, size);
    }

    @ExportMessage
    static Iterable<Object> getIterable(final long[] store, final int from, final int length) {
        return () -> new Iterator<Object>(){
            private int n;
            {
                this.n = from;
            }

            @Override
            public boolean hasNext() {
                return this.n < from + length;
            }

            @Override
            public Object next() throws NoSuchElementException {
                if (this.n >= from + length) {
                    throw new NoSuchElementException();
                }
                Long object = store[this.n];
                ++this.n;
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator generalizeForSharing(long[] store) {
        return SharedArrayStorage.SHARED_LONG_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator allocator(long[] store) {
        return LONG_ARRAY_ALLOCATOR;
    }

    private static final class LongArrayAllocator
    extends ArrayStoreLibrary.ArrayAllocator {
        private LongArrayAllocator() {
        }

        public long[] allocate(int capacity) {
            return new long[capacity];
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Integer || value instanceof Long;
        }

        @Override
        public boolean specializesFor(Object value) {
            return value instanceof Long;
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return (Long)value == 0L;
        }
    }

    @ExportMessage
    protected static final class IsDefaultValue {
        protected IsDefaultValue() {
        }

        @Specialization
        static boolean isDefaultValue(long[] store, long value) {
            return value == 0L;
        }

        @Fallback
        static boolean isDefaultValue(long[] store, Object value) {
            return false;
        }
    }

    @ExportMessage
    @ImportStatic(value={ArrayGuards.class})
    static final class AllocateForNewStore {
        AllocateForNewStore() {
        }

        @Specialization
        static Object allocate(long[] store, ZeroLengthArrayStore newStore, int length) {
            return LONG_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocate(long[] store, int[] newStore, int length) {
            return LONG_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocate(long[] store, long[] newStore, int length) {
            return LONG_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocate(long[] store, double[] newStore, int length) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocate(long[] store, Object[] newStore, int length) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization(guards={"!basicStore(newStore)", "!zeroLengthStore(newStore)"}, limit="storageStrategyLimit()")
        static Object allocate(long[] store, Object newStore, int length, @CachedLibrary(value="newStore") ArrayStoreLibrary newStores) {
            return newStores.unsharedAllocateForNewStore(newStore, store, length);
        }
    }

    @ExportMessage
    static final class AllocateForNewValue {
        AllocateForNewValue() {
        }

        @Specialization
        static Object allocateForNewStore(long[] store, int newValue, int length) {
            return LONG_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocateForNewStore(long[] store, long newValue, int length) {
            return LONG_ARRAY_ALLOCATOR.allocate(length);
        }

        @Specialization
        static Object allocateForNewStore(long[] store, double newValue, int length) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR.allocate(length);
        }

        @Fallback
        static Object allocateForNewStore(long[] store, Object newValue, int length) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR.allocate(length);
        }
    }

    @ExportMessage
    @ImportStatic(value={ArrayGuards.class})
    static final class GeneralizeForStore {
        GeneralizeForStore() {
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, int[] newStore) {
            return LONG_ARRAY_ALLOCATOR;
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, long[] newStore) {
            return LONG_ARRAY_ALLOCATOR;
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, double[] newStore) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, Object[] newStore) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
        }

        @Specialization(limit="storageStrategyLimit()")
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, Object newStore, @CachedLibrary(value="newStore") ArrayStoreLibrary newStores) {
            return newStores.generalizeForStore(newStore, store);
        }
    }

    @ExportMessage
    static final class GeneralizeForValue {
        GeneralizeForValue() {
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, int newValue) {
            return LONG_ARRAY_ALLOCATOR;
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, long newValue) {
            return LONG_ARRAY_ALLOCATOR;
        }

        @Specialization
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, double newValue) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
        }

        @Fallback
        static ArrayStoreLibrary.ArrayAllocator generalize(long[] store, Object newValue) {
            return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
        }
    }

    @ExportMessage
    static final class Fill {
        Fill() {
        }

        @Specialization
        static void fill(long[] store, int start, int length, int value) {
            Arrays.fill(store, start, start + length, (long)value);
        }

        @Specialization
        static void write(long[] store, int start, int length, long value) {
            Arrays.fill(store, start, start + length, value);
        }
    }

    @ExportMessage
    @ImportStatic(value={ArrayGuards.class})
    static final class CopyContents {
        CopyContents() {
        }

        @Specialization
        static void copyContents(long[] srcStore, int srcStart, long[] destStore, int destStart, int length) {
            System.arraycopy(srcStore, srcStart, destStore, destStart, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isLongStore(destStore)"}, limit="storageStrategyLimit()")
        static void copyContents(long[] srcStore, int srcStart, Object destStore, int destStart, int length, @Cached LoopConditionProfile loopProfile, @CachedLibrary(value="destStore") ArrayStoreLibrary destStores) {
            int i = 0;
            try {
                while (loopProfile.inject(i < length)) {
                    destStores.write(destStore, destStart + i, srcStore[srcStart + i]);
                    TruffleSafepoint.poll((Node)destStores);
                    ++i;
                }
            }
            finally {
                RubyBaseNode.profileAndReportLoopCount(destStores.getNode(), loopProfile, i);
            }
        }

        protected static boolean isLongStore(Object store) {
            return store instanceof long[];
        }
    }

    @ExportMessage
    static final class Write {
        Write() {
        }

        @Specialization
        static void write(long[] store, int index, int value) {
            store[index] = value;
        }

        @Specialization
        static void write(long[] store, int index, long value) {
            store[index] = value;
        }
    }

    @ExportMessage
    static final class AcceptsAllValues {
        AcceptsAllValues() {
        }

        @Specialization
        static boolean acceptsZeroValues(long[] store, ZeroLengthArrayStore otherStore) {
            return true;
        }

        @Specialization
        static boolean acceptsIntValues(long[] store, int[] otherStore) {
            return true;
        }

        @Specialization
        static boolean acceptsLongValues(long[] store, long[] otherStore) {
            return true;
        }

        @Specialization
        static boolean acceptsDelegateValues(long[] store, DelegatedArrayStorage otherStore) {
            return otherStore.storage instanceof int[] || otherStore.storage instanceof long[];
        }

        @Specialization
        static boolean acceptsSharedValues(long[] store, SharedArrayStorage otherStore, @CachedLibrary(limit="1") ArrayStoreLibrary stores) {
            return stores.acceptsAllValues(store, otherStore.storage);
        }

        @Fallback
        static boolean acceptsOtherValues(long[] store, Object otherStore) {
            return false;
        }
    }
}

