/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.basicobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import org.truffleruby.Layouts;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.core.basicobject.BasicObjectNodesFactory;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.NameToJavaStringNode;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.objectspace.ObjectSpaceManager;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.RubyCallNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.loader.EvalLoader;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.CanHaveSingletonClassNode;
import org.truffleruby.language.objects.LogicalClassNode;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.language.objects.ObjectIDOperations;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.language.supercall.SuperCallNode;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;

@CoreModule(value="BasicObject", isClass=true)
public abstract class BasicObjectNodes {

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    public static abstract class AllocateNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"!rubyClass.isSingleton"})
        RubyBasicObject allocate(Frame callerFrame, RubyClass rubyClass, Object[] rubyArgs, RootCallTarget target) {
            RubyBasicObject instance = new RubyBasicObject(rubyClass, this.getLanguage().basicObjectShape);
            AllocationTracing.traceInlined(instance, "Class", "__allocate__", this);
            return instance;
        }

        @Specialization(guards={"rubyClass.isSingleton"})
        Shape allocateSingleton(Frame callerFrame, RubyClass rubyClass, Object[] rubyArgs, RootCallTarget target) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().typeErrorCantCreateInstanceOfSingletonClass(this));
        }
    }

    @CoreMethod(names={"__send__"}, needsBlock=true, rest=true, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class SendNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object send(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached DispatchNode dispatchNode, @Cached NameToJavaStringNode nameToJavaString) {
            Object name = RubyArguments.getArgument(rubyArgs, 0);
            return dispatchNode.execute(callerFrame, self, nameToJavaString.execute(this, name), RubyArguments.repack(rubyArgs, self, 1), DispatchConfiguration.PRIVATE);
        }
    }

    @CoreMethod(names={"method_missing"}, needsBlock=true, rest=true, optional=1, visibility=Visibility.PRIVATE, split=Split.NEVER)
    public static abstract class MethodMissingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object methodMissingNoName(Object self, NotProvided name, Object[] args, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("no id given", this));
        }

        @Specialization(guards={"wasProvided(name)"})
        Object methodMissing(Object self, Object name, Object[] args, Object block) {
            throw new RaiseException(this.getContext(), this.buildMethodMissingException(self, name, args, block));
        }

        @CompilerDirectives.TruffleBoundary
        private RubyException buildMethodMissingException(Object self, Object nameObject, Object[] args, Object block) {
            String name = nameObject instanceof RubySymbol ? ((RubySymbol)nameObject).getString() : nameObject.toString();
            FrameAndCallNode relevantCallerFrame = this.getRelevantCallerFrame();
            if (this.lastCallWasSuper(relevantCallerFrame)) {
                return this.coreExceptions().noMethodErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter.SUPER_METHOD_ERROR, self, name, args, this);
            }
            Visibility visibility = this.lastCallWasCallingPrivateOrProtectedMethod(self, name, relevantCallerFrame);
            if (visibility != null) {
                if (visibility == Visibility.PRIVATE) {
                    return this.coreExceptions().noMethodErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter.PRIVATE_METHOD_ERROR, self, name, args, this);
                }
                return this.coreExceptions().noMethodErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter.PROTECTED_METHOD_ERROR, self, name, args, this);
            }
            if (this.lastCallWasVCall(relevantCallerFrame)) {
                return this.coreExceptions().nameErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter.NO_LOCAL_VARIABLE_OR_METHOD_ERROR, self, name, this);
            }
            return this.coreExceptions().noMethodErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter.NO_METHOD_ERROR, self, name, args, this);
        }

        private FrameAndCallNode getRelevantCallerFrame() {
            return (FrameAndCallNode)Truffle.getRuntime().iterateFrames(frameInstance -> {
                Node callNode = frameInstance.getCallNode();
                if (callNode == null) {
                    return null;
                }
                SuperCallNode superCallNode = (SuperCallNode)((Object)((Object)NodeUtil.findParent((Node)callNode, SuperCallNode.class)));
                Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                InternalMethod method = RubyArguments.tryGetMethod(frame);
                String superMethodName = method == null ? "(unknown)" : method.getName();
                if (superCallNode != null && superMethodName.equals("method_missing")) {
                    return null;
                }
                return new FrameAndCallNode(frame, callNode);
            });
        }

        private boolean lastCallWasSuper(FrameAndCallNode callerFrame) {
            SuperCallNode superCallNode = (SuperCallNode)((Object)NodeUtil.findParent((Node)callerFrame.callNode, SuperCallNode.class));
            return superCallNode != null;
        }

        private Visibility lastCallWasCallingPrivateOrProtectedMethod(Object self, String name, FrameAndCallNode callerFrame) {
            DeclarationContext declarationContext = RubyArguments.tryGetDeclarationContext(callerFrame.frame);
            InternalMethod method = ModuleOperations.lookupMethodUncached(MetaClassNode.executeUncached(self), name, declarationContext);
            if (method != null && !method.isUndefined()) {
                assert (method.getVisibility() == Visibility.PRIVATE || method.getVisibility() == Visibility.PROTECTED);
                return method.getVisibility();
            }
            return null;
        }

        private boolean lastCallWasVCall(FrameAndCallNode callerFrame) {
            RubyCallNode callNode = (RubyCallNode)NodeUtil.findParent((Node)callerFrame.callNode, RubyCallNode.class);
            return callNode != null && callNode.isVCall();
        }

        private static final class FrameAndCallNode {
            final Frame frame;
            final Node callNode;

            private FrameAndCallNode(Frame frame, Node callNode) {
                this.frame = frame;
                this.callNode = callNode;
            }
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class InstanceExecBlockNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, ArgumentsDescriptor var2, Object var3, Object[] var4, RubyProc var5);

        @Specialization
        static Object instanceExec(Node node, ArgumentsDescriptor descriptor, Object self, Object[] arguments, RubyProc block, @Cached CallBlockNode callBlockNode) {
            DeclarationContext declarationContext = new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.SingletonClassOfSelfDefaultDefinee(self), block.declarationContext.getRefinements());
            return callBlockNode.executeCallBlock(node, declarationContext, block, self, nil, descriptor, arguments);
        }
    }

    @CoreMethod(names={"instance_exec"}, needsBlock=true, rest=true)
    public static abstract class InstanceExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallBlockNode callBlockNode = CallBlockNode.create();

        @Specialization
        Object instanceExec(VirtualFrame frame, Object receiver, Object[] arguments, RubyProc block) {
            DeclarationContext declarationContext = new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.SingletonClassOfSelfDefaultDefinee(receiver), block.declarationContext.getRefinements());
            ArgumentsDescriptor descriptor = RubyArguments.getDescriptor((Frame)frame);
            return this.callBlockNode.executeCallBlock(this, declarationContext, block, receiver, nil, descriptor, arguments);
        }

        @Specialization
        Object instanceExec(Object receiver, Object[] arguments, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().localJumpError("no block given", this));
        }
    }

    @CoreMethod(names={"instance_eval"}, needsBlock=true, optional=3, alwaysInlined=true)
    @GenerateUncached
    public static abstract class InstanceEvalNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"isBlockProvided(rubyArgs)"})
        Object evalWithBlock(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached InstanceExecBlockNode instanceExecNode, @Cached @Cached.Exclusive InlinedBranchProfile wrongNumberOfArgumentsProfile) {
            int count = RubyArguments.getPositionalArgumentsCount(rubyArgs);
            if (count > 0) {
                wrongNumberOfArgumentsProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(count, 0, this));
            }
            Object block = RubyArguments.getBlock(rubyArgs);
            return instanceExecNode.execute(this, NoKeywordArgumentsDescriptor.INSTANCE, self, new Object[]{self}, (RubyProc)block);
        }

        @Specialization(guards={"!isBlockProvided(rubyArgs)"})
        static Object evalWithString(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Exclusive InlinedBranchProfile zeroNumberOfArguments, @Cached RubyStringLibrary strings, @Cached ToJavaStringNode toJavaStringNode, @Cached ToStrNode toStrNode, @Cached ToIntNode toIntNode, @Cached IndirectCallNode callNode, @Bind(value="this") Node node) {
            String fileName = InstanceEvalNode.coreStrings((Node)node).EVAL_FILENAME_STRING.toString();
            int line = 1;
            int count = RubyArguments.getPositionalArgumentsCount(rubyArgs);
            if (count == 0) {
                zeroNumberOfArguments.enter(node);
                throw new RaiseException(InstanceEvalNode.getContext(node), InstanceEvalNode.coreExceptions(node).argumentError(0, 1, 2, node));
            }
            Object sourceCode = toStrNode.execute(node, RubyArguments.getArgument(rubyArgs, 0));
            if (count >= 2) {
                fileName = toJavaStringNode.execute(node, toStrNode.execute(node, RubyArguments.getArgument(rubyArgs, 1)));
            }
            if (count >= 3) {
                line = toIntNode.execute(RubyArguments.getArgument(rubyArgs, 2));
            }
            InstanceEvalNode.needCallerFrame(node, callerFrame, target);
            return InstanceEvalNode.instanceEvalHelper(node, callerFrame.materialize(), self, strings.getTString(node, sourceCode), strings.getEncoding(node, sourceCode), fileName, line, callNode);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object instanceEvalHelper(Node node, MaterializedFrame callerFrame, Object receiver, AbstractTruffleString code, RubyEncoding encoding, String fileNameString, int line, IndirectCallNode callNode) {
            RubySource source = EvalLoader.createEvalSource(InstanceEvalNode.getContext(node), code, encoding, "instance_eval", fileNameString, line, node);
            LexicalScope callerLexicalScope = RubyArguments.getMethod((Frame)callerFrame).getLexicalScope();
            LexicalScope lexicalScope = InstanceEvalNode.prependReceiverClassToScope(callerLexicalScope, receiver);
            RootCallTarget callTarget = InstanceEvalNode.getContext(node).getCodeLoader().parse(source, ParserContext.INSTANCE_EVAL, callerFrame, lexicalScope, node);
            DeclarationContext declarationContext = new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.SingletonClassOfSelfDefaultDefinee(receiver), DeclarationContext.NO_REFINEMENTS);
            CodeLoader.DeferredCall deferredCall = InstanceEvalNode.getContext(node).getCodeLoader().prepareExecute(callTarget, ParserContext.INSTANCE_EVAL, declarationContext, callerFrame, receiver, lexicalScope);
            return deferredCall.call(callNode);
        }

        private static LexicalScope prependReceiverClassToScope(LexicalScope callerLexicalScope, Object receiver) {
            RubyClass singletonClass;
            RubyClass logicalClass = LogicalClassNode.getUncached().execute(receiver);
            LexicalScope lexicalScope = new LexicalScope(callerLexicalScope, logicalClass, true);
            if (CanHaveSingletonClassNode.executeUncached(receiver) && (singletonClass = SingletonClassNode.getUncached().execute(receiver)) != logicalClass) {
                lexicalScope = new LexicalScope(lexicalScope, singletonClass, true);
            }
            return lexicalScope;
        }
    }

    @CoreMethod(names={"initialize"}, alwaysInlined=true)
    @GenerateUncached
    public static abstract class InitializeNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object initialize(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target) {
            return nil;
        }
    }

    @GenerateUncached
    public static abstract class ObjectIDNode
    extends RubyBaseNode {
        public static ObjectIDNode getUncached() {
            return BasicObjectNodesFactory.ObjectIDNodeGen.getUncached();
        }

        public abstract Object execute(Object var1);

        public abstract long execute(RubyDynamicObject var1);

        @Specialization
        long objectIDNil(Nil nil) {
            return 2L;
        }

        @Specialization(guards={"value"})
        long objectIDTrue(boolean value) {
            return 6L;
        }

        @Specialization(guards={"!value"})
        long objectIDFalse(boolean value) {
            return 0L;
        }

        @Specialization
        long objectID(int value) {
            return ObjectIDOperations.smallFixnumToID(value);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        long objectIDSmallFixnumOverflow(long value) throws ArithmeticException {
            return ObjectIDOperations.smallFixnumToIDOverflow(value);
        }

        @Specialization(replaces={"objectIDSmallFixnumOverflow"})
        static Object objectIDLong(long value, @Cached InlinedCountingConditionProfile smallProfile, @Bind(value="this") Node node) {
            if (smallProfile.profile(node, ObjectIDOperations.isSmallFixnum(value))) {
                return ObjectIDOperations.smallFixnumToID(value);
            }
            return ObjectIDOperations.largeFixnumToID(value);
        }

        @Specialization
        RubyBignum objectID(double value) {
            return ObjectIDOperations.floatToID(value);
        }

        @Specialization(guards={"!isNil(object)"})
        long objectIDImmutable(ImmutableRubyObject object) {
            long id = object.getObjectId();
            if (id == 0L) {
                long newId = this.getLanguage().getNextObjectID();
                object.setObjectId(newId);
                return newId;
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="getDynamicObjectCacheLimit()")
        long objectID(RubyDynamicObject object, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
            long id = ObjectSpaceManager.readObjectID(object, objectLibrary);
            if (id == 0L) {
                if (objectLibrary.isShared((DynamicObject)object)) {
                    RubyDynamicObject rubyDynamicObject = object;
                    synchronized (rubyDynamicObject) {
                        long existingID = ObjectSpaceManager.readObjectID(object, objectLibrary);
                        if (existingID != 0L) {
                            return existingID;
                        }
                        long newId = this.getContext().getObjectSpaceManager().getNextObjectID();
                        objectLibrary.putLong((DynamicObject)object, (Object)Layouts.OBJECT_ID_IDENTIFIER, newId);
                        return newId;
                    }
                }
                long newId = this.getContext().getObjectSpaceManager().getNextObjectID();
                objectLibrary.putLong((DynamicObject)object, (Object)Layouts.OBJECT_ID_IDENTIFIER, newId);
                return newId;
            }
            return id;
        }

        @Specialization(guards={"isForeignObject(value)"}, limit="getInteropCacheLimit()")
        static int objectIDForeign(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            if (interop.hasIdentity(value)) {
                try {
                    return interop.identityHashCode(value);
                }
                catch (UnsupportedMessageException e) {
                    throw translateInteropException.execute(node, (InteropException)((Object)e));
                }
            }
            return System.identityHashCode(value);
        }
    }

    @CoreMethod(names={"__id__"})
    @NodeChild(value="valueNode", type=RubyNode.class)
    public static abstract class BasicObjectObjectIDNode
    extends CoreMethodNode {
        @Specialization
        Object objectIDNode(Object value, @Cached ObjectIDNode objectIDNode) {
            return objectIDNode.execute(value);
        }
    }

    @CoreMethod(names={"equal?", "=="}, required=1)
    @GenerateNodeFactory
    public static abstract class BasicObjectEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean equal(Object a, Object b, @Cached ReferenceEqualNode referenceEqualNode) {
            return referenceEqualNode.execute(this, a, b);
        }
    }

    @CoreMethod(names={"!="}, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class NotEqualNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        boolean equal(Frame frame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached BooleanCastNode booleanCastNode, @Cached DispatchNode equalNode) {
            Object object = RubyArguments.getArgument(rubyArgs, 0);
            return !booleanCastNode.execute(this, equalNode.call(self, "==", object));
        }
    }

    @CoreMethod(names={"!"})
    public static abstract class NotNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean not(Object value, @Cached BooleanCastNode cast) {
            return !cast.execute(this, value);
        }
    }
}

