/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.math.BigInteger;
import org.truffleruby.core.cast.BigIntegerCastNode;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyTypesGen;

@GeneratedBy(value=BigIntegerCastNode.class)
public final class BigIntegerCastNodeGen {
    @NeverDefault
    public static BigIntegerCastNode inline(@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=BigIntegerCastNode.class)
    @DenyReplace
    private static final class Inlined
    extends BigIntegerCastNode
    implements UnadoptableNode {
        private final InlineSupport.StateField state_0_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(BigIntegerCastNode.class));
            this.state_0_ = target.getState(0, 6);
        }

        @Override
        public BigInteger execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0xF) != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return this.doInt(arg1Value_);
                }
                if ((state_0 & 2) != 0 && RubyTypesGen.isImplicitLong((state_0 & 0x30) >>> 4, arg1Value)) {
                    long arg1Value_ = RubyTypesGen.asImplicitLong((state_0 & 0x30) >>> 4, arg1Value);
                    return this.doLong(arg1Value_);
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof RubyBignum) {
                    RubyBignum arg1Value_ = (RubyBignum)arg1Value;
                    return this.doBignum(arg1Value_);
                }
                if ((state_0 & 8) != 0 && !RubyGuards.isRubyInteger(arg1Value)) {
                    return this.doBasicObject(arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private BigInteger executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 1);
                return this.doInt(arg1Value_);
            }
            int longCast1 = RubyTypesGen.specializeImplicitLong(arg1Value);
            if (longCast1 != 0) {
                long arg1Value_ = RubyTypesGen.asImplicitLong(longCast1, arg1Value);
                state_0 |= longCast1 << 4;
                this.state_0_.set(arg0Value, state_0 |= 2);
                return this.doLong(arg1Value_);
            }
            if (arg1Value instanceof RubyBignum) {
                RubyBignum arg1Value_ = (RubyBignum)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 4);
                return this.doBignum(arg1Value_);
            }
            if (!RubyGuards.isRubyInteger(arg1Value)) {
                this.state_0_.set(arg0Value, state_0 |= 8);
                return this.doBasicObject(arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
        }
    }
}

