/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.Ptr;
import org.graalvm.shadowed.org.jcodings.transcode.EConv;
import org.graalvm.shadowed.org.jcodings.transcode.EConvResult;
import org.graalvm.shadowed.org.jcodings.transcode.Transcoder;
import org.graalvm.shadowed.org.jcodings.transcode.TranscoderDB;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.RubyEncodingConverter;
import org.truffleruby.core.encoding.TranscodingManager;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.EncodingUtils;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNodeWithExecute;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="Encoding::Converter", isClass=true)
public abstract class EncodingConverterNodes {

    @CoreMethod(names={"replacement="}, required=1)
    @NodeChildren(value={@NodeChild(value="encodingConverter", type=RubyNode.class), @NodeChild(value="replacement", type=RubyBaseNodeWithExecute.class)})
    public static abstract class EncodingConverterSetReplacementNode
    extends CoreMethodNode {
        @Specialization(guards={"libReplacement.isRubyString(this, replacement)"}, limit="1")
        static Object setReplacement(RubyEncodingConverter encodingConverter, Object replacement, @Cached InlinedBranchProfile errorProfile, @Cached TruffleString.GetInternalByteArrayNode bytesNode, @Cached RubyStringLibrary libReplacement, @Cached ToStrNode toStrNode, @Bind(value="this") Node node) {
            Object replacementAsString = toStrNode.execute(node, replacement);
            AbstractTruffleString tstring = libReplacement.getTString(node, replacementAsString);
            RubyEncoding encoding = libReplacement.getEncoding(node, replacementAsString);
            InternalByteArray byteArray = bytesNode.execute(tstring, encoding.tencoding);
            int ret = EncodingConverterSetReplacementNode.setReplacement(encodingConverter.econv, byteArray.getArray(), byteArray.getOffset(), byteArray.getLength(), encoding.jcoding.getName());
            if (ret == -1) {
                errorProfile.enter(node);
                throw new RaiseException(EncodingConverterSetReplacementNode.getContext(node), EncodingConverterSetReplacementNode.getContext(node).getCoreExceptions().encodingUndefinedConversionError(node));
            }
            return replacementAsString;
        }

        @CompilerDirectives.TruffleBoundary
        private static int setReplacement(EConv ec, byte[] bytes, int offset, int len, byte[] encodingName) {
            return ec.setReplacement(bytes, offset, len, encodingName);
        }
    }

    @CoreMethod(names={"replacement"})
    public static abstract class EncodingConverterReplacementNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString getReplacement(RubyEncodingConverter encodingConverter) {
            EConv ec = encodingConverter.econv;
            int ret = ec.makeReplacement();
            if (ret == -1) {
                throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().encodingUndefinedConversionError(this));
            }
            byte[] bytes = ArrayUtils.extractRange(ec.replacementString, 0, ec.replacementLength);
            String encodingName = new String(ec.replacementEncoding, StandardCharsets.US_ASCII);
            RubyEncoding encoding = this.getContext().getEncodingManager().getRubyEncoding(encodingName);
            return this.createString(this.fromByteArrayNode, bytes, encoding);
        }
    }

    @CoreMethod(names={"primitive_errinfo"})
    public static abstract class EncodingConverterErrinfoNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray encodingConverterLastError(RubyEncodingConverter encodingConverter, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            EConv ec = encodingConverter.econv;
            EConv.LastError lastError = ec.lastError;
            Object[] ret = new Object[]{this.getSymbol(lastError.getResult().symbolicName()), nil, nil, nil, nil};
            if (lastError.getSource() != null) {
                ret[1] = this.createString(fromByteArrayNode, lastError.getSource(), Encodings.BINARY);
            }
            if (lastError.getDestination() != null) {
                ret[2] = this.createString(fromByteArrayNode, lastError.getDestination(), Encodings.BINARY);
            }
            if (lastError.getErrorBytes() != null) {
                TruffleString errorTString = TStringBuilder.create(lastError.getErrorBytes(), lastError.getErrorBytesP(), lastError.getErrorBytesLength()).toTStringUnsafe(fromByteArrayNode);
                ret[3] = this.createString(errorTString, Encodings.BINARY);
                TruffleString readAgainTString = TStringBuilder.create(lastError.getErrorBytes(), lastError.getErrorBytesP() + lastError.getErrorBytesLength(), lastError.getReadAgainLength()).toTStringUnsafe(fromByteArrayNode);
                ret[4] = this.createString(readAgainTString, Encodings.BINARY);
            }
            return this.createArray(ret);
        }
    }

    @Primitive(name="encoding_converter_last_error")
    public static abstract class EncodingConverterLastErrorNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object encodingConverterLastError(RubyEncodingConverter encodingConverter, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            EConv ec = encodingConverter.econv;
            EConv.LastError lastError = ec.lastError;
            if (lastError.getResult() != EConvResult.InvalidByteSequence && lastError.getResult() != EConvResult.IncompleteInput && lastError.getResult() != EConvResult.UndefinedConversion) {
                return nil;
            }
            boolean readAgain = lastError.getReadAgainLength() != 0;
            int size = readAgain ? 5 : 4;
            Object[] store = new Object[size];
            store[0] = this.eConvResultToSymbol(lastError.getResult());
            store[1] = this.createString(fromByteArrayNode, lastError.getSource(), Encodings.BINARY);
            store[2] = this.createString(fromByteArrayNode, lastError.getDestination(), Encodings.BINARY);
            TruffleString errorTString = TStringBuilder.create(lastError.getErrorBytes(), lastError.getErrorBytesP(), lastError.getErrorBytesLength()).toTStringUnsafe(fromByteArrayNode);
            store[3] = this.createString(errorTString, Encodings.BINARY);
            if (readAgain) {
                TruffleString readAgainTString = TStringBuilder.create(lastError.getErrorBytes(), lastError.getErrorBytesP() + lastError.getErrorBytesLength(), lastError.getReadAgainLength()).toTStringUnsafe(fromByteArrayNode);
                store[4] = this.createString(readAgainTString, Encodings.BINARY);
            }
            return this.createArray(store);
        }

        private RubySymbol eConvResultToSymbol(EConvResult result) {
            switch (result) {
                case InvalidByteSequence: {
                    return this.getSymbol("invalid_byte_sequence");
                }
                case UndefinedConversion: {
                    return this.getSymbol("undefined_conversion");
                }
                case DestinationBufferFull: {
                    return this.getSymbol("destination_buffer_full");
                }
                case SourceBufferEmpty: {
                    return this.getSymbol("source_buffer_empty");
                }
                case Finished: {
                    return this.getSymbol("finished");
                }
                case AfterOutput: {
                    return this.getSymbol("after_output");
                }
                case IncompleteInput: {
                    return this.getSymbol("incomplete_input");
                }
            }
            throw new UnsupportedOperationException(StringUtils.format("Unknown EConv result: %s", result));
        }
    }

    @CoreMethod(names={"putback"}, optional=1, lowerFixnum={1})
    public static abstract class EncodingConverterPutbackNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

        @Specialization
        RubyString encodingConverterPutback(RubyEncodingConverter encodingConverter, int maxBytes, @Cached @Cached.Shared DispatchNode sourceEncodingNode) {
            EConv ec = encodingConverter.econv;
            int putbackable = ec.putbackable();
            return this.putback(encodingConverter, putbackable < maxBytes ? putbackable : maxBytes, sourceEncodingNode);
        }

        @Specialization
        RubyString encodingConverterPutback(RubyEncodingConverter encodingConverter, NotProvided maxBytes, @Cached @Cached.Shared DispatchNode sourceEncodingNode) {
            EConv ec = encodingConverter.econv;
            return this.putback(encodingConverter, ec.putbackable(), sourceEncodingNode);
        }

        private RubyString putback(RubyEncodingConverter encodingConverter, int n, DispatchNode sourceEncodingNode) {
            EConv ec = encodingConverter.econv;
            byte[] bytes = new byte[n];
            ec.putback(bytes, 0, n);
            RubyEncoding sourceEncoding = (RubyEncoding)sourceEncodingNode.call((Object)encodingConverter, "source_encoding");
            return this.createString(this.fromByteArrayNode, bytes, sourceEncoding);
        }
    }

    @Primitive(name="encoding_converter_primitive_convert", lowerFixnum={3, 4, 5})
    public static abstract class PrimitiveConvertNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object encodingConverterPrimitiveConvert(RubyEncodingConverter encodingConverter, RubyString source, RubyString target, int offset, int size, int options, @Cached RubyStringLibrary libString, @Cached DispatchNode destinationEncodingNode, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
            EConvResult res;
            boolean growOutputBuffer;
            TruffleString.Encoding tencoding = libString.getTEncoding(this, (Object)source);
            AbstractTruffleString tstring = source.tstring;
            TStringBuilder outBytes = TStringBuilder.create(target);
            Ptr inPtr = new Ptr();
            Ptr outPtr = new Ptr();
            EConv ec = encodingConverter.econv;
            boolean changeOffset = offset == 0;
            boolean bl = growOutputBuffer = size == -1;
            if (size == -1) {
                int minSize = 16;
                size = Math.max(minSize, source.byteLengthUncached());
            }
            while (true) {
                if (changeOffset) {
                    offset = outBytes.getLength();
                }
                if (outBytes.getLength() < offset) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("output offset too big", this));
                }
                long outputByteEnd = (long)offset + (long)size;
                if (outputByteEnd > Integer.MAX_VALUE) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("output offset + bytesize too big", this));
                }
                outBytes.unsafeEnsureSpace((int)outputByteEnd);
                InternalByteArray sourceBytes = getInternalByteArrayNode.execute(tstring, tencoding);
                inPtr.p = sourceBytes.getOffset();
                outPtr.p = offset;
                res = ec.convert(sourceBytes.getArray(), inPtr, sourceBytes.getEnd(), outBytes.getUnsafeBytes(), outPtr, outPtr.p + size, options);
                outBytes.setLength(outPtr.p);
                int inputOffset = inPtr.p - sourceBytes.getOffset();
                tstring = substringNode.execute(source.tstring, inputOffset, source.byteLengthUncached() - inputOffset, tencoding, true);
                source.setTString(tstring);
                if (!growOutputBuffer || res != EConvResult.DestinationBufferFull) break;
                if (0x3FFFFFFF < size) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("too long conversion result", this));
                }
                size *= 2;
            }
            if (ec.destinationEncoding != null) {
                outBytes.setEncoding(Encodings.getBuiltInEncoding(ec.destinationEncoding));
            }
            RubyEncoding destinationEncoding = (RubyEncoding)destinationEncodingNode.call((Object)encodingConverter, "destination_encoding");
            target.setTString((AbstractTruffleString)outBytes.toTString(), destinationEncoding);
            return this.getSymbol(res.symbolicName());
        }
    }

    @Primitive(name="encoding_transcoders_from_encoding")
    public static abstract class TranscodersFromEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object search(RubySymbol source) {
            Set<String> transcoders = TranscodingManager.allDirectTranscoderPaths.get(source.getString());
            if (transcoders == null) {
                return nil;
            }
            Object[] destinations = new Object[transcoders.size()];
            int i = 0;
            for (String transcoder : transcoders) {
                destinations[i++] = this.getSymbol(transcoder);
            }
            return this.createArray(destinations);
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyEncodingConverter allocate(RubyClass rubyClass) {
            Shape shape = this.getLanguage().encodingConverterShape;
            RubyEncodingConverter instance = new RubyEncodingConverter(rubyClass, shape, null);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"initialize_jcodings"}, required=2, optional=1, lowerFixnum={3}, visibility=Visibility.PRIVATE)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object initialize(RubyEncodingConverter self, RubyEncoding source, RubyEncoding destination, int options) {
            Encoding sourceEncoding = source.jcoding;
            Encoding destinationEncoding = destination.jcoding;
            EConv econv = TranscoderDB.open((byte[])sourceEncoding.getName(), (byte[])destinationEncoding.getName(), (int)this.toJCodingFlags(options));
            if (econv == null) {
                return nil;
            }
            econv.sourceEncoding = sourceEncoding;
            econv.destinationEncoding = destinationEncoding;
            self.econv = econv;
            Object[] ret = new Object[econv.numTranscoders + 1];
            int retIndex = 0;
            for (int i = 0; i < econv.numTranscoders; ++i) {
                Transcoder transcoder = econv.elements[i].transcoding.transcoder;
                if (EncodingUtils.DECORATOR_P(transcoder.getSource(), transcoder.getDestination())) continue;
                byte[] segmentSource = transcoder.getSource();
                ret[retIndex++] = this.getSymbol(StringUtils.toUpperCase(new String(segmentSource, StandardCharsets.US_ASCII)));
            }
            int retSize = retIndex + 1;
            if (retSize != ret.length) {
                ret = ArrayUtils.extractRange(ret, 0, retSize);
            }
            byte[] destinationName = destinationEncoding.getName();
            ret[retIndex] = this.getSymbol(StringUtils.toUpperCase(new String(destinationName, StandardCharsets.US_ASCII)));
            return this.createArray(ret);
        }

        private int toJCodingFlags(int flags) {
            if ((flags & 0x8000) != 0) {
                flags |= 0x30;
            }
            if ((flags & 0x10000) != 0) {
                flags |= 0x30;
            }
            return flags;
        }
    }
}

