/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.cast.ToStrNodeGen;
import org.truffleruby.core.encoding.EncodingConverterNodes;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.RubyEncodingConverter;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNodeWithExecute;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyTypes;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;

@GeneratedBy(value=EncodingConverterNodes.class)
public final class EncodingConverterNodesFactory {
    public static List<NodeFactory<? extends RubyContextSourceNode>> getFactories() {
        return List.of(InitializeNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), TranscodersFromEncodingNodeFactory.getInstance(), PrimitiveConvertNodeFactory.getInstance(), EncodingConverterPutbackNodeFactory.getInstance(), EncodingConverterLastErrorNodeFactory.getInstance(), EncodingConverterErrinfoNodeFactory.getInstance(), EncodingConverterReplacementNodeFactory.getInstance(), EncodingConverterSetReplacementNodeFactory.getInstance());
    }

    @GeneratedBy(value=EncodingConverterNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<EncodingConverterNodes.InitializeNode> {
        private static final InitializeNodeFactory INITIALIZE_NODE_FACTORY_INSTANCE = new InitializeNodeFactory();

        private InitializeNodeFactory() {
        }

        public Class<EncodingConverterNodes.InitializeNode> getNodeClass() {
            return EncodingConverterNodes.InitializeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.InitializeNode> getInstance() {
            return INITIALIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.InitializeNode create(RubyNode[] argumentNodes) {
            return new InitializeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends EncodingConverterNodes.InitializeNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @Node.Child
            private RubyNode argumentNodes3_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private InitializeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
                this.argumentNodes3_ = argumentNodes != null && 3 < argumentNodes.length ? argumentNodes[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                Object argumentNodes3Value_ = this.argumentNodes3_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value__ = (RubyEncodingConverter)((Object)argumentNodes0Value_);
                    if (argumentNodes1Value_ instanceof RubyEncoding) {
                        RubyEncoding argumentNodes1Value__ = (RubyEncoding)argumentNodes1Value_;
                        if (argumentNodes2Value_ instanceof RubyEncoding) {
                            RubyEncoding argumentNodes2Value__ = (RubyEncoding)argumentNodes2Value_;
                            if (argumentNodes3Value_ instanceof Integer) {
                                int argumentNodes3Value__ = (Integer)argumentNodes3Value_;
                                return this.initialize(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__, argumentNodes3Value__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value, Object argumentNodes3Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value_ = (RubyEncodingConverter)((Object)argumentNodes0Value);
                    if (argumentNodes1Value instanceof RubyEncoding) {
                        RubyEncoding argumentNodes1Value_ = (RubyEncoding)argumentNodes1Value;
                        if (argumentNodes2Value instanceof RubyEncoding) {
                            RubyEncoding argumentNodes2Value_ = (RubyEncoding)argumentNodes2Value;
                            if (argumentNodes3Value instanceof Integer) {
                                int argumentNodes3Value_ = (Integer)argumentNodes3Value;
                                this.state_0_ = state_0 |= 1;
                                return this.initialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_, this.argumentNodes3_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value, argumentNodes3Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<EncodingConverterNodes.AllocateNode> {
        private static final AllocateNodeFactory ALLOCATE_NODE_FACTORY_INSTANCE = new AllocateNodeFactory();

        private AllocateNodeFactory() {
        }

        public Class<EncodingConverterNodes.AllocateNode> getNodeClass() {
            return EncodingConverterNodes.AllocateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.AllocateNode> getInstance() {
            return ALLOCATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.AllocateNode create(RubyNode[] argumentNodes) {
            return new AllocateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends EncodingConverterNodes.AllocateNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AllocateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    return this.allocate(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyEncodingConverter executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.allocate(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.TranscodersFromEncodingNode.class)
    public static final class TranscodersFromEncodingNodeFactory
    implements NodeFactory<EncodingConverterNodes.TranscodersFromEncodingNode> {
        private static final TranscodersFromEncodingNodeFactory TRANSCODERS_FROM_ENCODING_NODE_FACTORY_INSTANCE = new TranscodersFromEncodingNodeFactory();

        private TranscodersFromEncodingNodeFactory() {
        }

        public Class<EncodingConverterNodes.TranscodersFromEncodingNode> getNodeClass() {
            return EncodingConverterNodes.TranscodersFromEncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.TranscodersFromEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return TranscodersFromEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.TranscodersFromEncodingNode> getInstance() {
            return TRANSCODERS_FROM_ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.TranscodersFromEncodingNode create(RubyNode[] argumentNodes) {
            return new TranscodersFromEncodingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.TranscodersFromEncodingNode.class)
        public static final class TranscodersFromEncodingNodeGen
        extends EncodingConverterNodes.TranscodersFromEncodingNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private TranscodersFromEncodingNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubySymbol) {
                    RubySymbol argumentNodes0Value__ = (RubySymbol)argumentNodes0Value_;
                    return this.search(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubySymbol) {
                    RubySymbol argumentNodes0Value_ = (RubySymbol)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.search(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.PrimitiveConvertNode.class)
    public static final class PrimitiveConvertNodeFactory
    implements NodeFactory<EncodingConverterNodes.PrimitiveConvertNode> {
        private static final PrimitiveConvertNodeFactory PRIMITIVE_CONVERT_NODE_FACTORY_INSTANCE = new PrimitiveConvertNodeFactory();

        private PrimitiveConvertNodeFactory() {
        }

        public Class<EncodingConverterNodes.PrimitiveConvertNode> getNodeClass() {
            return EncodingConverterNodes.PrimitiveConvertNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.PrimitiveConvertNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PrimitiveConvertNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.PrimitiveConvertNode> getInstance() {
            return PRIMITIVE_CONVERT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.PrimitiveConvertNode create(RubyNode[] argumentNodes) {
            return new PrimitiveConvertNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.PrimitiveConvertNode.class)
        public static final class PrimitiveConvertNodeGen
        extends EncodingConverterNodes.PrimitiveConvertNode {
            private static final InlineSupport.StateField STATE_0_PrimitiveConvertNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final RubyStringLibrary INLINED_LIB_STRING_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_PrimitiveConvertNode_UPDATER.subUpdater(1, 6)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @Node.Child
            private RubyNode argumentNodes3_;
            @Node.Child
            private RubyNode argumentNodes4_;
            @Node.Child
            private RubyNode argumentNodes5_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private DispatchNode destinationEncodingNode_;
            @Node.Child
            private TruffleString.SubstringByteIndexNode substringNode_;
            @Node.Child
            private TruffleString.GetInternalByteArrayNode getInternalByteArrayNode_;

            private PrimitiveConvertNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
                this.argumentNodes3_ = argumentNodes != null && 3 < argumentNodes.length ? argumentNodes[3] : null;
                this.argumentNodes4_ = argumentNodes != null && 4 < argumentNodes.length ? argumentNodes[4] : null;
                this.argumentNodes5_ = argumentNodes != null && 5 < argumentNodes.length ? argumentNodes[5] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_, this.argumentNodes3_, this.argumentNodes4_, this.argumentNodes5_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                Object argumentNodes3Value_ = this.argumentNodes3_.execute(frameValue);
                Object argumentNodes4Value_ = this.argumentNodes4_.execute(frameValue);
                Object argumentNodes5Value_ = this.argumentNodes5_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value__ = (RubyEncodingConverter)((Object)argumentNodes0Value_);
                    if (argumentNodes1Value_ instanceof RubyString) {
                        RubyString argumentNodes1Value__ = (RubyString)((Object)argumentNodes1Value_);
                        if (argumentNodes2Value_ instanceof RubyString) {
                            RubyString argumentNodes2Value__ = (RubyString)((Object)argumentNodes2Value_);
                            if (argumentNodes3Value_ instanceof Integer) {
                                int argumentNodes3Value__ = (Integer)argumentNodes3Value_;
                                if (argumentNodes4Value_ instanceof Integer) {
                                    int argumentNodes4Value__ = (Integer)argumentNodes4Value_;
                                    if (argumentNodes5Value_ instanceof Integer) {
                                        TruffleString.GetInternalByteArrayNode getInternalByteArrayNode__;
                                        TruffleString.SubstringByteIndexNode substringNode__;
                                        int argumentNodes5Value__ = (Integer)argumentNodes5Value_;
                                        DispatchNode destinationEncodingNode__ = this.destinationEncodingNode_;
                                        if (destinationEncodingNode__ != null && (substringNode__ = this.substringNode_) != null && (getInternalByteArrayNode__ = this.getInternalByteArrayNode_) != null) {
                                            return this.encodingConverterPrimitiveConvert(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__, argumentNodes3Value__, argumentNodes4Value__, argumentNodes5Value__, INLINED_LIB_STRING_, destinationEncodingNode__, substringNode__, getInternalByteArrayNode__);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_, argumentNodes4Value_, argumentNodes5Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value, Object argumentNodes3Value, Object argumentNodes4Value, Object argumentNodes5Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value_ = (RubyEncodingConverter)((Object)argumentNodes0Value);
                    if (argumentNodes1Value instanceof RubyString) {
                        RubyString argumentNodes1Value_ = (RubyString)((Object)argumentNodes1Value);
                        if (argumentNodes2Value instanceof RubyString) {
                            RubyString argumentNodes2Value_ = (RubyString)((Object)argumentNodes2Value);
                            if (argumentNodes3Value instanceof Integer) {
                                int argumentNodes3Value_ = (Integer)argumentNodes3Value;
                                if (argumentNodes4Value instanceof Integer) {
                                    int argumentNodes4Value_ = (Integer)argumentNodes4Value;
                                    if (argumentNodes5Value instanceof Integer) {
                                        int argumentNodes5Value_ = (Integer)argumentNodes5Value;
                                        DispatchNode destinationEncodingNode__ = (DispatchNode)this.insert(DispatchNode.create());
                                        Objects.requireNonNull(destinationEncodingNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        VarHandle.storeStoreFence();
                                        this.destinationEncodingNode_ = destinationEncodingNode__;
                                        TruffleString.SubstringByteIndexNode substringNode__ = (TruffleString.SubstringByteIndexNode)this.insert((Node)TruffleString.SubstringByteIndexNode.create());
                                        Objects.requireNonNull(substringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        VarHandle.storeStoreFence();
                                        this.substringNode_ = substringNode__;
                                        TruffleString.GetInternalByteArrayNode getInternalByteArrayNode__ = (TruffleString.GetInternalByteArrayNode)this.insert((Node)TruffleString.GetInternalByteArrayNode.create());
                                        Objects.requireNonNull(getInternalByteArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        VarHandle.storeStoreFence();
                                        this.getInternalByteArrayNode_ = getInternalByteArrayNode__;
                                        this.state_0_ = state_0 |= 1;
                                        return this.encodingConverterPrimitiveConvert(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_, argumentNodes4Value_, argumentNodes5Value_, INLINED_LIB_STRING_, destinationEncodingNode__, substringNode__, getInternalByteArrayNode__);
                                    }
                                }
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_, this.argumentNodes3_, this.argumentNodes4_, this.argumentNodes5_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value, argumentNodes3Value, argumentNodes4Value, argumentNodes5Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.EncodingConverterPutbackNode.class)
    public static final class EncodingConverterPutbackNodeFactory
    implements NodeFactory<EncodingConverterNodes.EncodingConverterPutbackNode> {
        private static final EncodingConverterPutbackNodeFactory ENCODING_CONVERTER_PUTBACK_NODE_FACTORY_INSTANCE = new EncodingConverterPutbackNodeFactory();

        private EncodingConverterPutbackNodeFactory() {
        }

        public Class<EncodingConverterNodes.EncodingConverterPutbackNode> getNodeClass() {
            return EncodingConverterNodes.EncodingConverterPutbackNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.EncodingConverterPutbackNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingConverterPutbackNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.EncodingConverterPutbackNode> getInstance() {
            return ENCODING_CONVERTER_PUTBACK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.EncodingConverterPutbackNode create(RubyNode[] argumentNodes) {
            return new EncodingConverterPutbackNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.EncodingConverterPutbackNode.class)
        public static final class EncodingConverterPutbackNodeGen
        extends EncodingConverterNodes.EncodingConverterPutbackNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private DispatchNode sourceEncodingNode;

            private EncodingConverterPutbackNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value__ = (RubyEncodingConverter)((Object)argumentNodes0Value_);
                    if ((state_0 & 1) != 0 && argumentNodes1Value_ instanceof Integer) {
                        int argumentNodes1Value__ = (Integer)argumentNodes1Value_;
                        DispatchNode sourceEncodingNode_ = this.sourceEncodingNode;
                        if (sourceEncodingNode_ != null) {
                            return this.encodingConverterPutback(argumentNodes0Value__, argumentNodes1Value__, sourceEncodingNode_);
                        }
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNotProvided(argumentNodes1Value_)) {
                        NotProvided argumentNodes1Value__ = RubyTypes.asNotProvided(argumentNodes1Value_);
                        DispatchNode sourceEncodingNode_1 = this.sourceEncodingNode;
                        if (sourceEncodingNode_1 != null) {
                            return this.encodingConverterPutback(argumentNodes0Value__, argumentNodes1Value__, sourceEncodingNode_1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyString executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value_ = (RubyEncodingConverter)((Object)argumentNodes0Value);
                    if (argumentNodes1Value instanceof Integer) {
                        DispatchNode sourceEncodingNode_;
                        int argumentNodes1Value_ = (Integer)argumentNodes1Value;
                        DispatchNode sourceEncodingNode__shared = this.sourceEncodingNode;
                        if (sourceEncodingNode__shared != null) {
                            sourceEncodingNode_ = sourceEncodingNode__shared;
                        } else {
                            sourceEncodingNode_ = (DispatchNode)this.insert(DispatchNode.create());
                            if (sourceEncodingNode_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.sourceEncodingNode == null) {
                            VarHandle.storeStoreFence();
                            this.sourceEncodingNode = sourceEncodingNode_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return this.encodingConverterPutback(argumentNodes0Value_, argumentNodes1Value_, sourceEncodingNode_);
                    }
                    if (RubyTypes.isNotProvided(argumentNodes1Value)) {
                        DispatchNode sourceEncodingNode_1;
                        NotProvided argumentNodes1Value_ = RubyTypes.asNotProvided(argumentNodes1Value);
                        DispatchNode sourceEncodingNode_1_shared = this.sourceEncodingNode;
                        if (sourceEncodingNode_1_shared != null) {
                            sourceEncodingNode_1 = sourceEncodingNode_1_shared;
                        } else {
                            sourceEncodingNode_1 = (DispatchNode)this.insert(DispatchNode.create());
                            if (sourceEncodingNode_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.sourceEncodingNode == null) {
                            VarHandle.storeStoreFence();
                            this.sourceEncodingNode = sourceEncodingNode_1;
                        }
                        this.state_0_ = state_0 |= 2;
                        return this.encodingConverterPutback(argumentNodes0Value_, argumentNodes1Value_, sourceEncodingNode_1);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.EncodingConverterLastErrorNode.class)
    public static final class EncodingConverterLastErrorNodeFactory
    implements NodeFactory<EncodingConverterNodes.EncodingConverterLastErrorNode> {
        private static final EncodingConverterLastErrorNodeFactory ENCODING_CONVERTER_LAST_ERROR_NODE_FACTORY_INSTANCE = new EncodingConverterLastErrorNodeFactory();

        private EncodingConverterLastErrorNodeFactory() {
        }

        public Class<EncodingConverterNodes.EncodingConverterLastErrorNode> getNodeClass() {
            return EncodingConverterNodes.EncodingConverterLastErrorNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.EncodingConverterLastErrorNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingConverterLastErrorNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.EncodingConverterLastErrorNode> getInstance() {
            return ENCODING_CONVERTER_LAST_ERROR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.EncodingConverterLastErrorNode create(RubyNode[] argumentNodes) {
            return new EncodingConverterLastErrorNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.EncodingConverterLastErrorNode.class)
        public static final class EncodingConverterLastErrorNodeGen
        extends EncodingConverterNodes.EncodingConverterLastErrorNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromByteArrayNode fromByteArrayNode_;

            private EncodingConverterLastErrorNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value__ = (RubyEncodingConverter)((Object)argumentNodes0Value_);
                    TruffleString.FromByteArrayNode fromByteArrayNode__ = this.fromByteArrayNode_;
                    if (fromByteArrayNode__ != null) {
                        return this.encodingConverterLastError(argumentNodes0Value__, fromByteArrayNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value_ = (RubyEncodingConverter)((Object)argumentNodes0Value);
                    TruffleString.FromByteArrayNode fromByteArrayNode__ = (TruffleString.FromByteArrayNode)this.insert((Node)TruffleString.FromByteArrayNode.create());
                    Objects.requireNonNull(fromByteArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.fromByteArrayNode_ = fromByteArrayNode__;
                    this.state_0_ = state_0 |= 1;
                    return this.encodingConverterLastError(argumentNodes0Value_, fromByteArrayNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.EncodingConverterErrinfoNode.class)
    public static final class EncodingConverterErrinfoNodeFactory
    implements NodeFactory<EncodingConverterNodes.EncodingConverterErrinfoNode> {
        private static final EncodingConverterErrinfoNodeFactory ENCODING_CONVERTER_ERRINFO_NODE_FACTORY_INSTANCE = new EncodingConverterErrinfoNodeFactory();

        private EncodingConverterErrinfoNodeFactory() {
        }

        public Class<EncodingConverterNodes.EncodingConverterErrinfoNode> getNodeClass() {
            return EncodingConverterNodes.EncodingConverterErrinfoNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.EncodingConverterErrinfoNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingConverterErrinfoNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.EncodingConverterErrinfoNode> getInstance() {
            return ENCODING_CONVERTER_ERRINFO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.EncodingConverterErrinfoNode create(RubyNode[] argumentNodes) {
            return new EncodingConverterErrinfoNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.EncodingConverterErrinfoNode.class)
        public static final class EncodingConverterErrinfoNodeGen
        extends EncodingConverterNodes.EncodingConverterErrinfoNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromByteArrayNode fromByteArrayNode_;

            private EncodingConverterErrinfoNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value__ = (RubyEncodingConverter)((Object)argumentNodes0Value_);
                    TruffleString.FromByteArrayNode fromByteArrayNode__ = this.fromByteArrayNode_;
                    if (fromByteArrayNode__ != null) {
                        return this.encodingConverterLastError(argumentNodes0Value__, fromByteArrayNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyArray executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value_ = (RubyEncodingConverter)((Object)argumentNodes0Value);
                    TruffleString.FromByteArrayNode fromByteArrayNode__ = (TruffleString.FromByteArrayNode)this.insert((Node)TruffleString.FromByteArrayNode.create());
                    Objects.requireNonNull(fromByteArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.fromByteArrayNode_ = fromByteArrayNode__;
                    this.state_0_ = state_0 |= 1;
                    return this.encodingConverterLastError(argumentNodes0Value_, fromByteArrayNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.EncodingConverterReplacementNode.class)
    public static final class EncodingConverterReplacementNodeFactory
    implements NodeFactory<EncodingConverterNodes.EncodingConverterReplacementNode> {
        private static final EncodingConverterReplacementNodeFactory ENCODING_CONVERTER_REPLACEMENT_NODE_FACTORY_INSTANCE = new EncodingConverterReplacementNodeFactory();

        private EncodingConverterReplacementNodeFactory() {
        }

        public Class<EncodingConverterNodes.EncodingConverterReplacementNode> getNodeClass() {
            return EncodingConverterNodes.EncodingConverterReplacementNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public EncodingConverterNodes.EncodingConverterReplacementNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingConverterReplacementNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.EncodingConverterReplacementNode> getInstance() {
            return ENCODING_CONVERTER_REPLACEMENT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.EncodingConverterReplacementNode create(RubyNode[] argumentNodes) {
            return new EncodingConverterReplacementNodeGen(argumentNodes);
        }

        @GeneratedBy(value=EncodingConverterNodes.EncodingConverterReplacementNode.class)
        public static final class EncodingConverterReplacementNodeGen
        extends EncodingConverterNodes.EncodingConverterReplacementNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private EncodingConverterReplacementNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value__ = (RubyEncodingConverter)((Object)argumentNodes0Value_);
                    return this.getReplacement(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyString executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyEncodingConverter) {
                    RubyEncodingConverter argumentNodes0Value_ = (RubyEncodingConverter)((Object)argumentNodes0Value);
                    this.state_0_ = state_0 |= 1;
                    return this.getReplacement(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingConverterNodes.EncodingConverterSetReplacementNode.class)
    public static final class EncodingConverterSetReplacementNodeFactory
    implements NodeFactory<EncodingConverterNodes.EncodingConverterSetReplacementNode> {
        private static final EncodingConverterSetReplacementNodeFactory ENCODING_CONVERTER_SET_REPLACEMENT_NODE_FACTORY_INSTANCE = new EncodingConverterSetReplacementNodeFactory();

        private EncodingConverterSetReplacementNodeFactory() {
        }

        public Class<EncodingConverterNodes.EncodingConverterSetReplacementNode> getNodeClass() {
            return EncodingConverterNodes.EncodingConverterSetReplacementNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyBaseNodeWithExecute.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode.class, RubyBaseNodeWithExecute.class));
        }

        public EncodingConverterNodes.EncodingConverterSetReplacementNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyBaseNodeWithExecute)) {
                return EncodingConverterSetReplacementNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyBaseNodeWithExecute)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingConverterNodes.EncodingConverterSetReplacementNode> getInstance() {
            return ENCODING_CONVERTER_SET_REPLACEMENT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingConverterNodes.EncodingConverterSetReplacementNode create(RubyNode encodingConverter, RubyBaseNodeWithExecute replacement) {
            return new EncodingConverterSetReplacementNodeGen(encodingConverter, replacement);
        }

        @GeneratedBy(value=EncodingConverterNodes.EncodingConverterSetReplacementNode.class)
        public static final class EncodingConverterSetReplacementNodeGen
        extends EncodingConverterNodes.EncodingConverterSetReplacementNode {
            private static final InlineSupport.StateField SET_REPLACEMENT_ENCODING_CONVERTER_SET_REPLACEMENT_NODE_SET_REPLACEMENT_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)SetReplacementData.lookup_(), (String)"setReplacement_state_0_");
            static final InlineSupport.ReferenceField<SetReplacementData> SET_REPLACEMENT_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setReplacement_cache", SetReplacementData.class);
            private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{SET_REPLACEMENT_ENCODING_CONVERTER_SET_REPLACEMENT_NODE_SET_REPLACEMENT_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final RubyStringLibrary INLINED_LIB_REPLACEMENT_ = RubyStringLibrary.inline(InlineSupport.InlineTarget.create(RubyStringLibrary.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{SET_REPLACEMENT_ENCODING_CONVERTER_SET_REPLACEMENT_NODE_SET_REPLACEMENT_STATE_0_UPDATER.subUpdater(1, 6)}));
            private static final ToStrNode INLINED_TO_STR_NODE_ = ToStrNodeGen.inline(InlineSupport.InlineTarget.create(ToStrNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{SET_REPLACEMENT_ENCODING_CONVERTER_SET_REPLACEMENT_NODE_SET_REPLACEMENT_STATE_0_UPDATER.subUpdater(7, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)SetReplacementData.lookup_(), (String)"toStrNode__field1_", Node.class)}));
            @Node.Child
            private RubyNode encodingConverter_;
            @Node.Child
            private RubyBaseNodeWithExecute replacement_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private SetReplacementData setReplacement_cache;

            private EncodingConverterSetReplacementNodeGen(RubyNode encodingConverter, RubyBaseNodeWithExecute replacement) {
                this.encodingConverter_ = encodingConverter;
                this.replacement_ = replacement;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object encodingConverterValue_ = this.encodingConverter_.execute(frameValue);
                Object replacementValue_ = this.replacement_.execute(frameValue);
                if (state_0 != 0 && encodingConverterValue_ instanceof RubyEncodingConverter) {
                    RubyEncodingConverter encodingConverterValue__ = (RubyEncodingConverter)((Object)encodingConverterValue_);
                    SetReplacementData s0_ = this.setReplacement_cache;
                    if (s0_ != null && INLINED_LIB_REPLACEMENT_.isRubyString(s0_, replacementValue_)) {
                        SetReplacementData node__ = s0_;
                        return EncodingConverterNodes.EncodingConverterSetReplacementNode.setReplacement(encodingConverterValue__, replacementValue_, INLINED_ERROR_PROFILE_, s0_.bytesNode_, INLINED_LIB_REPLACEMENT_, INLINED_TO_STR_NODE_, node__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(encodingConverterValue_, replacementValue_);
            }

            private Object executeAndSpecialize(Object encodingConverterValue, Object replacementValue) {
                block7: {
                    SetReplacementData s0_;
                    RubyEncodingConverter encodingConverterValue_;
                    SetReplacementData node__;
                    block5: {
                        block6: {
                            SetReplacementData s0_original;
                            int state_0 = this.state_0_;
                            node__ = null;
                            if (!(encodingConverterValue instanceof RubyEncodingConverter)) break block7;
                            encodingConverterValue_ = (RubyEncodingConverter)((Object)encodingConverterValue);
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (SetReplacementData)((Object)SET_REPLACEMENT_CACHE_UPDATER.getVolatile((Node)this));
                                if (s0_ != null) {
                                    if (INLINED_LIB_REPLACEMENT_.isRubyString(s0_, replacementValue)) {
                                        node__ = s0_;
                                    } else {
                                        ++count0_;
                                        s0_ = null;
                                    }
                                }
                                if (s0_ != null || count0_ >= true) break block5;
                                s0_ = (SetReplacementData)this.insert(new SetReplacementData());
                                if (!INLINED_LIB_REPLACEMENT_.isRubyString(s0_, replacementValue)) break block6;
                                TruffleString.GetInternalByteArrayNode bytesNode__ = (TruffleString.GetInternalByteArrayNode)s0_.insert((Node)TruffleString.GetInternalByteArrayNode.create());
                                Objects.requireNonNull(bytesNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.bytesNode_ = bytesNode__;
                                node__ = s0_;
                            } while (!SET_REPLACEMENT_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                            break block5;
                        }
                        s0_ = null;
                    }
                    if (s0_ != null) {
                        return EncodingConverterNodes.EncodingConverterSetReplacementNode.setReplacement(encodingConverterValue_, replacementValue, INLINED_ERROR_PROFILE_, s0_.bytesNode_, INLINED_LIB_REPLACEMENT_, INLINED_TO_STR_NODE_, node__);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.encodingConverter_, this.replacement_}, new Object[]{encodingConverterValue, replacementValue});
            }

            @GeneratedBy(value=EncodingConverterNodes.EncodingConverterSetReplacementNode.class)
            @DenyReplace
            private static final class SetReplacementData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int setReplacement_state_0_;
                @Node.Child
                TruffleString.GetInternalByteArrayNode bytesNode_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node toStrNode__field1_;

                SetReplacementData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }
}

