/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.EncodingDB;
import org.graalvm.shadowed.org.jcodings.specific.ASCIIEncoding;
import org.graalvm.shadowed.org.jcodings.specific.ISO8859_1Encoding;
import org.graalvm.shadowed.org.jcodings.specific.USASCIIEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF16BEEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF16LEEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF32BEEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF32LEEncoding;
import org.graalvm.shadowed.org.jcodings.specific.UTF8Encoding;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.FrozenStringLiterals;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.TStringConstants;

public final class Encodings {
    public static final int INITIAL_NUMBER_OF_ENCODINGS = EncodingDB.getEncodings().size();
    public static final int MAX_NUMBER_OF_ENCODINGS = 256;
    public static final int US_ASCII_INDEX = Encodings.getUsAsciiIndex();
    public static final RubyEncoding US_ASCII = new RubyEncoding(US_ASCII_INDEX);
    static final RubyEncoding[] BUILT_IN_ENCODINGS = Encodings.initializeRubyEncodings();
    private static final RubyEncoding[] BUILT_IN_ENCODINGS_BY_JCODING_INDEX = Encodings.initializeBuiltinEncodingsByJCodingIndex();
    public static final RubyEncoding BINARY = Encodings.getBuiltInEncoding((Encoding)ASCIIEncoding.INSTANCE);
    public static final RubyEncoding UTF_8 = Encodings.getBuiltInEncoding((Encoding)UTF8Encoding.INSTANCE);
    public static final RubyEncoding UTF16LE = Encodings.getBuiltInEncoding((Encoding)UTF16LEEncoding.INSTANCE);
    public static final RubyEncoding UTF16BE = Encodings.getBuiltInEncoding((Encoding)UTF16BEEncoding.INSTANCE);
    public static final RubyEncoding UTF32LE = Encodings.getBuiltInEncoding((Encoding)UTF32LEEncoding.INSTANCE);
    public static final RubyEncoding UTF32BE = Encodings.getBuiltInEncoding((Encoding)UTF32BEEncoding.INSTANCE);
    public static final RubyEncoding ISO_8859_1 = Encodings.getBuiltInEncoding((Encoding)ISO8859_1Encoding.INSTANCE);
    public static final RubyEncoding UTF16_DUMMY = Encodings.getBuiltInEncoding(((EncodingDB.Entry)EncodingDB.getEncodings().get(StringOperations.encodeAsciiBytes("UTF-16"))).getEncoding());
    public static final RubyEncoding UTF32_DUMMY = Encodings.getBuiltInEncoding(((EncodingDB.Entry)EncodingDB.getEncodings().get(StringOperations.encodeAsciiBytes("UTF-32"))).getEncoding());
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final RubyEncoding[] STANDARD_ENCODINGS = new RubyEncoding[3];
    public static final int NUMBER_OF_STANDARD_ENCODINGS;
    public static final RubyEncoding FILESYSTEM;
    public static final Charset FILESYSTEM_CHARSET;
    static final Encoding DUMMY_ENCODING_BASE;

    @Idempotent
    public static boolean isStandardEncoding(RubyEncoding encoding) {
        return encoding.index < NUMBER_OF_STANDARD_ENCODINGS;
    }

    private static int getUsAsciiIndex() {
        int index = 0;
        for (EncodingDB.Entry entry : EncodingDB.getEncodings()) {
            if (entry.getEncoding() == USASCIIEncoding.INSTANCE) {
                return index;
            }
            ++index;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"No US-ASCII");
    }

    private static RubyEncoding[] initializeRubyEncodings() {
        RubyEncoding[] encodings = new RubyEncoding[INITIAL_NUMBER_OF_ENCODINGS];
        int index = 0;
        for (EncodingDB.Entry entry : EncodingDB.getEncodings()) {
            RubyEncoding rubyEncoding;
            Encoding encoding = entry.getEncoding();
            if (encoding == USASCIIEncoding.INSTANCE) {
                assert (index == US_ASCII_INDEX);
                rubyEncoding = US_ASCII;
            } else {
                TruffleString tstring = TStringConstants.TSTRING_CONSTANTS.get(encoding.toString());
                if (tstring == null) {
                    throw CompilerDirectives.shouldNotReachHere((String)("no TStringConstants for " + String.valueOf(encoding)));
                }
                ImmutableRubyString name = FrozenStringLiterals.createStringAndCacheLater(tstring, US_ASCII);
                rubyEncoding = new RubyEncoding(encoding, name, index);
            }
            encodings[index] = rubyEncoding;
            ++index;
        }
        assert (index == EncodingDB.getEncodings().size());
        return encodings;
    }

    private static Encoding createDummyEncoding() {
        EncodingDB.Entry entry = EncodingDB.dummy((byte[])StringOperations.encodeAsciiBytes("TRUFFLERUBY_DUMMY_ENCODING"));
        return entry.getEncoding();
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyEncoding newRubyEncoding(RubyLanguage language, Encoding encoding, int index, byte[] name) {
        TruffleString tstring = TStringUtils.fromByteArray(name, US_ASCII);
        ImmutableRubyString string = language.getFrozenStringLiteral(tstring, US_ASCII);
        return new RubyEncoding(encoding, string, index);
    }

    public static RubyEncoding[] initializeBuiltinEncodingsByJCodingIndex() {
        RubyEncoding[] encodings = new RubyEncoding[INITIAL_NUMBER_OF_ENCODINGS];
        RubyEncoding[] rubyEncodingArray = BUILT_IN_ENCODINGS;
        int n = rubyEncodingArray.length;
        for (int i = 0; i < n; ++i) {
            RubyEncoding encoding;
            encodings[encoding.jcoding.getIndex()] = encoding = rubyEncodingArray[i];
        }
        return encodings;
    }

    public static RubyEncoding getBuiltInEncoding(Encoding jcoding) {
        RubyEncoding rubyEncoding = BUILT_IN_ENCODINGS_BY_JCODING_INDEX[jcoding.getIndex()];
        assert (rubyEncoding.jcoding == jcoding);
        return rubyEncoding;
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyEncoding getBuiltInEncoding(String name) {
        byte[] nameBytes = StringOperations.encodeAsciiBytes(name);
        EncodingDB.Entry entry = (EncodingDB.Entry)EncodingDB.getEncodings().get(nameBytes);
        if (entry == null) {
            entry = (EncodingDB.Entry)EncodingDB.getAliases().get(nameBytes);
        }
        if (entry != null) {
            return Encodings.getBuiltInEncoding(entry.getEncoding());
        }
        return null;
    }

    static {
        if (Encodings.BINARY.index >= 3 || Encodings.UTF_8.index >= 3 || Encodings.US_ASCII.index >= 3) {
            throw new Error("Expected standard encoding indices to be 0, 1 or 2");
        }
        Encodings.STANDARD_ENCODINGS[Encodings.BINARY.index] = BINARY;
        Encodings.STANDARD_ENCODINGS[Encodings.UTF_8.index] = UTF_8;
        Encodings.STANDARD_ENCODINGS[Encodings.US_ASCII.index] = US_ASCII;
        NUMBER_OF_STANDARD_ENCODINGS = STANDARD_ENCODINGS.length;
        FILESYSTEM = UTF_8;
        FILESYSTEM_CHARSET = StandardCharsets.UTF_8;
        DUMMY_ENCODING_BASE = Encodings.createDummyEncoding();
    }
}

