/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.VMPrimitiveNodes;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=InteropLibrary.class)
public class RubyException
extends RubyDynamicObject
implements ObjectGraphNode {
    public Object message;
    public Backtrace backtrace;
    public Object cause;
    public RubyProc formatter = null;
    public RubyArray backtraceStringArray = null;
    public Object backtraceLocations = null;
    public Object customBacktrace = null;

    public RubyException(RubyClass rubyClass, Shape shape, Object message, Backtrace backtrace, Object cause) {
        super(rubyClass, shape);
        assert (cause != null);
        this.message = message;
        this.backtrace = backtrace;
        this.cause = cause;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.message.toString();
    }

    public Node getLocation() {
        Backtrace backtrace = this.backtrace;
        if (backtrace == null) {
            return null;
        }
        return backtrace.getLocation();
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.addProperty(reachable, this.message);
        ObjectGraph.addProperty(reachable, this.cause);
    }

    @ExportMessage
    public boolean isException() {
        return true;
    }

    @ExportMessage
    public RuntimeException throwException(@CachedLibrary(value="this") InteropLibrary node) {
        throw VMPrimitiveNodes.VMRaiseExceptionNode.reRaiseException(RubyContext.get((Node)node), this);
    }

    @ExportMessage
    public ExceptionType getExceptionType() {
        return ExceptionType.RUNTIME_ERROR;
    }

    @ExportMessage
    public boolean hasExceptionCause() {
        return this.cause != RubyBaseNode.nil;
    }

    @ExportMessage
    public Object getExceptionCause() throws UnsupportedMessageException {
        if (!this.hasExceptionCause()) {
            throw UnsupportedMessageException.create();
        }
        return this.cause;
    }

    @ExportMessage
    public boolean hasExceptionMessage() {
        return true;
    }

    @ExportMessage
    public Object getExceptionMessage() {
        return ExceptionOperations.messageToString(this);
    }

    @ExportMessage
    public boolean hasExceptionStackTrace() {
        return this.backtrace != null;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object getExceptionStackTrace() throws UnsupportedMessageException {
        if (!this.hasExceptionStackTrace()) {
            throw UnsupportedMessageException.create();
        }
        TruffleStackTraceElement[] stackTrace = this.backtrace.getStackTrace();
        Object[] items = new Object[stackTrace.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = stackTrace[i].getGuestObject();
        }
        return ArrayHelpers.createArray(RubyContext.get(null), RubyLanguage.get(null), items);
    }
}

