/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.library.RubyStringLibrary;

@ExportLibrary(value=InteropLibrary.class)
public final class RubySyntaxError
extends RubyException {
    private final SourceSection sourceLocation;

    public RubySyntaxError(RubyClass rubyClass, Shape shape, Object message, Backtrace backtrace, Object cause, SourceSection sourceLocation) {
        super(rubyClass, shape, message, backtrace, cause);
        this.sourceLocation = sourceLocation;
    }

    @Override
    @ExportMessage
    public ExceptionType getExceptionType() {
        return ExceptionType.PARSE_ERROR;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean isExceptionIncompleteSource() {
        if (RubyStringLibrary.isRubyStringUncached(this.message)) {
            String messageString = RubyGuards.getJavaString(this.message);
            return messageString.endsWith(" unexpected end-of-file") || messageString.endsWith(" meets end of file");
        }
        return false;
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return this.sourceLocation != null;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public SourceSection getSourceLocation() throws UnsupportedMessageException {
        if (this.sourceLocation != null) {
            return this.sourceLocation;
        }
        throw UnsupportedMessageException.create();
    }
}

