/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.exception.RubySyntaxError;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="SyntaxError", isClass=true)
public abstract class SyntaxErrorNodes {

    @CoreMethod(names={"path"})
    public static abstract class PathNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object path(RubySyntaxError syntaxError) {
            Source source;
            if (!syntaxError.hasSourceLocation()) {
                return nil;
            }
            try {
                source = syntaxError.getSourceLocation().getSource();
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            TruffleString path = this.getLanguage().getPathToTStringCache().getCachedPath(source);
            return this.createString(path, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySyntaxError allocateSyntaxError(RubyClass rubyClass) {
            Shape shape = this.getLanguage().syntaxErrorShape;
            RubySyntaxError instance = new RubySyntaxError(rubyClass, shape, nil, null, nil, null);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

