/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.Shape;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.exception.RubySystemCallError;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="SystemCallError", isClass=true)
public abstract class SystemCallErrorNodes {

    @Primitive(name="exception_set_errno")
    public static abstract class ErrnoSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setErrno(RubySystemCallError error, Object errno) {
            error.errno = errno;
            return errno;
        }
    }

    @CoreMethod(names={"errno"})
    public static abstract class ErrnoNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object errno(RubySystemCallError self) {
            return self.errno;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySystemCallError allocateNameError(RubyClass rubyClass) {
            Shape shape = this.getLanguage().systemCallErrorShape;
            RubySystemCallError instance = new RubySystemCallError(rubyClass, shape, nil, null, nil, nil);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

