/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.fiber;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.cast.SingleValueCastNode;
import org.truffleruby.core.cast.SingleValueCastNodeGen;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.FiberNodes;
import org.truffleruby.core.fiber.FiberOperation;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyTypes;
import org.truffleruby.language.arguments.ArgumentsDescriptor;

@GeneratedBy(value=FiberNodes.class)
public final class FiberNodesFactory {
    public static List<NodeFactory<? extends RubyContextSourceNode>> getFactories() {
        return List.of(AllocateNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), TransferNodeFactory.getInstance(), FiberRaiseNodeFactory.getInstance(), ResumeNodeFactory.getInstance(), YieldNodeFactory.getInstance(), AliveNodeFactory.getInstance(), CurrentNodeFactory.getInstance(), FiberSourceLocationNodeFactory.getInstance(), FiberStatusNodeFactory.getInstance(), FiberThreadNodeFactory.getInstance(), FiberGetExceptionNodeFactory.getInstance(), FiberGetCatchTagsNodeFactory.getInstance(), IsBlockingInstanceNodeFactory.getInstance(), IsBlockingNodeFactory.getInstance(), FiberCGlobalVariablesNodeFactory.getInstance(), FiberGetErrorInfoNodeFactory.getInstance(), FiberSetErrorInfoNodeFactory.getInstance());
    }

    @GeneratedBy(value=FiberNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<FiberNodes.AllocateNode> {
        private static final AllocateNodeFactory ALLOCATE_NODE_FACTORY_INSTANCE = new AllocateNodeFactory();

        private AllocateNodeFactory() {
        }

        public Class<FiberNodes.AllocateNode> getNodeClass() {
            return FiberNodes.AllocateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.AllocateNode> getInstance() {
            return ALLOCATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.AllocateNode create(RubyNode[] argumentNodes) {
            return new AllocateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends FiberNodes.AllocateNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AllocateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    return this.allocate(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyFiber executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.allocate(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<FiberNodes.InitializeNode> {
        private static final InitializeNodeFactory INITIALIZE_NODE_FACTORY_INSTANCE = new InitializeNodeFactory();

        private InitializeNodeFactory() {
        }

        public Class<FiberNodes.InitializeNode> getNodeClass() {
            return FiberNodes.InitializeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.InitializeNode> getInstance() {
            return INITIALIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.InitializeNode create(RubyNode[] argumentNodes) {
            return new InitializeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends FiberNodes.InitializeNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private InitializeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Boolean) {
                        boolean argumentNodes1Value__ = (Boolean)argumentNodes1Value_;
                        if ((state_0 & 1) != 0 && argumentNodes2Value_ instanceof RubyProc) {
                            RubyProc argumentNodes2Value__ = (RubyProc)argumentNodes2Value_;
                            return this.initialize(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__);
                        }
                        if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes2Value_)) {
                            Nil argumentNodes2Value__ = RubyTypes.asNil(argumentNodes2Value_);
                            return this.noBlock(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Boolean) {
                        boolean argumentNodes1Value_ = (Boolean)argumentNodes1Value;
                        if (argumentNodes2Value instanceof RubyProc) {
                            RubyProc argumentNodes2Value_ = (RubyProc)argumentNodes2Value;
                            this.state_0_ = state_0 |= 1;
                            return this.initialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
                        }
                        if (RubyTypes.isNil(argumentNodes2Value)) {
                            Nil argumentNodes2Value_ = RubyTypes.asNil(argumentNodes2Value);
                            this.state_0_ = state_0 |= 2;
                            return this.noBlock(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.TransferNode.class)
    public static final class TransferNodeFactory
    implements NodeFactory<FiberNodes.TransferNode> {
        private static final TransferNodeFactory TRANSFER_NODE_FACTORY_INSTANCE = new TransferNodeFactory();

        private TransferNodeFactory() {
        }

        public Class<FiberNodes.TransferNode> getNodeClass() {
            return FiberNodes.TransferNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.TransferNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return TransferNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.TransferNode> getInstance() {
            return TRANSFER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.TransferNode create(RubyNode[] argumentNodes) {
            return new TransferNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.TransferNode.class)
        public static final class TransferNodeGen
        extends FiberNodes.TransferNode {
            private static final InlineSupport.StateField STATE_0_TransferNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final FiberNodes.FiberTransferNode INLINED_FIBER_TRANSFER_NODE_ = FiberTransferNodeGen.inline(InlineSupport.InlineTarget.create(FiberNodes.FiberTransferNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_TransferNode_UPDATER.subUpdater(1, 4)}));
            private static final SingleValueCastNode INLINED_SINGLE_VALUE_CAST_NODE_ = SingleValueCastNodeGen.inline(InlineSupport.InlineTarget.create(SingleValueCastNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_TransferNode_UPDATER.subUpdater(5, 3)}));
            private static final InlinedConditionProfile INLINED_SAME_FIBER_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_TransferNode_UPDATER.subUpdater(8, 2)}));
            private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_TransferNode_UPDATER.subUpdater(10, 1)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private TransferNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Object[]) {
                        Object[] argumentNodes1Value__ = (Object[])argumentNodes1Value_;
                        return this.transfer(frameValue, argumentNodes0Value__, argumentNodes1Value__, INLINED_FIBER_TRANSFER_NODE_, INLINED_SINGLE_VALUE_CAST_NODE_, INLINED_SAME_FIBER_PROFILE_, INLINED_ERROR_PROFILE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Object[]) {
                        Object[] argumentNodes1Value_ = (Object[])argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.transfer(frameValue, argumentNodes0Value_, argumentNodes1Value_, INLINED_FIBER_TRANSFER_NODE_, INLINED_SINGLE_VALUE_CAST_NODE_, INLINED_SAME_FIBER_PROFILE_, INLINED_ERROR_PROFILE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberRaiseNode.class)
    public static final class FiberRaiseNodeFactory
    implements NodeFactory<FiberNodes.FiberRaiseNode> {
        private static final FiberRaiseNodeFactory FIBER_RAISE_NODE_FACTORY_INSTANCE = new FiberRaiseNodeFactory();

        private FiberRaiseNodeFactory() {
        }

        public Class<FiberNodes.FiberRaiseNode> getNodeClass() {
            return FiberNodes.FiberRaiseNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberRaiseNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberRaiseNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberRaiseNode> getInstance() {
            return FIBER_RAISE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberRaiseNode create(RubyNode[] argumentNodes) {
            return new FiberRaiseNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberRaiseNode.class)
        public static final class FiberRaiseNodeGen
        extends FiberNodes.FiberRaiseNode {
            private static final InlineSupport.StateField STATE_0_FiberRaiseNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final FiberNodes.FiberResumeNode INLINED_FIBER_RESUME_NODE_ = FiberResumeNodeGen.inline(InlineSupport.InlineTarget.create(FiberNodes.FiberResumeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FiberRaiseNode_UPDATER.subUpdater(1, 5)}));
            private static final FiberNodes.FiberTransferNode INLINED_FIBER_TRANSFER_NODE_ = FiberTransferNodeGen.inline(InlineSupport.InlineTarget.create(FiberNodes.FiberTransferNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FiberRaiseNode_UPDATER.subUpdater(6, 4)}));
            private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FiberRaiseNode_UPDATER.subUpdater(10, 1)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private FiberRaiseNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubyException) {
                        RubyException argumentNodes1Value__ = (RubyException)argumentNodes1Value_;
                        return this.raise(argumentNodes0Value__, argumentNodes1Value__, INLINED_FIBER_RESUME_NODE_, INLINED_FIBER_TRANSFER_NODE_, INLINED_ERROR_PROFILE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubyException) {
                        RubyException argumentNodes1Value_ = (RubyException)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.raise(argumentNodes0Value_, argumentNodes1Value_, INLINED_FIBER_RESUME_NODE_, INLINED_FIBER_TRANSFER_NODE_, INLINED_ERROR_PROFILE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.ResumeNode.class)
    public static final class ResumeNodeFactory
    implements NodeFactory<FiberNodes.ResumeNode> {
        private static final ResumeNodeFactory RESUME_NODE_FACTORY_INSTANCE = new ResumeNodeFactory();

        private ResumeNodeFactory() {
        }

        public Class<FiberNodes.ResumeNode> getNodeClass() {
            return FiberNodes.ResumeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.ResumeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ResumeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.ResumeNode> getInstance() {
            return RESUME_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.ResumeNode create(RubyNode[] argumentNodes) {
            return new ResumeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.ResumeNode.class)
        public static final class ResumeNodeGen
        extends FiberNodes.ResumeNode {
            private static final InlineSupport.StateField STATE_0_ResumeNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final FiberNodes.FiberResumeNode INLINED_FIBER_RESUME_NODE_ = FiberResumeNodeGen.inline(InlineSupport.InlineTarget.create(FiberNodes.FiberResumeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ResumeNode_UPDATER.subUpdater(1, 5)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private ResumeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Object[]) {
                        Object[] argumentNodes1Value__ = (Object[])argumentNodes1Value_;
                        return this.resume(frameValue, argumentNodes0Value__, argumentNodes1Value__, INLINED_FIBER_RESUME_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Object[]) {
                        Object[] argumentNodes1Value_ = (Object[])argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.resume(frameValue, argumentNodes0Value_, argumentNodes1Value_, INLINED_FIBER_RESUME_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.YieldNode.class)
    public static final class YieldNodeFactory
    implements NodeFactory<FiberNodes.YieldNode> {
        private static final YieldNodeFactory YIELD_NODE_FACTORY_INSTANCE = new YieldNodeFactory();

        private YieldNodeFactory() {
        }

        public Class<FiberNodes.YieldNode> getNodeClass() {
            return FiberNodes.YieldNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.YieldNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return YieldNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.YieldNode> getInstance() {
            return YIELD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.YieldNode create(RubyNode[] argumentNodes) {
            return new YieldNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.YieldNode.class)
        public static final class YieldNodeGen
        extends FiberNodes.YieldNode {
            private static final InlineSupport.StateField STATE_0_YieldNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final FiberNodes.FiberTransferNode INLINED_FIBER_TRANSFER_NODE_ = FiberTransferNodeGen.inline(InlineSupport.InlineTarget.create(FiberNodes.FiberTransferNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_YieldNode_UPDATER.subUpdater(1, 4)}));
            private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_YieldNode_UPDATER.subUpdater(5, 1)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private YieldNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof Object[]) {
                    Object[] argumentNodes0Value__ = (Object[])argumentNodes0Value_;
                    return this.fiberYield(frameValue, argumentNodes0Value__, INLINED_FIBER_TRANSFER_NODE_, INLINED_ERROR_PROFILE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, argumentNodes0Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof Object[]) {
                    Object[] argumentNodes0Value_ = (Object[])argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.fiberYield(frameValue, argumentNodes0Value_, INLINED_FIBER_TRANSFER_NODE_, INLINED_ERROR_PROFILE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.AliveNode.class)
    public static final class AliveNodeFactory
    implements NodeFactory<FiberNodes.AliveNode> {
        private static final AliveNodeFactory ALIVE_NODE_FACTORY_INSTANCE = new AliveNodeFactory();

        private AliveNodeFactory() {
        }

        public Class<FiberNodes.AliveNode> getNodeClass() {
            return FiberNodes.AliveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.AliveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AliveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.AliveNode> getInstance() {
            return ALIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.AliveNode create(RubyNode[] argumentNodes) {
            return new AliveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.AliveNode.class)
        public static final class AliveNodeGen
        extends FiberNodes.AliveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AliveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    return this.alive(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.alive(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.CurrentNode.class)
    public static final class CurrentNodeFactory
    implements NodeFactory<FiberNodes.CurrentNode> {
        private static final CurrentNodeFactory CURRENT_NODE_FACTORY_INSTANCE = new CurrentNodeFactory();

        private CurrentNodeFactory() {
        }

        public Class<FiberNodes.CurrentNode> getNodeClass() {
            return FiberNodes.CurrentNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.CurrentNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CurrentNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.CurrentNode> getInstance() {
            return CURRENT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.CurrentNode create(RubyNode[] argumentNodes) {
            return new CurrentNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.CurrentNode.class)
        public static final class CurrentNodeGen
        extends FiberNodes.CurrentNode {
            private CurrentNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.current();
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberSourceLocationNode.class)
    public static final class FiberSourceLocationNodeFactory
    implements NodeFactory<FiberNodes.FiberSourceLocationNode> {
        private static final FiberSourceLocationNodeFactory FIBER_SOURCE_LOCATION_NODE_FACTORY_INSTANCE = new FiberSourceLocationNodeFactory();

        private FiberSourceLocationNodeFactory() {
        }

        public Class<FiberNodes.FiberSourceLocationNode> getNodeClass() {
            return FiberNodes.FiberSourceLocationNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberSourceLocationNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberSourceLocationNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberSourceLocationNode> getInstance() {
            return FIBER_SOURCE_LOCATION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberSourceLocationNode create(RubyNode[] argumentNodes) {
            return new FiberSourceLocationNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberSourceLocationNode.class)
        public static final class FiberSourceLocationNodeGen
        extends FiberNodes.FiberSourceLocationNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaStringNode_;

            private FiberSourceLocationNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    TruffleString.FromJavaStringNode fromJavaStringNode__ = this.fromJavaStringNode_;
                    if (fromJavaStringNode__ != null) {
                        return this.sourceLocation(argumentNodes0Value__, fromJavaStringNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyString executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode_ = fromJavaStringNode__;
                    this.state_0_ = state_0 |= 1;
                    return this.sourceLocation(argumentNodes0Value_, fromJavaStringNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberStatusNode.class)
    public static final class FiberStatusNodeFactory
    implements NodeFactory<FiberNodes.FiberStatusNode> {
        private static final FiberStatusNodeFactory FIBER_STATUS_NODE_FACTORY_INSTANCE = new FiberStatusNodeFactory();

        private FiberStatusNodeFactory() {
        }

        public Class<FiberNodes.FiberStatusNode> getNodeClass() {
            return FiberNodes.FiberStatusNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberStatusNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberStatusNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberStatusNode> getInstance() {
            return FIBER_STATUS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberStatusNode create(RubyNode[] argumentNodes) {
            return new FiberStatusNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberStatusNode.class)
        public static final class FiberStatusNodeGen
        extends FiberNodes.FiberStatusNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaStringNode_;

            private FiberStatusNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    TruffleString.FromJavaStringNode fromJavaStringNode__ = this.fromJavaStringNode_;
                    if (fromJavaStringNode__ != null) {
                        return this.status(argumentNodes0Value__, fromJavaStringNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyString executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.fromJavaStringNode_ = fromJavaStringNode__;
                    this.state_0_ = state_0 |= 1;
                    return this.status(argumentNodes0Value_, fromJavaStringNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberThreadNode.class)
    public static final class FiberThreadNodeFactory
    implements NodeFactory<FiberNodes.FiberThreadNode> {
        private static final FiberThreadNodeFactory FIBER_THREAD_NODE_FACTORY_INSTANCE = new FiberThreadNodeFactory();

        private FiberThreadNodeFactory() {
        }

        public Class<FiberNodes.FiberThreadNode> getNodeClass() {
            return FiberNodes.FiberThreadNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberThreadNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberThreadNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberThreadNode> getInstance() {
            return FIBER_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberThreadNode create(RubyNode[] argumentNodes) {
            return new FiberThreadNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberThreadNode.class)
        public static final class FiberThreadNodeGen
        extends FiberNodes.FiberThreadNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private FiberThreadNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    return this.thread(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyThread executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.thread(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberGetExceptionNode.class)
    public static final class FiberGetExceptionNodeFactory
    implements NodeFactory<FiberNodes.FiberGetExceptionNode> {
        private static final FiberGetExceptionNodeFactory FIBER_GET_EXCEPTION_NODE_FACTORY_INSTANCE = new FiberGetExceptionNodeFactory();

        private FiberGetExceptionNodeFactory() {
        }

        public Class<FiberNodes.FiberGetExceptionNode> getNodeClass() {
            return FiberNodes.FiberGetExceptionNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberGetExceptionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberGetExceptionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberGetExceptionNode> getInstance() {
            return FIBER_GET_EXCEPTION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberGetExceptionNode create(RubyNode[] argumentNodes) {
            return new FiberGetExceptionNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberGetExceptionNode.class)
        public static final class FiberGetExceptionNodeGen
        extends FiberNodes.FiberGetExceptionNode {
            private FiberGetExceptionNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.getException();
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberGetCatchTagsNode.class)
    public static final class FiberGetCatchTagsNodeFactory
    implements NodeFactory<FiberNodes.FiberGetCatchTagsNode> {
        private static final FiberGetCatchTagsNodeFactory FIBER_GET_CATCH_TAGS_NODE_FACTORY_INSTANCE = new FiberGetCatchTagsNodeFactory();

        private FiberGetCatchTagsNodeFactory() {
        }

        public Class<FiberNodes.FiberGetCatchTagsNode> getNodeClass() {
            return FiberNodes.FiberGetCatchTagsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberGetCatchTagsNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberGetCatchTagsNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberGetCatchTagsNode> getInstance() {
            return FIBER_GET_CATCH_TAGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberGetCatchTagsNode create(RubyNode[] argumentNodes) {
            return new FiberGetCatchTagsNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberGetCatchTagsNode.class)
        public static final class FiberGetCatchTagsNodeGen
        extends FiberNodes.FiberGetCatchTagsNode {
            private FiberGetCatchTagsNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.getCatchTags();
            }
        }
    }

    @GeneratedBy(value=FiberNodes.IsBlockingInstanceNode.class)
    public static final class IsBlockingInstanceNodeFactory
    implements NodeFactory<FiberNodes.IsBlockingInstanceNode> {
        private static final IsBlockingInstanceNodeFactory IS_BLOCKING_INSTANCE_NODE_FACTORY_INSTANCE = new IsBlockingInstanceNodeFactory();

        private IsBlockingInstanceNodeFactory() {
        }

        public Class<FiberNodes.IsBlockingInstanceNode> getNodeClass() {
            return FiberNodes.IsBlockingInstanceNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.IsBlockingInstanceNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsBlockingInstanceNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.IsBlockingInstanceNode> getInstance() {
            return IS_BLOCKING_INSTANCE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.IsBlockingInstanceNode create(RubyNode[] argumentNodes) {
            return new IsBlockingInstanceNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.IsBlockingInstanceNode.class)
        public static final class IsBlockingInstanceNodeGen
        extends FiberNodes.IsBlockingInstanceNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private IsBlockingInstanceNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value__ = (RubyFiber)argumentNodes0Value_;
                    return this.isBlocking(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyFiber) {
                    RubyFiber argumentNodes0Value_ = (RubyFiber)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isBlocking(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=FiberNodes.IsBlockingNode.class)
    public static final class IsBlockingNodeFactory
    implements NodeFactory<FiberNodes.IsBlockingNode> {
        private static final IsBlockingNodeFactory IS_BLOCKING_NODE_FACTORY_INSTANCE = new IsBlockingNodeFactory();

        private IsBlockingNodeFactory() {
        }

        public Class<FiberNodes.IsBlockingNode> getNodeClass() {
            return FiberNodes.IsBlockingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.IsBlockingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsBlockingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.IsBlockingNode> getInstance() {
            return IS_BLOCKING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.IsBlockingNode create(RubyNode[] argumentNodes) {
            return new IsBlockingNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.IsBlockingNode.class)
        public static final class IsBlockingNodeGen
        extends FiberNodes.IsBlockingNode {
            private IsBlockingNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.isBlocking();
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberCGlobalVariablesNode.class)
    public static final class FiberCGlobalVariablesNodeFactory
    implements NodeFactory<FiberNodes.FiberCGlobalVariablesNode> {
        private static final FiberCGlobalVariablesNodeFactory FIBER_CGLOBAL_VARIABLES_NODE_FACTORY_INSTANCE = new FiberCGlobalVariablesNodeFactory();

        private FiberCGlobalVariablesNodeFactory() {
        }

        public Class<FiberNodes.FiberCGlobalVariablesNode> getNodeClass() {
            return FiberNodes.FiberCGlobalVariablesNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberCGlobalVariablesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberCGlobalVariablesNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberCGlobalVariablesNode> getInstance() {
            return FIBER_CGLOBAL_VARIABLES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberCGlobalVariablesNode create(RubyNode[] argumentNodes) {
            return new FiberCGlobalVariablesNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberCGlobalVariablesNode.class)
        public static final class FiberCGlobalVariablesNodeGen
        extends FiberNodes.FiberCGlobalVariablesNode {
            private FiberCGlobalVariablesNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.cGlobalVariables();
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberGetErrorInfoNode.class)
    public static final class FiberGetErrorInfoNodeFactory
    implements NodeFactory<FiberNodes.FiberGetErrorInfoNode> {
        private static final FiberGetErrorInfoNodeFactory FIBER_GET_ERROR_INFO_NODE_FACTORY_INSTANCE = new FiberGetErrorInfoNodeFactory();

        private FiberGetErrorInfoNodeFactory() {
        }

        public Class<FiberNodes.FiberGetErrorInfoNode> getNodeClass() {
            return FiberNodes.FiberGetErrorInfoNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberGetErrorInfoNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberGetErrorInfoNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberGetErrorInfoNode> getInstance() {
            return FIBER_GET_ERROR_INFO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberGetErrorInfoNode create(RubyNode[] argumentNodes) {
            return new FiberGetErrorInfoNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberGetErrorInfoNode.class)
        public static final class FiberGetErrorInfoNodeGen
        extends FiberNodes.FiberGetErrorInfoNode {
            private FiberGetErrorInfoNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.getErrorInfo();
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberSetErrorInfoNode.class)
    public static final class FiberSetErrorInfoNodeFactory
    implements NodeFactory<FiberNodes.FiberSetErrorInfoNode> {
        private static final FiberSetErrorInfoNodeFactory FIBER_SET_ERROR_INFO_NODE_FACTORY_INSTANCE = new FiberSetErrorInfoNodeFactory();

        private FiberSetErrorInfoNodeFactory() {
        }

        public Class<FiberNodes.FiberSetErrorInfoNode> getNodeClass() {
            return FiberNodes.FiberSetErrorInfoNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public FiberNodes.FiberSetErrorInfoNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FiberSetErrorInfoNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<FiberNodes.FiberSetErrorInfoNode> getInstance() {
            return FIBER_SET_ERROR_INFO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FiberNodes.FiberSetErrorInfoNode create(RubyNode[] argumentNodes) {
            return new FiberSetErrorInfoNodeGen(argumentNodes);
        }

        @GeneratedBy(value=FiberNodes.FiberSetErrorInfoNode.class)
        public static final class FiberSetErrorInfoNodeGen
        extends FiberNodes.FiberSetErrorInfoNode {
            @Node.Child
            private RubyNode argumentNodes0_;

            private FiberSetErrorInfoNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                return this.setErrorInfo(argumentNodes0Value_);
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberResumeNode.class)
    public static final class FiberResumeNodeGen {
        @NeverDefault
        public static FiberNodes.FiberResumeNode inline(@InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=FiberNodes.FiberResumeNode.class)
        @DenyReplace
        private static final class Inlined
        extends FiberNodes.FiberResumeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final FiberNodes.FiberTransferNode fiberTransferNode_;
            private final InlinedBranchProfile errorProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(FiberNodes.FiberResumeNode.class));
                this.state_0_ = target.getState(0, 5);
                this.fiberTransferNode_ = FiberTransferNodeGen.inline(InlineSupport.InlineTarget.create(FiberNodes.FiberTransferNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 4)}));
                this.errorProfile_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(4, 1)}));
            }

            @Override
            public Object execute(Node arg0Value, FiberOperation arg1Value, RubyFiber arg2Value, ArgumentsDescriptor arg3Value, Object[] arg4Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_));
                return FiberNodes.FiberResumeNode.resume(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.fiberTransferNode_, this.errorProfile_);
            }
        }
    }

    @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
    public static final class FiberTransferNodeGen {
        @NeverDefault
        public static FiberNodes.FiberTransferNode inline(@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=FiberNodes.FiberTransferNode.class)
        @DenyReplace
        private static final class Inlined
        extends FiberNodes.FiberTransferNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final SingleValueCastNode singleValueCastNode_;
            private final InlinedBranchProfile errorProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(FiberNodes.FiberTransferNode.class));
                this.state_0_ = target.getState(0, 4);
                this.singleValueCastNode_ = SingleValueCastNodeGen.inline(InlineSupport.InlineTarget.create(SingleValueCastNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 3)}));
                this.errorProfile_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(3, 1)}));
            }

            @Override
            public Object execute(Node arg0Value, RubyFiber arg1Value, RubyFiber arg2Value, FiberOperation arg3Value, ArgumentsDescriptor arg4Value, Object[] arg5Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_));
                return FiberNodes.FiberTransferNode.transfer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.singleValueCastNode_, this.errorProfile_);
            }
        }
    }
}

