/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.language.control.RaiseException;

public final class FormatEncoding {
    public static final FormatEncoding DEFAULT = new FormatEncoding(Encodings.BINARY);
    public static final FormatEncoding ASCII_8BIT = new FormatEncoding(Encodings.BINARY);
    public static final FormatEncoding US_ASCII = new FormatEncoding(Encodings.US_ASCII);
    public static final FormatEncoding UTF_8 = new FormatEncoding(Encodings.UTF_8);
    private final RubyEncoding encoding;

    public FormatEncoding(RubyEncoding encoding) {
        this.encoding = encoding;
    }

    public RubyEncoding getEncoding() {
        return this.encoding;
    }

    public RubyEncoding getEncodingForLength(int length) {
        if (length == 0) {
            return Encodings.US_ASCII;
        }
        return this.encoding;
    }

    public static FormatEncoding find(RubyEncoding encoding, Node currentNode) {
        if (encoding == Encodings.BINARY) {
            return ASCII_8BIT;
        }
        if (encoding == Encodings.US_ASCII) {
            return US_ASCII;
        }
        if (encoding == Encodings.UTF_8) {
            return UTF_8;
        }
        RubyContext context = RubyContext.get(currentNode);
        throw new RaiseException(context, context.getCoreExceptions().runtimeError("Can't find format encoding for " + String.valueOf(encoding), currentNode));
    }

    public FormatEncoding unifyWith(FormatEncoding other) {
        if (this == DEFAULT) {
            return other;
        }
        if (other == DEFAULT) {
            return this;
        }
        if (other == ASCII_8BIT || other == US_ASCII) {
            return ASCII_8BIT;
        }
        if (other == UTF_8) {
            if (this == ASCII_8BIT || this == US_ASCII) {
                return ASCII_8BIT;
            }
            if (this == UTF_8) {
                return UTF_8;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        throw CompilerDirectives.shouldNotReachHere();
    }
}

