/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.format.BytesResult;
import org.truffleruby.core.format.FormatEncoding;
import org.truffleruby.core.format.FormatFrameDescriptor;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.backtrace.InternalRootNode;

public final class FormatRootNode
extends RubyBaseRootNode
implements InternalRootNode {
    private final FormatEncoding encoding;
    @Node.Child
    private FormatNode child;
    @CompilerDirectives.CompilationFinal
    private int expectedLength = 0;
    private final boolean acceptOutput;
    private final boolean acceptOutputPosition;

    public FormatRootNode(RubyLanguage language, SourceSection sourceSection, FormatEncoding encoding, FormatNode child, boolean acceptOutput, boolean acceptOutputPosition) {
        super(language, FormatFrameDescriptor.FRAME_DESCRIPTOR, sourceSection);
        this.encoding = encoding;
        this.child = child;
        this.acceptOutput = acceptOutput;
        this.acceptOutputPosition = acceptOutputPosition;
    }

    public Object execute(VirtualFrame frame) {
        frame.setObject(FormatFrameDescriptor.SOURCE_SLOT, frame.getArguments()[0]);
        frame.setInt(FormatFrameDescriptor.SOURCE_END_POSITION_SLOT, ((Integer)frame.getArguments()[1]).intValue());
        frame.setInt(FormatFrameDescriptor.SOURCE_START_POSITION_SLOT, 0);
        frame.setInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT, 0);
        byte[] outputInit = this.acceptOutput ? (byte[])frame.getArguments()[2] : new byte[this.expectedLength];
        frame.setObject(FormatFrameDescriptor.OUTPUT_SLOT, (Object)outputInit);
        int outputPosition = this.acceptOutputPosition ? (Integer)frame.getArguments()[3] : 0;
        frame.setInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT, outputPosition);
        frame.setObject(FormatFrameDescriptor.ASSOCIATED_SLOT, null);
        this.child.execute(frame);
        int outputLength = frame.getInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT);
        if (outputLength > this.expectedLength) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.expectedLength = outputLength;
        }
        byte[] output = (byte[])frame.getObject(FormatFrameDescriptor.OUTPUT_SLOT);
        List associated = (List)frame.getObject(FormatFrameDescriptor.ASSOCIATED_SLOT);
        Pointer[] associatedArray = associated != null ? this.associatedToArray(associated) : null;
        return new BytesResult(output, outputLength, this.encoding, associatedArray);
    }

    @CompilerDirectives.TruffleBoundary
    private Pointer[] associatedToArray(List<Pointer> associated) {
        return associated.toArray(Pointer.EMPTY_ARRAY);
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public String getName() {
        return "format";
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public String toString() {
        return this.getName();
    }
}

