/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.truffleruby.core.format.format.FormatFloatGenericNode;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.thread.RubyThread;

@ImportStatic(value={Double.class})
public abstract class FormatGFloatNode
extends FormatFloatGenericNode {
    private final char expSeparator;

    public FormatGFloatNode(char expSeparator, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag) {
        super(hasSpaceFlag, hasZeroFlag, hasPlusFlag, hasMinusFlag, hasFSharpFlag);
        this.expSeparator = expSeparator;
    }

    @Specialization(guards={"nonSpecialValue(dval)"})
    byte[] formatGExponential(int width, int precision, Object dval) {
        if (precision == Integer.MIN_VALUE) {
            precision = 6;
        }
        if (precision == 0) {
            precision = 1;
        }
        return this.formatNumber(width, precision, dval);
    }

    protected static boolean inSimpleRange(int precision, Object value) {
        if (value instanceof Double) {
            double dval = (Double)value;
            return dval == 0.0 || Math.abs(dval) >= 1.0E-4 && Math.pow(10.0, precision) - Math.abs(dval) >= 0.5;
        }
        if (value instanceof Long) {
            long lval = (Long)value;
            return lval == 0L || Math.pow(10.0, precision) - (double)Math.abs(lval) > 0.0;
        }
        if (value instanceof Integer) {
            int ival = (Integer)value;
            return ival == 0 || Math.pow(10.0, precision) - (double)Math.abs(ival) > 0.0;
        }
        if (value instanceof BigInteger) {
            BigInteger bval = (BigInteger)value;
            return bval.equals(BigInteger.ZERO) || BigInteger.TEN.pow(precision).subtract(bval.abs()).compareTo(BigInteger.ZERO) == 1;
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected byte[] doFormat(int precision, Object value) {
        DecimalFormat format;
        boolean simple = FormatGFloatNode.inSimpleRange(precision, value);
        RubyThread currentThread = this.getLanguage().getCurrentThread();
        DecimalFormat decimalFormat = format = simple ? currentThread.formatGFloatSimple : currentThread.formatGFloatExponential;
        if (format == null) {
            if (simple) {
                formatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
                currentThread.formatGFloatSimple = format = new DecimalFormat("0.0", formatSymbols);
            } else {
                formatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
                currentThread.formatGFloatExponential = format = new DecimalFormat("0.0E00", formatSymbols);
            }
        }
        if (this.hasPlusFlag) {
            format.setPositivePrefix("+");
        } else if (this.hasSpaceFlag) {
            format.setPositivePrefix(" ");
        } else {
            format.setPositivePrefix("");
        }
        format.setDecimalSeparatorAlwaysShown(this.hasFSharpFlag);
        if (!simple) {
            boolean positiveExp;
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            boolean bl = positiveExp = !(value instanceof Double) || !(Math.abs((Double)value) < 1.0);
            if (this.expSeparator == 'g') {
                symbols.setExponentSeparator(positiveExp ? "e+" : "e");
            } else {
                symbols.setExponentSeparator(positiveExp ? "E+" : "E");
            }
            format.setDecimalFormatSymbols(symbols);
        }
        format.setMinimumIntegerDigits(1);
        if (!simple) {
            format.setMaximumFractionDigits(Math.max(0, precision - 1));
            format.setMinimumFractionDigits(0);
        } else {
            int intDigits = this.getIntDigits(value);
            if (this.hasFSharpFlag) {
                format.setMinimumFractionDigits(precision - intDigits);
            } else {
                format.setMinimumFractionDigits(0);
            }
            format.setMaximumFractionDigits(precision - intDigits);
        }
        byte[] digits = StringOperations.encodeAsciiBytes(format.format(value));
        return digits;
    }

    private int getIntDigits(Object value) {
        int intDigits;
        block7: {
            block8: {
                block6: {
                    intDigits = 0;
                    if (!(value instanceof Double)) break block6;
                    double absval = Math.abs((Double)value);
                    double pow = 0.1;
                    if (absval == 0.0) break block7;
                    while (absval >= pow * 10.0) {
                        pow = 10.0 * pow;
                        ++intDigits;
                    }
                    while (absval < pow) {
                        pow /= 10.0;
                        --intDigits;
                    }
                    break block7;
                }
                if (!(value instanceof Long) && !(value instanceof Integer)) break block8;
                long absval = value instanceof Long ? Math.abs((Long)value) : (long)Math.abs((Integer)value);
                long pow = 1L;
                intDigits = 1;
                if (absval == 0L) break block7;
                while (absval >= pow * 10L) {
                    pow = 10L * pow;
                    ++intDigits;
                }
                break block7;
            }
            if (value instanceof BigInteger) {
                BigInteger absval = ((BigInteger)value).abs();
                BigInteger pow = BigInteger.ONE;
                intDigits = 1;
                if (!absval.equals(BigInteger.ZERO)) {
                    while (absval.compareTo(pow = pow.multiply(BigInteger.TEN)) == 1) {
                        ++intDigits;
                    }
                }
            }
        }
        return intDigits;
    }
}

