/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigInteger;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.exceptions.CantCompressNegativeException;
import org.truffleruby.core.numeric.RubyBignum;

@NodeChild(value="value")
public abstract class WriteBERNode
extends FormatNode {
    private final ConditionProfile cantCompressProfile = ConditionProfile.create();
    private final BigInteger BIG_128 = BigInteger.valueOf(128L);

    @Specialization
    Object doWrite(VirtualFrame frame, int value) {
        if (this.cantCompressProfile.profile(value < 0)) {
            throw new CantCompressNegativeException();
        }
        WriteBERNode.writeBytes(frame, this.encode(value));
        return null;
    }

    @Specialization
    Object doWrite(VirtualFrame frame, long value) {
        if (this.cantCompressProfile.profile(value < 0L)) {
            throw new CantCompressNegativeException();
        }
        WriteBERNode.writeBytes(frame, this.encode(value));
        return null;
    }

    @Specialization
    Object doWrite(VirtualFrame frame, RubyBignum value) {
        if (this.cantCompressProfile.profile(value.value.signum() < 0)) {
            throw new CantCompressNegativeException();
        }
        WriteBERNode.writeBytes(frame, this.encode(value));
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] encode(Object from) {
        long l;
        ByteArrayBuilder buf;
        block11: {
            buf = new ByteArrayBuilder();
            if (from instanceof RubyBignum) {
                from = ((RubyBignum)from).value;
                while (true) {
                    BigInteger bignum = (BigInteger)from;
                    BigInteger[] ary = bignum.divideAndRemainder(this.BIG_128);
                    buf.append((byte)(ary[1].longValue() | 0x80L) & 0xFF);
                    if (ary[0].compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                        l = ary[0].longValue();
                        break block11;
                    }
                    from = ary[0];
                }
            }
            if (from instanceof Integer) {
                l = ((Integer)from).intValue();
            } else if (from instanceof Long) {
                l = (Long)from;
            } else {
                throw new UnsupportedOperationException();
            }
        }
        while (l != 0L) {
            buf.append((byte)((l & 0x7FL | 0x80L) & 0xFFL));
            l >>= 7;
        }
        int left = 0;
        int right = buf.getLength() - 1;
        if (right >= 0) {
            byte[] byArray = buf.getUnsafeBytes();
            byArray[0] = (byte)(byArray[0] & 0x7F);
        } else {
            buf.append(0);
        }
        while (left < right) {
            byte tmp = buf.getUnsafeBytes()[left];
            buf.getUnsafeBytes()[left] = buf.getUnsafeBytes()[right];
            buf.getUnsafeBytes()[right] = tmp;
            ++left;
            --right;
        }
        return buf.getBytes();
    }
}

