/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.hash.HashDeconstructKeysNodeGen;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

@NodeChildren(value={@NodeChild(value="valueNode", type=RubyNode.class), @NodeChild(value="keysNode", type=RubyNode.class)})
public abstract class HashDeconstructKeysNode
extends RubyContextSourceNode {
    abstract RubyNode getValueNode();

    abstract RubyNode getKeysNode();

    @Specialization
    Object deconstructKeys(VirtualFrame frame, Object toMatch, Object keys, @Cached DispatchNode respondToNode, @Cached BooleanCastNode booleanCastNode, @Cached DispatchNode deconstructKeysNode, @Cached InlinedConditionProfile hasDeconstructKeysProfile, @Cached InlinedBranchProfile errorProfile) {
        if (hasDeconstructKeysProfile.profile((Node)this, booleanCastNode.execute(this, respondToNode.callWithFrame(DispatchConfiguration.PUBLIC, (Frame)frame, toMatch, "respond_to?", this.coreSymbols().DECONSTRUCT_KEYS)))) {
            Object deconstructed = deconstructKeysNode.callWithFrame(DispatchConfiguration.PUBLIC, (Frame)frame, toMatch, "deconstruct_keys", keys);
            if (deconstructed instanceof RubyHash) {
                return deconstructed;
            }
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("deconstruct_keys must return Hash", this));
        }
        return nil;
    }

    @Override
    public RubyNode cloneUninitialized() {
        return HashDeconstructKeysNodeGen.create(this.getValueNode().cloneUninitialized(), this.getKeysNode().cloneUninitialized()).copyFlags(this);
    }
}

