/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.language.CallStackManager;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;

@GenerateNodeFactory
@GenerateInline(value=false, inherit=true)
public abstract class AlwaysInlinedMethodNode
extends RubyBaseNode {
    public abstract Object execute(Frame var1, Object var2, Object[] var3, RootCallTarget var4);

    protected void needCallerFrame(Frame callerFrame, RootCallTarget target) {
        AlwaysInlinedMethodNode.needCallerFrame(this, callerFrame, target);
    }

    protected static void needCallerFrame(Node node, Frame callerFrame, RootCallTarget target) {
        if (callerFrame == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw AlwaysInlinedMethodNode.buildException(node, target);
        }
        assert (CallStackManager.isRubyFrame(callerFrame));
    }

    protected void needCallerFrame(Frame callerFrame, String method) {
        if (callerFrame == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw AlwaysInlinedMethodNode.buildException((Node)this, method);
        }
        assert (CallStackManager.isRubyFrame(callerFrame));
    }

    @CompilerDirectives.TruffleBoundary
    private static RaiseException buildException(Node node, RootCallTarget target) {
        return AlwaysInlinedMethodNode.buildException(node, target.getRootNode().getName());
    }

    @CompilerDirectives.TruffleBoundary
    private static RaiseException buildException(Node node, String method) {
        return new RaiseException(AlwaysInlinedMethodNode.getContext(node), AlwaysInlinedMethodNode.coreExceptions(node).runtimeError(method + " needs the caller frame but it was not passed (cannot be called directly from a foreign language)", node));
    }

    public static boolean isBlockProvided(Object[] rubyArgs) {
        return RubyArguments.getBlock(rubyArgs) != nil;
    }
}

