/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.inlined.InlinedNegNodeGen;
import org.truffleruby.core.inlined.UnaryInlinedOperationNode;
import org.truffleruby.core.numeric.IntegerNodes;
import org.truffleruby.core.numeric.IntegerNodesFactory;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;

public abstract class InlinedNegNode
extends UnaryInlinedOperationNode {
    @Node.Child
    IntegerNodes.NegNode fixnumNeg;

    public InlinedNegNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, language.coreMethodAssumptions.integerNegAssumption, language.coreMethodAssumptions.floatNegAssumption);
    }

    @Specialization(assumptions={"assumptions"})
    Object intNeg(int value) {
        return this.getNegNode().executeNeg(value);
    }

    @Specialization(assumptions={"assumptions"})
    Object longNeg(long value) {
        return this.getNegNode().executeNeg(value);
    }

    @Specialization(assumptions={"assumptions"})
    double floatNeg(double value) {
        return -value;
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object self) {
        return this.rewriteAndCall(frame, self, new Object[0]);
    }

    private IntegerNodes.NegNode getNegNode() {
        if (this.fixnumNeg == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fixnumNeg = (IntegerNodes.NegNode)this.insert(IntegerNodesFactory.NegNodeFactory.create(null));
        }
        return this.fixnumNeg;
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedNegNode copy = InlinedNegNodeGen.create(this.getLanguage(), this.parameters, this.getSelfNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

