/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.kernel;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.exception.RubySystemExit;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.control.ExitException;
import org.truffleruby.language.control.RaiseException;

public final class AtExitManager {
    private final RubyContext context;
    private final RubyLanguage language;
    private final Deque<RubyProc> atExitHooks = new ConcurrentLinkedDeque<RubyProc>();
    private final Deque<RubyProc> systemExitHooks = new ConcurrentLinkedDeque<RubyProc>();

    public AtExitManager(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
    }

    public void add(RubyProc block, boolean always) {
        if (always) {
            this.systemExitHooks.push(block);
        } else {
            this.atExitHooks.push(block);
        }
    }

    public AbstractTruffleException runAtExitHooks() {
        return this.runExitHooks(this.atExitHooks);
    }

    public void runSystemExitHooks() {
        try {
            this.runExitHooks(this.systemExitHooks);
        }
        catch (ThreadDeath | ExitException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            BacktraceFormatter.printInternalError(this.context, e, "unexpected internal exception in system at_exit");
        }
    }

    @CompilerDirectives.TruffleBoundary
    private AbstractTruffleException runExitHooks(Deque<RubyProc> stack) {
        AbstractTruffleException lastException = null;
        RubyProc block;
        while ((block = stack.poll()) != null) {
            try {
                ProcOperations.rootCall(block, NoKeywordArgumentsDescriptor.INSTANCE, RubyBaseNode.EMPTY_ARGUMENTS);
                continue;
            }
            catch (AbstractTruffleException e) {
                AtExitManager.handleAtExitException(this.context, this.language, e);
                lastException = e;
                continue;
            }
            break;
        }
        return lastException;
    }

    public List<RubyProc> getHandlers() {
        ArrayList<RubyProc> handlers = new ArrayList<RubyProc>();
        handlers.addAll(this.atExitHooks);
        handlers.addAll(this.systemExitHooks);
        return handlers;
    }

    public static boolean isSilentException(RubyContext context, AbstractTruffleException exception) {
        if (!(exception instanceof RaiseException)) {
            return false;
        }
        RubyException rubyException = ((RaiseException)exception).getException();
        return rubyException instanceof RubySystemExit || rubyException.getLogicalClass() == context.getCoreLibrary().signalExceptionClass;
    }

    private static void handleAtExitException(RubyContext context, RubyLanguage language, AbstractTruffleException exception) {
        language.getCurrentFiber().setLastException(ExceptionOperations.getExceptionObject(exception));
        if (!AtExitManager.isSilentException(context, exception)) {
            context.getDefaultBacktraceFormatter().printRubyExceptionOnEnvStderr("", exception);
        }
    }
}

