/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.module;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveNode;
import org.truffleruby.builtins.ReRaiseInlinedExceptionNode;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayOperations;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.BooleanCastWithDefaultNode;
import org.truffleruby.core.cast.NameToJavaStringNode;
import org.truffleruby.core.cast.SingleValueCastNode;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.cast.ToPathNode;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.cast.ToStringOrSymbolNode;
import org.truffleruby.core.cast.ToSymbolNode;
import org.truffleruby.core.constant.WarnAlreadyInitializedNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.MethodFilter;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.method.RubyUnboundMethod;
import org.truffleruby.core.module.ConstantLookupResult;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.core.module.ModuleNodesFactory;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.support.TypeNodes;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.LazyWarnNode;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyLambdaRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.WarningNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.constants.ConstantEntry;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.constants.LookupConstantInterface;
import org.truffleruby.language.constants.LookupConstantNode;
import org.truffleruby.language.constants.WarnDeprecatedConstantNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.loader.EvalLoader;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.UsingNode;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.language.objects.IsFrozenNode;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.language.objects.SingletonClassNodeGen;
import org.truffleruby.language.objects.WriteObjectFieldNode;
import org.truffleruby.language.objects.classvariables.CheckClassVariableNameNode;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;
import org.truffleruby.language.objects.classvariables.LookupClassVariableNode;
import org.truffleruby.language.objects.classvariables.SetClassVariableNode;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.parser.Identifiers;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;

@CoreModule(value="Module", isClass=true)
public abstract class ModuleNodes {
    @CompilerDirectives.TruffleBoundary
    public static RubyModule createModule(RubyContext context, SourceSection sourceSection, RubyClass selfClass, RubyModule lexicalParent, String name, Node currentNode) {
        RubyModule module = new RubyModule(selfClass, context.getLanguageSlow().moduleShape, context.getLanguageSlow(), sourceSection, lexicalParent, name);
        module.fields.afterConstructed();
        if (lexicalParent != null) {
            lexicalParent.fields.setConstant(context, currentNode, name, module);
        }
        return module;
    }

    @CoreMethod(names={"undefined_instance_methods"})
    public static abstract class UndefinedInstanceMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyArray undefinedInstanceMethods(RubyModule module) {
            ArrayList<RubySymbol> methodNames = new ArrayList<RubySymbol>();
            for (InternalMethod methodEntry : module.fields.getMethods()) {
                if (!methodEntry.isUndefined()) continue;
                methodNames.add(this.getLanguage().getSymbol(methodEntry.getName()));
            }
            return this.createArray(methodNames.toArray());
        }
    }

    @CoreMethod(names={"singleton_class?"})
    public static abstract class IsSingletonClassNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isRubyClass(rubyModule)"})
        Object doModule(RubyModule rubyModule) {
            return false;
        }

        @Specialization
        Object doClass(RubyClass rubyClass) {
            return rubyClass.isSingleton;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule allocate(RubyClass rubyClass) {
            return ModuleNodes.createModule(this.getContext(), this.getEncapsulatingSourceSection(), rubyClass, null, null, this);
        }
    }

    @CoreMethod(names={"using"}, required=1, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    public static abstract class ModuleUsingNode
    extends UsingNode {
        @Specialization
        Object moduleUsing(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached InlinedBranchProfile errorProfile) {
            this.needCallerFrame(callerFrame, target);
            Object refinementModule = RubyArguments.getArgument(rubyArgs, 0);
            if (self != RubyArguments.getSelf(callerFrame)) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("Module#using is not called on self", this));
            }
            InternalMethod callerMethod = RubyArguments.getMethod(callerFrame);
            if (!callerMethod.getSharedMethodInfo().isModuleBody()) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("Module#using is not permitted in methods", this));
            }
            this.using(callerFrame, refinementModule, errorProfile);
            return self;
        }
    }

    @CoreMethod(names={"set_temporary_name"}, required=1)
    public static abstract class SetTemporaryNameNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyModule setTemporaryName(RubyModule self, Object name, @Cached ToJavaStringNode toJavaStringNode) {
            if (name == nil) {
                self.fields.setTemporaryName(null);
                return self;
            }
            String string = toJavaStringNode.execute(this, name);
            this.validateName(string, self);
            self.fields.setTemporaryName(string);
            return self;
        }

        private void validateName(String name, RubyModule self) {
            if (name.isEmpty()) {
                throw new RaiseException(SetTemporaryNameNode.getContext(this), SetTemporaryNameNode.coreExceptions(this).argumentError("empty class/module name", this));
            }
            if (self.fields.hasFullName()) {
                throw new RaiseException(SetTemporaryNameNode.getContext(this), SetTemporaryNameNode.coreExceptions(this).runtimeError("can't change permanent name", this));
            }
            if (Identifiers.isValidConstantPath(name)) {
                throw new RaiseException(SetTemporaryNameNode.getContext(this), SetTemporaryNameNode.coreExceptions(this).argumentError("the temporary name must not be a constant path to avoid confusion", this));
            }
        }
    }

    @CoreMethod(names={"refine"}, needsBlock=true, required=1, visibility=Visibility.PRIVATE, split=Split.NEVER)
    public static abstract class RefineNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule refine(RubyModule self, Object moduleToRefine, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("no block given", this));
        }

        @Specialization(guards={"!isRubyModule(moduleToRefine)"})
        RubyModule refineNotModule(RubyModule self, Object moduleToRefine, RubyProc block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorWrongArgumentType(moduleToRefine, "Class or Module", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyModule refine(RubyModule namespace, RubyModule moduleToRefine, RubyProc block) {
            ConcurrentMap<RubyModule, RubyModule> refinements = namespace.fields.getRefinements();
            RubyModule refinement = ConcurrentOperations.getOrCompute(refinements, moduleToRefine, klass -> this.newRefinementModule(namespace, moduleToRefine));
            HashMap<RubyModule, RubyModule[]> refinementsInDeclarationContext = new HashMap<RubyModule, RubyModule[]>();
            for (Map.Entry existingRefinement : refinements.entrySet()) {
                refinementsInDeclarationContext.put((RubyModule)existingRefinement.getKey(), new RubyModule[]{(RubyModule)existingRefinement.getValue()});
            }
            refinementsInDeclarationContext.put(moduleToRefine, new RubyModule[]{refinement});
            DeclarationContext declarationContext = new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.FixedDefaultDefinee(refinement), refinementsInDeclarationContext);
            for (RubyModule existingRefinement : refinements.values()) {
                ModuleFields fields = existingRefinement.fields;
                for (InternalMethod refinedMethodInExistingRefinement : fields.getMethods()) {
                    fields.addMethod(this.getContext(), this, refinedMethodInExistingRefinement.withDeclarationContext(declarationContext));
                }
            }
            CallBlockNode.executeUncached(declarationContext, block, refinement, nil, NoKeywordArgumentsDescriptor.INSTANCE, EMPTY_ARGUMENTS);
            return refinement;
        }

        private RubyModule newRefinementModule(RubyModule namespace, RubyModule moduleToRefine) {
            RubyModule refinement = ModuleNodes.createModule(this.getContext(), this.getEncapsulatingSourceSection(), this.coreLibrary().refinementClass, null, null, this);
            ModuleFields refinementFields = refinement.fields;
            refinementFields.setupRefinementModule(moduleToRefine, namespace);
            return refinement;
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class SetMethodVisibilityNode
    extends RubyBaseNode {
        public abstract void execute(Node var1, RubyModule var2, Object var3, Visibility var4);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isRubyArray(name)"})
        static void setMethodVisibility(Node node, RubyModule module, Object name, Visibility visibility, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String methodName = nameToJavaStringNode.execute(node, name);
            InternalMethod method = module.fields.deepMethodSearch(SetMethodVisibilityNode.getContext(node), methodName);
            if (method == null) {
                throw new RaiseException(SetMethodVisibilityNode.getContext(node), (RubyException)SetMethodVisibilityNode.coreExceptions(node).nameErrorUndefinedMethod(methodName, module, node));
            }
            if (method.getVisibility() == visibility) {
                return;
            }
            module.addMethodIgnoreNameVisibility(SetMethodVisibilityNode.getContext(node), method, visibility, node);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static void setMethodVisibilityArray(Node node, RubyModule module, RubyArray array, Visibility visibility, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            for (Object name : ArrayOperations.toIterable(array)) {
                SetMethodVisibilityNode.setMethodVisibility(node, module, name, visibility, nameToJavaStringNode);
                TruffleSafepoint.poll((Node)node);
            }
        }
    }

    @CoreMethod(names={"refinements"})
    public static abstract class RefinementsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray refinements(RubyModule self) {
            return this.createArray(self.fields.getRefinements().values().toArray());
        }
    }

    @CoreMethod(names={"used_refinements"}, onSingleton=true)
    public static abstract class UsedRefinementsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray usedRefinements() {
            Frame frame = this.getContext().getCallStack().getCallerFrame(FrameInstance.FrameAccess.READ_ONLY);
            DeclarationContext declarationContext = RubyArguments.getDeclarationContext(frame);
            ArrayList refinements = new ArrayList();
            for (RubyModule[] refinementModules : declarationContext.getRefinements().values()) {
                Collections.addAll(refinements, refinementModules);
            }
            return this.createArray(refinements.toArray());
        }
    }

    @CoreMethod(names={"used_modules"}, onSingleton=true)
    public static abstract class UsedModulesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray usedModules() {
            Frame frame = this.getContext().getCallStack().getCallerFrame(FrameInstance.FrameAccess.READ_ONLY);
            DeclarationContext declarationContext = RubyArguments.getDeclarationContext(frame);
            HashSet<RubyModule> refinementNamespaces = new HashSet<RubyModule>();
            for (RubyModule[] refinementModules : declarationContext.getRefinements().values()) {
                for (RubyModule refinementModule : refinementModules) {
                    refinementNamespaces.add(refinementModule.fields.getRefinementNamespace());
                }
            }
            return this.createArray(refinementNamespaces.toArray());
        }
    }

    public static final class UndefNode
    extends RubyContextSourceNode {
        @Node.Children
        private final RubyNode[] names;

        public UndefNode(RubyNode[] names) {
            this.names = names;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            RubyModule module = RubyArguments.getDeclarationContext((Frame)frame).getModuleToDefineMethods();
            for (RubyNode nameNode : this.names) {
                Object nameObject = nameNode.execute(frame);
                RubySymbol nameSymbol = (RubySymbol)nameObject;
                module.fields.undefMethod(this.getLanguage(), this.getContext(), this, nameSymbol.getString());
            }
            return module;
        }

        @Override
        public RubyNode cloneUninitialized() {
            return new UndefNode(UndefNode.cloneUninitialized(this.names)).copyFlags(this);
        }
    }

    @CoreMethod(names={"undef_method"}, rest=true, split=Split.NEVER, argumentNames={"names"})
    public static abstract class UndefMethodNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyModule undefMethods(RubyModule module, Object[] names, @Cached NameToJavaStringNode nameToJavaStringNode) {
            for (Object name : names) {
                module.fields.undefMethod(this.getLanguage(), this.getContext(), this, nameToJavaStringNode.execute(this, name));
            }
            return module;
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString toS(RubyModule module, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String moduleName = module.fields.isRefinement() ? module.fields.getRefinementName() : module.fields.getName();
            return this.createString(fromJavaStringNode, moduleName, Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"remove_method"}, rest=true)
    public static abstract class RemoveMethodNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile errorProfile = BranchProfile.create();
        @Node.Child
        private DispatchNode methodRemovedNode = DispatchNode.create();

        @Specialization
        RubyModule removeMethods(RubyModule module, Object[] names, @Cached TypeNodes.CheckFrozenNode raiseIfFrozenNode, @Cached NameToJavaStringNode nameToJavaStringNode) {
            for (Object name : names) {
                this.removeMethod(module, nameToJavaStringNode.execute(this, name), raiseIfFrozenNode);
            }
            return module;
        }

        private void removeMethod(RubyModule module, String name, TypeNodes.CheckFrozenNode raiseIfFrozenNode) {
            raiseIfFrozenNode.execute(this, module);
            if (module.fields.removeMethod(this.getContext(), name, this)) {
                if (RubyGuards.isSingletonClass(module)) {
                    RubyDynamicObject receiver = ((RubyClass)module).attached;
                    this.methodRemovedNode.call((Object)receiver, "singleton_method_removed", this.getSymbol(name));
                } else {
                    this.methodRemovedNode.call((Object)module, "method_removed", this.getSymbol(name));
                }
            } else {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorMethodNotDefinedIn(module, name, this));
            }
        }
    }

    @Primitive(name="module_remove_const")
    public static abstract class RemoveConstNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object removeConstant(RubyModule module, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached LazyWarnNode lazyWarnNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            RubyConstant oldConstant = module.fields.removeConstant(this.getContext(), this, name);
            if (oldConstant == null) {
                throw new RaiseException(this.getContext(), this.coreExceptions().nameErrorConstantNotDefined(module, name, this));
            }
            if (oldConstant.isAutoload() || oldConstant.isUndefined()) {
                return nil;
            }
            if (oldConstant.isDeprecated()) {
                this.warnDeprecatedConstant(module, name, lazyWarnNode);
            }
            return oldConstant.getValue();
        }

        private void warnDeprecatedConstant(RubyModule module, String name, LazyWarnNode lazyWarnNode) {
            WarnDeprecatedConstantNode.warnDeprecatedConstant(this, lazyWarnNode.get(this), module, name);
        }
    }

    @CoreMethod(names={"remove_class_variable"}, required=1, split=Split.ALWAYS)
    public static abstract class RemoveClassVariableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object removeClassVariableString(RubyModule module, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached CheckClassVariableNameNode checkClassVariableNameNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            checkClassVariableNameNode.execute(this, module, name);
            return ModuleOperations.removeClassVariable(module.fields, this.getContext(), this, name);
        }
    }

    @CoreMethod(names={"protected"}, rest=true, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    @ImportStatic(value={RubyArguments.class})
    public static abstract class ProtectedNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"names.length == 0"})
        Object frame(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names) {
            this.needCallerFrame(callerFrame, "Module#protected with no arguments");
            DeclarationContext.setCurrentVisibility(callerFrame, Visibility.PROTECTED);
            return nil;
        }

        @Specialization(guards={"names.length > 0"})
        static Object methods(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names, @Cached SetMethodVisibilityNode setMethodVisibilityNode, @Cached SingleValueCastNode singleValueCastNode, @Bind(value="this") Node node) {
            for (Object name : names) {
                setMethodVisibilityNode.execute(node, module, name, Visibility.PROTECTED);
            }
            return singleValueCastNode.execute(node, names);
        }
    }

    @CoreMethod(names={"public_constant"}, rest=true)
    public static abstract class PublicConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule publicConstant(RubyModule module, Object[] args, @Cached NameToJavaStringNode nameToJavaStringNode) {
            for (Object arg : args) {
                String name = nameToJavaStringNode.execute(this, arg);
                module.fields.changeConstantVisibility(this.getContext(), this, name, false);
            }
            return module;
        }
    }

    @CoreMethod(names={"deprecate_constant"}, rest=true, raiseIfFrozenSelf=true)
    public static abstract class DeprecateConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule deprecateConstant(RubyModule module, Object[] args, @Cached NameToJavaStringNode nameToJavaStringNode) {
            for (Object arg : args) {
                String name = nameToJavaStringNode.execute(this, arg);
                module.fields.deprecateConstant(this.getContext(), this, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"private_constant"}, rest=true)
    public static abstract class PrivateConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule privateConstant(RubyModule module, Object[] args, @Cached NameToJavaStringNode nameToJavaStringNode) {
            for (Object arg : args) {
                String name = nameToJavaStringNode.execute(this, arg);
                module.fields.changeConstantVisibility(this.getContext(), this, name, true);
            }
            return module;
        }
    }

    @CoreMethod(names={"instance_method"}, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class InstanceMethodNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        RubyUnboundMethod instanceMethod(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached InlinedBranchProfile errorProfile) {
            this.needCallerFrame(callerFrame, target);
            DeclarationContext declarationContext = RubyArguments.getDeclarationContext(callerFrame);
            String name = nameToJavaStringNode.execute(this, RubyArguments.getArgument(rubyArgs, 0));
            InternalMethod method = ModuleOperations.lookupMethodUncached(module, name, declarationContext);
            if (method == null || method.isUndefined()) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorUndefinedMethod(name, module, this));
            }
            RubyUnboundMethod instance = new RubyUnboundMethod(this.coreLibrary().unboundMethodClass, this.getLanguage().unboundMethodShape, module, method);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"instance_methods"}, optional=1)
    public static abstract class InstanceMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray instanceMethods(RubyModule module, Object maybeIncludeAncestors, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode) {
            boolean includeAncestors = booleanCastWithDefaultNode.execute(this, maybeIncludeAncestors, true);
            Object[] objects = module.fields.filterMethods(this.getLanguage(), includeAncestors, MethodFilter.PUBLIC_PROTECTED).toArray();
            return this.createArray(objects);
        }
    }

    @CoreMethod(names={"private_method_defined?"}, required=1, optional=1)
    public static abstract class PrivateMethodDefinedNode
    extends AbstractMethodDefinedNode {
        public PrivateMethodDefinedNode() {
            super(Visibility.PRIVATE);
        }
    }

    @CoreMethod(names={"protected_method_defined?"}, required=1, optional=1)
    public static abstract class ProtectedMethodDefinedNode
    extends AbstractMethodDefinedNode {
        public ProtectedMethodDefinedNode() {
            super(Visibility.PROTECTED);
        }
    }

    @CoreMethod(names={"public_method_defined?"}, required=1, optional=1)
    public static abstract class PublicMethodDefinedNode
    extends AbstractMethodDefinedNode {
        public PublicMethodDefinedNode() {
            super(Visibility.PUBLIC);
        }
    }

    protected static abstract class AbstractMethodDefinedNode
    extends CoreMethodArrayArgumentsNode {
        final Visibility visibility;

        public AbstractMethodDefinedNode(Visibility visibility) {
            this.visibility = visibility;
        }

        @Specialization
        boolean isMethodDefined(RubyModule module, Object nameObject, Object maybeInheritObject, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached InlinedConditionProfile inheritProfile) {
            boolean inherit = booleanCastWithDefaultNode.execute(this, maybeInheritObject, true);
            String name = nameToJavaStringNode.execute(this, nameObject);
            InternalMethod method = inheritProfile.profile((Node)this, inherit) ? ModuleOperations.lookupMethodUncached(module, name, null) : module.fields.getMethod(name);
            return method != null && !method.isUndefined() && !method.isUnimplemented() && method.getVisibility() == this.visibility;
        }
    }

    @CoreMethod(names={"private_instance_methods"}, optional=1)
    public static abstract class PrivateInstanceMethodsNode
    extends AbstractInstanceMethodsNode {
        public PrivateInstanceMethodsNode() {
            super(Visibility.PRIVATE);
        }
    }

    @CoreMethod(names={"protected_instance_methods"}, optional=1)
    public static abstract class ProtectedInstanceMethodsNode
    extends AbstractInstanceMethodsNode {
        public ProtectedInstanceMethodsNode() {
            super(Visibility.PROTECTED);
        }
    }

    @CoreMethod(names={"public_instance_methods"}, optional=1)
    public static abstract class PublicInstanceMethodsNode
    extends AbstractInstanceMethodsNode {
        public PublicInstanceMethodsNode() {
            super(Visibility.PUBLIC);
        }
    }

    protected static abstract class AbstractInstanceMethodsNode
    extends CoreMethodArrayArgumentsNode {
        final Visibility visibility;

        public AbstractInstanceMethodsNode(Visibility visibility) {
            this.visibility = visibility;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyArray getInstanceMethods(RubyModule module, Object maybeIncludeAncestors, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode) {
            boolean includeAncestors = booleanCastWithDefaultNode.execute(this, maybeIncludeAncestors, true);
            Object[] objects = module.fields.filterMethods(this.getLanguage(), includeAncestors, MethodFilter.by(this.visibility)).toArray();
            return this.createArray(objects);
        }
    }

    @CoreMethod(names={"public_instance_method"}, required=1)
    public static abstract class PublicInstanceMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyUnboundMethod publicInstanceMethod(RubyModule module, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached InlinedBranchProfile errorProfile) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            InternalMethod method = ModuleOperations.lookupMethodUncached(module, name, null);
            if (method == null || method.isUndefined()) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorUndefinedMethod(name, module, this));
            }
            if (method.getVisibility() != Visibility.PUBLIC) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorPrivateMethod(name, module, this));
            }
            RubyUnboundMethod instance = new RubyUnboundMethod(this.coreLibrary().unboundMethodClass, this.getLanguage().unboundMethodShape, module, method);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"private_class_method"}, rest=true, split=Split.NEVER)
    public static abstract class PrivateClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyModule privateClassMethod(RubyModule module, Object[] names) {
            RubyClass singletonClass = SingletonClassNodeGen.getUncached().execute(module);
            for (Object name : names) {
                ModuleNodesFactory.SetMethodVisibilityNodeGen.getUncached().execute(this, singletonClass, name, Visibility.PRIVATE);
            }
            return module;
        }
    }

    @CoreMethod(names={"prepend_features"}, required=1, visibility=Visibility.PRIVATE, split=Split.NEVER)
    public static abstract class PrependFeaturesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object prependFeatures(RubyModule features, RubyModule target, @Cached InlinedBranchProfile errorProfile) {
            if (features instanceof RubyClass) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("prepend_features must be called only on modules", this));
            }
            target.fields.prepend(this.getContext(), this, features);
            return nil;
        }
    }

    @CoreMethod(names={"private"}, rest=true, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    @ImportStatic(value={RubyArguments.class})
    public static abstract class PrivateNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"names.length == 0"})
        Object frame(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names) {
            this.needCallerFrame(callerFrame, "Module#private with no arguments");
            DeclarationContext.setCurrentVisibility(callerFrame, Visibility.PRIVATE);
            return nil;
        }

        @Specialization(guards={"names.length > 0"})
        static Object methods(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names, @Cached SetMethodVisibilityNode setMethodVisibilityNode, @Cached SingleValueCastNode singleValueCastNode, @Bind(value="this") Node node) {
            for (Object name : names) {
                setMethodVisibilityNode.execute(node, module, name, Visibility.PRIVATE);
            }
            return singleValueCastNode.execute(node, names);
        }
    }

    @CoreMethod(names={"public_class_method"}, rest=true, split=Split.NEVER)
    public static abstract class PublicClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyModule publicClassMethod(RubyModule module, Object[] names) {
            RubyClass singletonClass = SingletonClassNodeGen.getUncached().execute(module);
            for (Object name : names) {
                ModuleNodesFactory.SetMethodVisibilityNodeGen.getUncached().execute(this, singletonClass, name, Visibility.PUBLIC);
            }
            return module;
        }
    }

    @CoreMethod(names={"public"}, rest=true, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    @ImportStatic(value={RubyArguments.class})
    public static abstract class PublicNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"names.length == 0"})
        Object frame(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names) {
            this.needCallerFrame(callerFrame, "Module#public with no arguments");
            DeclarationContext.setCurrentVisibility(callerFrame, Visibility.PUBLIC);
            return nil;
        }

        @Specialization(guards={"names.length > 0"})
        static Object methods(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names, @Cached SetMethodVisibilityNode setMethodVisibilityNode, @Cached SingleValueCastNode singleValueCastNode, @Bind(value="this") Node node) {
            for (Object name : names) {
                setMethodVisibilityNode.execute(node, module, name, Visibility.PUBLIC);
            }
            return singleValueCastNode.execute(node, names);
        }
    }

    @CoreMethod(names={"nesting"}, onSingleton=true)
    public static abstract class NestingNode
    extends CoreMethodNode {
        public abstract RubyArray execute();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray nesting() {
            RubyModule enclosing;
            ArrayList<RubyModule> modules = new ArrayList<RubyModule>();
            RubyClass objectClass = this.coreLibrary().objectClass;
            for (LexicalScope lexicalScope = (method = this.getContext().getCallStack().getCallingMethod()) == null ? null : method.getLexicalScope(); lexicalScope != null && (enclosing = lexicalScope.getLiveModule()) != objectClass; lexicalScope = lexicalScope.getParent()) {
                modules.add(enclosing);
            }
            return this.createArray(modules.toArray());
        }
    }

    @Primitive(name="caller_nesting")
    public static abstract class CallerNestingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyArray nesting(@Cached NestingNode nestingNode) {
            return nestingNode.execute();
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object name(RubyModule module) {
            return module.fields.getRubyStringName();
        }
    }

    @CoreMethod(names={"module_function"}, rest=true, visibility=Visibility.PRIVATE, alwaysInlined=true)
    @GenerateUncached
    @ImportStatic(value={RubyArguments.class})
    public static abstract class ModuleFunctionNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"names.length == 0"})
        Object frame(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names, @Cached @Cached.Exclusive InlinedBranchProfile errorProfile) {
            ModuleFunctionNode.checkNotClass(this, module, errorProfile);
            this.needCallerFrame(callerFrame, "Module#module_function with no arguments");
            DeclarationContext.setCurrentVisibility(callerFrame, Visibility.MODULE_FUNCTION);
            return nil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"names.length > 0"})
        static Object methods(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Bind(value="getPositionalArguments(rubyArgs)") Object[] names, @Cached SetMethodVisibilityNode setMethodVisibilityNode, @Cached @Cached.Exclusive InlinedBranchProfile errorProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached SingleValueCastNode singleValueCastNode, @Bind(value="this") Node node) {
            ModuleFunctionNode.checkNotClass(node, module, errorProfile);
            int i = 0;
            try {
                while (loopProfile.inject(node, i < names.length)) {
                    setMethodVisibilityNode.execute(node, module, names[i], Visibility.MODULE_FUNCTION);
                    TruffleSafepoint.poll((Node)node);
                    ++i;
                }
            }
            finally {
                ModuleFunctionNode.profileAndReportLoopCount(node, loopProfile, i);
            }
            return singleValueCastNode.execute(node, names);
        }

        private static void checkNotClass(Node node, RubyModule module, InlinedBranchProfile errorProfile) {
            if (module instanceof RubyClass) {
                errorProfile.enter(node);
                throw new RaiseException(ModuleFunctionNode.getContext(node), ModuleFunctionNode.coreExceptions(node).typeError("module_function must be called for modules", node));
            }
        }
    }

    @CoreMethod(names={"method_defined?"}, required=1, optional=1)
    public static abstract class MethodDefinedNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean isMethodDefined(RubyModule module, Object nameObject, Object maybeInherit, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            boolean inherit = booleanCastWithDefaultNode.execute(this, maybeInherit, true);
            InternalMethod method = inherit ? ModuleOperations.lookupMethodUncached(module, name, null) : module.fields.getMethod(name);
            return method != null && !method.isUndefined() && method.getVisibility() != Visibility.PRIVATE;
        }
    }

    @CoreMethod(names={"included_modules"})
    public static abstract class IncludedModulesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray includedModules(RubyModule module) {
            ArrayList<RubyModule> modules = new ArrayList<RubyModule>();
            for (RubyModule included : module.fields.ancestors()) {
                if (included instanceof RubyClass || included == module) continue;
                modules.add(included);
            }
            return this.createArray(modules.toArray());
        }
    }

    @CoreMethod(names={"included"}, needsSelf=false, required=1, visibility=Visibility.PRIVATE)
    public static abstract class IncludedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object included(Object subclass) {
            return nil;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isRubyClass(self)", "!isRubyClass(from)"})
        Object initializeCopyModule(RubyModule self, RubyModule from, @Cached @Cached.Shared SingletonClassNode singletonClassNode) {
            self.fields.initCopy(from);
            RubyClass selfMetaClass = singletonClassNode.execute(self);
            RubyClass fromMetaClass = singletonClassNode.execute(from);
            selfMetaClass.fields.initCopy(fromMetaClass);
            return nil;
        }

        @Specialization
        Object initializeCopyClass(RubyClass self, RubyClass from, @Cached @Cached.Shared SingletonClassNode singletonClassNode, @Cached InlinedBranchProfile errorProfile) {
            if (from == this.coreLibrary().basicObjectClass) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("can't copy the root class", this));
            }
            if (from.isSingleton) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("can't copy singleton class", this));
            }
            self.fields.initCopy(from);
            RubyClass selfMetaClass = singletonClassNode.execute(self);
            RubyClass fromMetaClass = from.getMetaClass();
            assert (fromMetaClass.isSingleton);
            assert (self.getMetaClass().isSingleton);
            selfMetaClass.fields.initCopy(fromMetaClass);
            return nil;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public abstract RubyModule executeInitialize(RubyModule var1, Object var2);

        @Specialization
        RubyModule initialize(RubyModule module, Nil block) {
            return module;
        }

        @Specialization
        RubyModule initialize(RubyModule module, RubyProc block, @Cached ClassExecBlockNode classExecBlockNode) {
            classExecBlockNode.execute(this, NoKeywordArgumentsDescriptor.INSTANCE, module, new Object[]{module}, block);
            return module;
        }
    }

    @CoreMethod(names={"extended"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class ExtendedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object extended(RubyModule module, Object object) {
            return nil;
        }
    }

    @CoreMethod(names={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class ExtendObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule extendObject(RubyModule module, Object object, @Cached SingletonClassNode singletonClassNode, @Cached InlinedBranchProfile errorProfile) {
            if (module instanceof RubyClass) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorWrongArgumentType(module, "Module", this));
            }
            singletonClassNode.execute((Object)object).fields.include(this.getContext(), this, module);
            return module;
        }
    }

    @CoreMethod(names={"define_method"}, needsBlock=true, required=1, optional=1, argumentNames={"name", "proc_or_method", "block"}, alwaysInlined=true)
    @GenerateUncached
    @ImportStatic(value={RubyArguments.class})
    public static abstract class DefineMethodNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"isMethodParameterProvided(rubyArgs)", "isRubyMethod(getArgument(rubyArgs, 1))"})
        RubySymbol defineMethodWithMethod(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, RubyArguments.getArgument(rubyArgs, 0));
            Object method = RubyArguments.getArgument(rubyArgs, 1);
            this.needCallerFrame(callerFrame, target);
            return this.addMethod(module, name, (RubyMethod)method, callerFrame.materialize());
        }

        @Specialization(guards={"isMethodParameterProvided(rubyArgs)", "isRubyProc(getArgument(rubyArgs, 1))"})
        RubySymbol defineMethodWithProc(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, RubyArguments.getArgument(rubyArgs, 0));
            Object method = RubyArguments.getArgument(rubyArgs, 1);
            this.needCallerFrame(callerFrame, target);
            return this.addProc(module, name, (RubyProc)method, callerFrame.materialize());
        }

        @Specialization(guards={"isMethodParameterProvided(rubyArgs)", "isRubyUnboundMethod(getArgument(rubyArgs, 1))"})
        RubySymbol defineMethodWithUnboundMethod(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, RubyArguments.getArgument(rubyArgs, 0));
            Object method = RubyArguments.getArgument(rubyArgs, 1);
            this.needCallerFrame(callerFrame, target);
            return this.addUnboundMethod(module, name, (RubyUnboundMethod)method, callerFrame.materialize());
        }

        @Specialization(guards={"isMethodParameterProvided(rubyArgs)", "!isExpectedMethodParameterType(getArgument(rubyArgs, 1))"})
        RubySymbol defineMethodWithUnexpectedMethodParameterType(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target) {
            Object method = RubyArguments.getArgument(rubyArgs, 1);
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorExpectedProcOrMethodOrUnboundMethod(method, this));
        }

        @Specialization(guards={"!isMethodParameterProvided(rubyArgs)", "isBlockProvided(rubyArgs)"})
        RubySymbol defineMethodWithBlock(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, RubyArguments.getArgument(rubyArgs, 0));
            Object block = RubyArguments.getBlock(rubyArgs);
            this.needCallerFrame(callerFrame, target);
            return this.addProc(module, name, (RubyProc)block, callerFrame.materialize());
        }

        @Specialization(guards={"!isMethodParameterProvided(rubyArgs)", "!isBlockProvided(rubyArgs)"})
        RubySymbol defineMethodWithoutMethodAndBlock(Frame callerFrame, RubyModule nodule, Object[] rubyArgs, RootCallTarget target) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorProcWithoutBlock(this));
        }

        @CompilerDirectives.TruffleBoundary
        private RubySymbol addMethod(RubyModule module, String name, RubyMethod method, MaterializedFrame callerFrame) {
            InternalMethod internalMethod = method.method;
            if (!ModuleOperations.canBindMethodTo(internalMethod, module)) {
                RubyModule declaringModule = internalMethod.getDeclaringModule();
                if (RubyGuards.isSingletonClass(declaringModule)) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().typeError("can't bind singleton method to a different class", this));
                }
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("class must be a subclass of " + declaringModule.fields.getName(), this));
            }
            return this.addInternalMethod(module, name, internalMethod, callerFrame);
        }

        @CompilerDirectives.TruffleBoundary
        private RubySymbol addUnboundMethod(RubyModule module, String name, RubyUnboundMethod method, MaterializedFrame callerFrame) {
            InternalMethod internalMethod = method.method;
            if (!ModuleOperations.canBindMethodTo(internalMethod, module)) {
                RubyModule declaringModule = internalMethod.getDeclaringModule();
                if (RubyGuards.isSingletonClass(declaringModule)) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().typeError("can't bind singleton method to a different class", this));
                }
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("bind argument must be a subclass of " + declaringModule.fields.getName(), this));
            }
            return this.addInternalMethod(module, name, internalMethod, callerFrame);
        }

        @CompilerDirectives.TruffleBoundary
        private RubySymbol addProc(RubyModule module, String name, RubyProc proc, MaterializedFrame callerFrame) {
            RootCallTarget callTargetForLambda = proc.callTargets.getCallTargetForLambda();
            RubyLambdaRootNode rootNode = RubyLambdaRootNode.of(callTargetForLambda);
            SharedMethodInfo info = proc.getSharedMethodInfo().forDefineMethod(module, name, proc);
            RubyNode body = rootNode.copyBody();
            CallMethodWithLambdaBody newBody = new CallMethodWithLambdaBody(this.isSingleContext() ? proc : null, callTargetForLambda, body);
            RubyLambdaRootNode newRootNode = rootNode.copyRootNode(info, newBody);
            RootCallTarget newCallTarget = newRootNode.getCallTarget();
            InternalMethod internalMethod = InternalMethod.fromProc(this.getContext(), info, proc.declarationContext, name, module, Visibility.PUBLIC, proc, newCallTarget);
            return this.addInternalMethod(module, name, internalMethod, callerFrame);
        }

        @CompilerDirectives.TruffleBoundary
        private RubySymbol addInternalMethod(RubyModule module, String name, InternalMethod method, MaterializedFrame callerFrame) {
            method = method.withName(name);
            Visibility visibility = DeclarationContext.findVisibilityCheckSelfAndDefaultDefinee(module, (Frame)callerFrame);
            module.addMethodConsiderNameVisibility(this.getContext(), method.withOwner(module).withDeclaringModule(module), visibility, this);
            return this.getSymbol(method.getName());
        }

        protected boolean isMethodParameterProvided(Object[] rubyArgs) {
            int count = RubyArguments.getPositionalArgumentsCount(rubyArgs);
            return count >= 2;
        }

        protected boolean isExpectedMethodParameterType(Object method) {
            return RubyGuards.isRubyMethod(method) || RubyGuards.isRubyUnboundMethod(method) || RubyGuards.isRubyProc(method);
        }

        private static final class CallMethodWithLambdaBody
        extends RubyContextSourceNode {
            private final RubyProc proc;
            private final RootCallTarget lambdaCallTarget;
            @Node.Child
            private RubyNode lambdaBody;

            public CallMethodWithLambdaBody(RubyProc proc, RootCallTarget lambdaCallTarget, RubyNode lambdaBody) {
                this.proc = proc;
                this.lambdaCallTarget = lambdaCallTarget;
                this.lambdaBody = lambdaBody;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                RubyProc proc;
                if (this.proc == null) {
                    proc = RubyArguments.getMethod((Frame)frame).getProc();
                    assert (proc.callTargets.getCallTargetForLambda() == this.lambdaCallTarget);
                } else {
                    assert (RubyArguments.getMethod((Frame)frame).getProc() == this.proc);
                    proc = this.proc;
                }
                RubyArguments.setDeclarationFrame((Frame)frame, proc.declarationFrame);
                return this.lambdaBody.execute(frame);
            }

            @Override
            public RubyNode cloneUninitialized() {
                CallMethodWithLambdaBody copy = new CallMethodWithLambdaBody(this.proc, this.lambdaCallTarget, this.lambdaBody.cloneUninitialized());
                return copy.copyFlags(this);
            }
        }
    }

    public static abstract class ConstSetUncheckedNode
    extends RubyBaseNode {
        @Node.Child
        private WarnAlreadyInitializedNode warnAlreadyInitializedNode;

        public abstract Object execute(RubyModule var1, String var2, Object var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object setConstantNoCheckName(RubyModule module, String name, Object value) {
            RubyConstant previous = module.fields.setConstant(this.getContext(), this, name, value);
            if (previous != null && previous.hasValue()) {
                this.warnAlreadyInitializedConstant(module, name, previous.getSourceSection());
            }
            return value;
        }

        private void warnAlreadyInitializedConstant(RubyModule module, String name, SourceSection previousSourceSection) {
            if (this.warnAlreadyInitializedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.warnAlreadyInitializedNode = (WarnAlreadyInitializedNode)this.insert(new WarnAlreadyInitializedNode());
            }
            if (this.warnAlreadyInitializedNode.shouldWarn()) {
                SourceSection sourceSection = this.getContext().getCallStack().getTopMostUserSourceSection();
                this.warnAlreadyInitializedNode.warnAlreadyInitialized(module, name, sourceSection, previousSourceSection);
            }
        }
    }

    @CoreMethod(names={"const_set"}, required=2)
    public static abstract class ConstSetNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object setConstant(RubyModule module, Object nameObject, Object value, @Cached ConstSetUncheckedNode uncheckedSetNode, @Cached NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            if (!Identifiers.isValidConstantName(name)) {
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameError(StringUtils.format("wrong constant name %s", name), module, name, this));
            }
            return uncheckedSetNode.execute(module, name, value);
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class ConstSourceLocationNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyModule var2, Object var3, boolean var4);

        @Specialization(guards={"strings.isRubyString(this, name)"}, limit="1")
        @CompilerDirectives.TruffleBoundary
        static Object constSourceLocation(Node node, RubyModule module, Object name, boolean inherit, @Cached(inline=false) @Cached.Shared TruffleString.FromJavaStringNode fromJavaStringNode, @Cached RubyStringLibrary strings) {
            ConstantLookupResult lookupResult = ModuleOperations.lookupScopedConstant(ConstSourceLocationNode.getContext(node), module, RubyGuards.getJavaString(name), inherit, node, true);
            return ConstSourceLocationNode.getLocation(node, lookupResult, fromJavaStringNode);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object constSourceLocation(Node node, RubyModule module, RubySymbol name, boolean inherit, @Cached(inline=false) @Cached.Shared TruffleString.FromJavaStringNode fromJavaStringNode) {
            ConstantLookupResult lookupResult = ModuleOperations.lookupConstantWithInherit(ConstSourceLocationNode.getContext(node), module, name.getString(), inherit, node, true);
            return ConstSourceLocationNode.getLocation(node, lookupResult, fromJavaStringNode);
        }

        private static Object getLocation(Node node, ConstantLookupResult lookupResult, TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (!lookupResult.isFound()) {
                return nil;
            }
            SourceSection sourceSection = lookupResult.getConstant().getSourceSection();
            if (!BacktraceFormatter.isAvailable(sourceSection)) {
                return ConstSourceLocationNode.createEmptyArray(node);
            }
            return ConstSourceLocationNode.getLanguage(node).rubySourceLocation(ConstSourceLocationNode.getContext(node), sourceSection, fromJavaStringNode, node);
        }
    }

    @CoreMethod(names={"const_source_location"}, required=1, optional=1)
    public static abstract class ModuleConstSourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object constSourceLocation(RubyModule module, Object nameObject, Object maybeInherit, @Cached ConstSourceLocationNode constSourceLocationNode, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached ToStringOrSymbolNode toStringOrSymbolNode) {
            boolean inherit = booleanCastWithDefaultNode.execute(this, maybeInherit, true);
            Object name = toStringOrSymbolNode.execute(this, nameObject);
            return constSourceLocationNode.execute(this, module, name, inherit);
        }
    }

    @CoreMethod(names={"const_missing"}, required=1)
    public static abstract class ConstMissingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object constMissing(RubyModule module, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorUninitializedConstant(module, name, this));
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @ReportPolymorphism
    public static abstract class ConstGetNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyModule var2, Object var3, boolean var4, boolean var5, boolean var6);

        @Specialization(guards={"inherit"})
        static Object getConstant(Node node, RubyModule module, RubySymbol name, boolean inherit, boolean lookInObject, boolean checkName, @Cached @Cached.Shared GetConstantNode getConstantNode, @Cached(value="create(true, false)") @Cached.Shared LookupConstantNode lookupConstantNode, @Cached(value="create(true, true)") @Cached.Shared LookupConstantNode lookupConstantLookInObjectNode) {
            return ConstGetNode.getConstant(module, name.getString(), checkName, lookInObject, getConstantNode, lookupConstantNode, lookupConstantLookInObjectNode);
        }

        @Specialization(guards={"!inherit"})
        static Object getConstantNoInherit(RubyModule module, RubySymbol name, boolean inherit, boolean lookInObject, boolean checkName, @Cached @Cached.Shared GetConstantNode getConstantNode) {
            return ConstGetNode.getConstantNoInherit(module, name.getString(), checkName, getConstantNode);
        }

        @Specialization(guards={"stringsName.isRubyString(node, name)", "inherit", "equalNode.execute(stringsName, name, cachedTString, cachedEncoding)", "!scoped", "checkName == cachedCheckName"}, limit="getLimit()")
        static Object getConstantStringCached(Node node, RubyModule module, Object name, boolean inherit, boolean lookInObject, boolean checkName, @Cached @Cached.Shared RubyStringLibrary stringsName, @Cached @Cached.Shared GetConstantNode getConstantNode, @Cached(value="create(true, false)") @Cached.Shared LookupConstantNode lookupConstantNode, @Cached(value="create(true, true)") @Cached.Shared LookupConstantNode lookupConstantLookInObjectNode, @Cached(value="asTruffleStringUncached(name)") TruffleString cachedTString, @Cached(value="stringsName.getEncoding(node, name)") RubyEncoding cachedEncoding, @Cached(value="getJavaString(name)") String cachedString, @Cached(value="checkName") boolean cachedCheckName, @Cached StringHelperNodes.EqualNode equalNode, @Cached(value="isScoped(cachedString)") boolean scoped) {
            return ConstGetNode.getConstant(module, cachedString, checkName, lookInObject, getConstantNode, lookupConstantNode, lookupConstantLookInObjectNode);
        }

        @Specialization(guards={"stringsName.isRubyString(node, name)", "inherit", "!isScoped(node, stringsName, name, byteIndexOfStringNode)"}, replaces={"getConstantStringCached"})
        static Object getConstantString(Node node, RubyModule module, Object name, boolean inherit, boolean lookInObject, boolean checkName, @Cached @Cached.Shared GetConstantNode getConstantNode, @Cached @Cached.Shared TruffleString.ByteIndexOfStringNode byteIndexOfStringNode, @Cached(value="create(true, false)") @Cached.Shared LookupConstantNode lookupConstantNode, @Cached(value="create(true, true)") @Cached.Shared LookupConstantNode lookupConstantLookInObjectNode, @Cached @Cached.Shared RubyStringLibrary stringsName, @Cached @Cached.Shared ToJavaStringNode toJavaStringNode) {
            return ConstGetNode.getConstant(module, toJavaStringNode.execute(node, name), checkName, lookInObject, getConstantNode, lookupConstantNode, lookupConstantLookInObjectNode);
        }

        @Specialization(guards={"stringsName.isRubyString(node, name)", "!inherit", "!isScoped(node, stringsName, name, byteIndexOfStringNode)"})
        static Object getConstantNoInheritString(Node node, RubyModule module, Object name, boolean inherit, boolean lookInObject, boolean checkName, @Cached @Cached.Shared RubyStringLibrary stringsName, @Cached @Cached.Shared TruffleString.ByteIndexOfStringNode byteIndexOfStringNode, @Cached @Cached.Shared GetConstantNode getConstantNode, @Cached @Cached.Shared ToJavaStringNode toJavaStringNode) {
            return ConstGetNode.getConstantNoInherit(module, toJavaStringNode.execute(node, name), checkName, getConstantNode);
        }

        @Specialization(guards={"stringsName.isRubyString(node, name)", "isScoped(node, stringsName, name, byteIndexOfStringNode)"})
        static Object getConstantScoped(Node node, RubyModule module, Object name, boolean inherit, boolean lookInObject, boolean checkName, @Cached @Cached.Shared TruffleString.ByteIndexOfStringNode byteIndexOfStringNode, @Cached @Cached.Shared RubyStringLibrary stringsName) {
            return PrimitiveNode.FAILURE;
        }

        private static Object getConstant(RubyModule module, String name, boolean checkName, boolean lookInObject, GetConstantNode getConstantNode, LookupConstantNode lookupConstantNode, LookupConstantNode lookupConstantLookInObjectNode) {
            CompilerAsserts.partialEvaluationConstant((boolean)lookInObject);
            if (lookInObject) {
                return getConstantNode.lookupAndResolveConstant(LexicalScope.IGNORE, module, name, checkName, lookupConstantLookInObjectNode, true);
            }
            return getConstantNode.lookupAndResolveConstant(LexicalScope.IGNORE, module, name, checkName, lookupConstantNode, true);
        }

        private static Object getConstantNoInherit(RubyModule module, String name, boolean checkName, GetConstantNode getConstantNode) {
            LookupConstantInterface lookup = ConstGetNode::lookupConstantNoInherit;
            return getConstantNode.lookupAndResolveConstant(LexicalScope.IGNORE, module, name, checkName, lookup, true);
        }

        @CompilerDirectives.TruffleBoundary
        private static RubyConstant lookupConstantNoInherit(Node node, LexicalScope lexicalScope, RubyModule module, String name, boolean checkName) {
            return ModuleOperations.lookupConstantWithInherit(ConstGetNode.getContext(node), module, name, false, node, checkName).getConstant();
        }

        static boolean isScoped(Node node, RubyStringLibrary libString, Object string, TruffleString.ByteIndexOfStringNode byteIndexOfStringNode) {
            TruffleString.Encoding encoding;
            int byteLength;
            AbstractTruffleString tstring = libString.getTString(node, string);
            return byteIndexOfStringNode.execute(tstring, (AbstractTruffleString)TStringConstants.COLON_COLON, 0, byteLength = tstring.byteLength(encoding = libString.getTEncoding(node, string)), encoding) >= 0;
        }

        @CompilerDirectives.TruffleBoundary
        static boolean isScoped(String name) {
            return name.contains("::");
        }

        protected int getLimit() {
            return this.getLanguage().options.CONSTANT_CACHE;
        }
    }

    @Primitive(name="module_const_get")
    public static abstract class ConstGetNodePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getConst(RubyModule module, Object nameObject, boolean inherit, boolean lookInObject, boolean checkName, @Cached ConstGetNode constGetNode, @Cached ToStringOrSymbolNode toStringOrSymbolNode) {
            Object name = toStringOrSymbolNode.execute(this, nameObject);
            return constGetNode.execute(this, module, name, inherit, lookInObject, checkName);
        }
    }

    @Primitive(name="module_const_defined?")
    public static abstract class ConstDefinedNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean isConstDefined(RubyModule module, Object fullNameObject, Object inheritObject, boolean checkName, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached NameToJavaStringNode nameToJavaStringNode) {
            String fullName = nameToJavaStringNode.execute(this, fullNameObject);
            boolean inherit = booleanCastWithDefaultNode.execute(this, inheritObject, true);
            ConstantLookupResult constant = ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this, checkName);
            return constant.isFound();
        }
    }

    @CoreMethod(names={"constants"}, optional=1)
    public static abstract class ConstantsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray constants(RubyModule module, Object maybeInherit, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode) {
            boolean inherit = booleanCastWithDefaultNode.execute(this, maybeInherit, true);
            ArrayList<RubySymbol> constantsArray = new ArrayList<RubySymbol>();
            Iterable<Map.Entry<String, ConstantEntry>> constants = inherit ? ModuleOperations.getAllConstants(module) : module.fields.getConstants();
            for (Map.Entry<String, ConstantEntry> entry : constants) {
                RubyConstant constant = entry.getValue().getConstant();
                if (constant == null || constant.isPrivate() || !Identifiers.isValidConstantName(constant.getName())) continue;
                constantsArray.add(this.getSymbol(entry.getKey()));
            }
            return this.createArray(constantsArray.toArray());
        }
    }

    @CoreMethod(names={"class_variables"}, optional=1)
    public static abstract class ClassVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray getClassVariables(RubyModule module, Object maybeInherit, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode) {
            boolean inherit = booleanCastWithDefaultNode.execute(this, maybeInherit, true);
            LinkedHashSet variables = new LinkedHashSet();
            ModuleOperations.classVariableLookup(module, inherit, m -> {
                ClassVariableStorage classVariableStorage = m.fields.getClassVariables();
                for (Object key : classVariableStorage.getShape().getKeys()) {
                    variables.add(this.getSymbol((String)key));
                }
                return null;
            });
            return this.createArray(variables.toArray());
        }
    }

    @CoreMethod(names={"class_variable_set"}, required=2, raiseIfFrozenSelf=true, split=Split.ALWAYS)
    public static abstract class ClassVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object setClassVariable(RubyModule module, Object nameObject, Object value, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached CheckClassVariableNameNode checkClassVariableNameNode, @Cached SetClassVariableNode setClassVariableNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            checkClassVariableNameNode.execute(this, module, name);
            setClassVariableNode.execute(module, name, value);
            return value;
        }
    }

    @CoreMethod(names={"class_variable_get"}, required=1, split=Split.ALWAYS)
    public static abstract class ClassVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getClassVariable(RubyModule module, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached CheckClassVariableNameNode checkClassVariableNameNode, @Cached LookupClassVariableNode lookupClassVariableNode, @Cached InlinedConditionProfile undefinedProfile) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            checkClassVariableNameNode.execute(this, module, name);
            Object value = lookupClassVariableNode.execute(module, name);
            if (undefinedProfile.profile((Node)this, value == null)) {
                throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorUninitializedClassVariable(module, name, this));
            }
            return value;
        }
    }

    @CoreMethod(names={"class_variable_defined?"}, required=1, split=Split.ALWAYS)
    public static abstract class ClassVariableDefinedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isClassVariableDefinedString(RubyModule module, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached CheckClassVariableNameNode checkClassVariableNameNode, @Cached LookupClassVariableNode lookupClassVariableNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            checkClassVariableNameNode.execute(this, module, name);
            return lookupClassVariableNode.execute(module, name) != null;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ClassExecBlockNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, ArgumentsDescriptor var2, RubyModule var3, Object[] var4, RubyProc var5);

        @Specialization
        static Object classExec(Node node, ArgumentsDescriptor descriptor, RubyModule self, Object[] args, RubyProc block, @Cached CallBlockNode callBlockNode) {
            DeclarationContext declarationContext = new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.FixedDefaultDefinee(self), block.declarationContext.getRefinements());
            return callBlockNode.executeCallBlock(node, declarationContext, block, self, nil, descriptor, args);
        }
    }

    @CoreMethod(names={"class_exec", "module_exec"}, rest=true, needsBlock=true)
    public static abstract class ClassExecNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object withBlock(VirtualFrame frame, RubyModule self, Object[] args, RubyProc block, @Cached ClassExecBlockNode classExecBlockNode) {
            return classExecBlockNode.execute(this, RubyArguments.getDescriptor((Frame)frame), self, args, block);
        }

        @Specialization
        Object noBlock(RubyModule self, Object[] args, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().noBlockGiven(this));
        }
    }

    @CoreMethod(names={"class_eval", "module_eval"}, optional=3, needsBlock=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class ClassEvalNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"isBlockProvided(rubyArgs)"})
        Object evalWithBlock(Frame callerFrame, RubyModule self, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Exclusive InlinedBranchProfile wrongNumberOfArgumentsProfile, @Cached ClassExecBlockNode classExecNode) {
            int count = RubyArguments.getPositionalArgumentsCount(rubyArgs);
            if (count > 0) {
                wrongNumberOfArgumentsProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(count, 0, this));
            }
            Object block = RubyArguments.getBlock(rubyArgs);
            return classExecNode.execute(this, NoKeywordArgumentsDescriptor.INSTANCE, self, new Object[]{self}, (RubyProc)block);
        }

        @Specialization(guards={"!isBlockProvided(rubyArgs)"})
        static Object evalWithString(Frame callerFrame, RubyModule self, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Exclusive InlinedBranchProfile wrongNumberOfArgumentsProfile, @Cached ToJavaStringNode toJavaStringNode, @Cached ToStrNode toStrNode, @Cached ToIntNode toIntNode, @Cached IndirectCallNode callNode, @Bind(value="this") Node node) {
            String fileName = ClassEvalNode.coreStrings((Node)node).EVAL_FILENAME_STRING.toString();
            int line = 1;
            int count = RubyArguments.getPositionalArgumentsCount(rubyArgs);
            if (count == 0) {
                wrongNumberOfArgumentsProfile.enter(node);
                throw new RaiseException(ClassEvalNode.getContext(node), ClassEvalNode.coreExceptions(node).argumentError(0, 1, 2, node));
            }
            Object sourceCode = toStrNode.execute(node, RubyArguments.getArgument(rubyArgs, 0));
            if (count >= 2) {
                fileName = toJavaStringNode.execute(node, toStrNode.execute(node, RubyArguments.getArgument(rubyArgs, 1)));
            }
            if (count >= 3) {
                line = toIntNode.execute(RubyArguments.getArgument(rubyArgs, 2));
            }
            ClassEvalNode.needCallerFrame(node, callerFrame, target);
            return ClassEvalNode.classEvalSource(node, callerFrame.materialize(), self, sourceCode, fileName, line, callNode);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object classEvalSource(Node node, MaterializedFrame callerFrame, RubyModule module, Object sourceCode, String file, int line, IndirectCallNode callNode) {
            RubySource source = EvalLoader.createEvalSource(ClassEvalNode.getContext(node), RubyStringLibrary.getUncached().getTString(node, sourceCode), RubyStringLibrary.getUncached().getEncoding(node, sourceCode), "class/module_eval", file, line, node);
            LexicalScope lexicalScope = new LexicalScope(RubyArguments.getMethod((Frame)callerFrame).getLexicalScope(), module);
            RootCallTarget callTarget = ClassEvalNode.getContext(node).getCodeLoader().parse(source, ParserContext.MODULE, callerFrame, lexicalScope, node);
            CodeLoader.DeferredCall deferredCall = ClassEvalNode.getContext(node).getCodeLoader().prepareExecute(callTarget, ParserContext.MODULE, new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.FixedDefaultDefinee(module), DeclarationContext.NO_REFINEMENTS), callerFrame, module, lexicalScope);
            return deferredCall.call(callNode);
        }
    }

    @CoreMethod(names={"autoload?"}, required=1, optional=1)
    public static abstract class IsAutoloadNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object isAutoload(RubyModule module, Object nameObject, Object maybeInherit, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode, @Cached NameToJavaStringNode nameToJavaStringNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            boolean inherit = booleanCastWithDefaultNode.execute(this, maybeInherit, true);
            ConstantLookupResult constant = ModuleOperations.lookupConstantWithInherit(this.getContext(), module, name, inherit, this, false, false);
            if (constant.isAutoload() && !constant.getConstant().getAutoloadConstant().isAutoloadingThread()) {
                return constant.getConstant().getAutoloadConstant().getFeature();
            }
            return nil;
        }
    }

    @Primitive(name="module_anonymous?")
    public static abstract class IsAnonymousNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isAnonymous(RubyModule module) {
            return module.fields.isAnonymousOrTemporary();
        }
    }

    @CoreMethod(names={"autoload"}, required=2)
    public static abstract class AutoloadNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"libFilename.isRubyString(this, filenameAsPath)"}, limit="1")
        static Object autoload(RubyModule module, Object nameObject, Object filename, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached ToPathNode toPathNode, @Bind(value="this") Node node, @Bind(value="toPathNode.execute(node, filename)") Object filenameAsPath, @Cached RubyStringLibrary libFilename) {
            String name = nameToJavaStringNode.execute(node, nameObject);
            if (!Identifiers.isValidConstantName(name)) {
                throw new RaiseException(AutoloadNode.getContext(node), (RubyException)AutoloadNode.coreExceptions(node).nameError(StringUtils.format("autoload must be constant name: %s", name), module, name, node));
            }
            if (libFilename.getTString(node, filenameAsPath).isEmpty()) {
                throw new RaiseException(AutoloadNode.getContext(node), AutoloadNode.coreExceptions(node).argumentError("empty file name", node));
            }
            String javaStringFilename = RubyGuards.getJavaString(filenameAsPath);
            module.fields.setAutoloadConstant(AutoloadNode.getContext(node), node, name, filenameAsPath, javaStringFilename);
            return nil;
        }
    }

    @CoreMethod(names={"attr_writer"}, rest=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class AttrWriterNode
    extends GenerateAccessorNode {
        @Specialization
        Object attrWriter(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target) {
            Object[] names = RubyArguments.getPositionalArguments(rubyArgs);
            return this.createArray(this.generateAccessors(callerFrame, module, names, GenerateAccessorNode.Accessor.WRITER, target));
        }
    }

    @CoreMethod(names={"attr_reader"}, rest=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class AttrReaderNode
    extends GenerateAccessorNode {
        @Specialization
        Object attrReader(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target) {
            Object[] names = RubyArguments.getPositionalArguments(rubyArgs);
            return this.createArray(this.generateAccessors(callerFrame, module, names, GenerateAccessorNode.Accessor.READER, target));
        }
    }

    @CoreMethod(names={"attr_accessor"}, rest=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class AttrAccessorNode
    extends GenerateAccessorNode {
        @Specialization
        Object attrAccessor(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target) {
            Object[] names = RubyArguments.getPositionalArguments(rubyArgs);
            return this.createArray(this.generateAccessors(callerFrame, module, names, GenerateAccessorNode.Accessor.BOTH, target));
        }
    }

    @CoreMethod(names={"attr"}, rest=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class AttrNode
    extends GenerateAccessorNode {
        @Specialization
        Object attr(Frame callerFrame, RubyModule module, Object[] rubyArgs, RootCallTarget target) {
            boolean setter;
            Object[] names = RubyArguments.getPositionalArguments(rubyArgs);
            if (names.length == 2 && names[1] instanceof Boolean) {
                this.warnObsoletedBooleanArgument();
                setter = (Boolean)names[1];
                names = new Object[]{names[0]};
            } else {
                setter = false;
            }
            return this.createArray(this.generateAccessors(callerFrame, module, names, setter ? GenerateAccessorNode.Accessor.BOTH : GenerateAccessorNode.Accessor.READER, target));
        }

        @CompilerDirectives.TruffleBoundary
        private void warnObsoletedBooleanArgument() {
            WarningNode.UncachedWarningNode warningNode = WarningNode.UncachedWarningNode.INSTANCE;
            if (warningNode.shouldWarn()) {
                SourceSection sourceSection = this.getContext().getCallStack().getTopMostUserSourceSection();
                warningNode.warningMessage(sourceSection, "optional boolean argument is obsoleted");
            }
        }
    }

    public static abstract class GenerateAccessorNode
    extends AlwaysInlinedMethodNode {
        protected Object[] generateAccessors(Frame callerFrame, RubyModule module, Object[] names, Accessor accessor, RootCallTarget target) {
            this.needCallerFrame(callerFrame, target);
            Visibility visibility = DeclarationContext.findVisibilityCheckSelfAndDefaultDefinee(module, callerFrame);
            return this.createAccessors(module, names, accessor, visibility);
        }

        @CompilerDirectives.TruffleBoundary
        private Object[] createAccessors(RubyModule module, Object[] names, Accessor accessor, Visibility visibility) {
            Node currentNode = GenerateAccessorNode.getAdoptedNode(this);
            SourceSection sourceSection = currentNode != null ? currentNode.getEncapsulatingSourceSection() : CoreLibrary.UNAVAILABLE_SOURCE_SECTION;
            Object[] generatedMethods = accessor == Accessor.BOTH ? new Object[names.length * 2] : new Object[names.length];
            int i = 0;
            for (Object nameObject : names) {
                String name = NameToJavaStringNode.executeUncached(nameObject);
                if (accessor == Accessor.BOTH) {
                    generatedMethods[i++] = this.createAccessor(module, name, Accessor.READER, visibility, sourceSection);
                    generatedMethods[i++] = this.createAccessor(module, name, Accessor.WRITER, visibility, sourceSection);
                    continue;
                }
                generatedMethods[i++] = this.createAccessor(module, name, accessor, visibility, sourceSection);
            }
            return generatedMethods;
        }

        @CompilerDirectives.TruffleBoundary
        private RubySymbol createAccessor(RubyModule module, String name, Accessor accessor, Visibility visibility, SourceSection sourceSection) {
            assert (accessor != Accessor.BOTH);
            Arity arity = accessor == Accessor.READER ? Arity.NO_ARGUMENTS : Arity.ONE_REQUIRED;
            String ivar = "@" + name;
            Object accessorName = accessor == Accessor.READER ? name : name + "=";
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, LexicalScope.IGNORE, arity, (String)accessorName, 0, SharedMethodInfo.moduleAndMethodName(module, (String)accessorName), ivar, null);
            Object alwaysInlinedNodeFactory = accessor == Accessor.READER ? ModuleNodesFactory.GeneratedReaderNodeFactory.getInstance() : ModuleNodesFactory.GeneratedWriterNodeFactory.getInstance();
            RubyRootNode reRaiseRootNode = new RubyRootNode(this.getLanguage(), sourceSection, null, sharedMethodInfo, new ReRaiseInlinedExceptionNode((NodeFactory<? extends RubyBaseNode>)alwaysInlinedNodeFactory), Split.NEVER, ReturnID.INVALID);
            RootCallTarget callTarget = reRaiseRootNode.getCallTarget();
            InternalMethod method = new InternalMethod(this.getContext(), sharedMethodInfo, LexicalScope.IGNORE, DeclarationContext.NONE, (String)accessorName, module, visibility, false, (NodeFactory<? extends RubyBaseNode>)alwaysInlinedNodeFactory, null, callTarget, null);
            module.fields.addMethod(this.getContext(), this, method);
            return this.getLanguage().getSymbol(method.getName());
        }

        static enum Accessor {
            READER,
            WRITER,
            BOTH;

        }
    }

    @GenerateUncached
    public static abstract class GeneratedWriterNode
    extends AlwaysInlinedMethodNode {
        @Specialization(guards={"!isFrozenNode.execute(self)"})
        Object writer(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Shared IsFrozenNode isFrozenNode, @Cached WriteObjectFieldNode writeObjectFieldNode) {
            String ivarName = RubyRootNode.of(target).getSharedMethodInfo().getNotes();
            CompilerAsserts.partialEvaluationConstant((Object)ivarName);
            Object value = RubyArguments.getArgument(rubyArgs, 0);
            writeObjectFieldNode.execute(this, (RubyDynamicObject)((Object)self), ivarName, value);
            return value;
        }

        @Specialization(guards={"isFrozenNode.execute(self)"})
        Object frozen(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target, @Cached @Cached.Shared IsFrozenNode isFrozenNode) {
            throw new RaiseException(this.getContext(), this.coreExceptions().frozenError(self, this));
        }
    }

    @GenerateUncached
    public static abstract class GeneratedReaderNode
    extends AlwaysInlinedMethodNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        Object reader(Frame callerFrame, RubyDynamicObject self, Object[] rubyArgs, RootCallTarget target, @CachedLibrary(value="self") DynamicObjectLibrary objectLibrary) {
            String ivarName = RubyRootNode.of(target).getSharedMethodInfo().getNotes();
            CompilerAsserts.partialEvaluationConstant((Object)ivarName);
            return objectLibrary.getOrDefault((DynamicObject)self, (Object)ivarName, (Object)nil);
        }

        @Specialization(guards={"!isRubyDynamicObject(self)"})
        Object notObject(Frame callerFrame, Object self, Object[] rubyArgs, RootCallTarget target) {
            return nil;
        }
    }

    @CoreMethod(names={"append_features"}, required=1, visibility=Visibility.PRIVATE, split=Split.NEVER)
    public static abstract class AppendFeaturesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object appendFeatures(RubyModule features, RubyModule target, @Cached InlinedBranchProfile errorProfile) {
            if (features instanceof RubyClass) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError("append_features must be called only on modules", this));
            }
            target.fields.include(this.getContext(), this, features);
            return nil;
        }
    }

    @CoreMethod(names={"ancestors"})
    public static abstract class AncestorsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray ancestors(RubyModule self) {
            ArrayList<RubyModule> ancestors = new ArrayList<RubyModule>();
            for (RubyModule module : self.fields.ancestors()) {
                ancestors.add(module);
            }
            return this.createArray(ancestors.toArray());
        }
    }

    public static final class AliasKeywordNode
    extends RubyContextSourceNode {
        @Node.Child
        private RubyNode newName;
        @Node.Child
        private RubyNode oldName;

        public AliasKeywordNode(RubyNode newName, RubyNode oldName) {
            this.newName = newName;
            this.oldName = oldName;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            RubyModule module = RubyArguments.getDeclarationContext((Frame)frame).getModuleToDefineMethods();
            Object newNameObject = this.newName.execute(frame);
            Object oldNameObject = this.oldName.execute(frame);
            RubySymbol newNameSymbol = (RubySymbol)newNameObject;
            RubySymbol oldNameSymbol = (RubySymbol)oldNameObject;
            return AliasMethodNode.aliasMethod(module, newNameSymbol, oldNameSymbol, this);
        }

        @Override
        public RubyNode cloneUninitialized() {
            return new AliasKeywordNode(this.newName, this.oldName).copyFlags(this);
        }
    }

    @CoreMethod(names={"alias_method"}, required=2, raiseIfFrozenSelf=true, split=Split.NEVER)
    public static abstract class AliasMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySymbol aliasMethod(RubyModule module, Object newNameObject, Object oldNameObject, @Cached ToSymbolNode toSymbolNode) {
            RubySymbol newName = toSymbolNode.execute(this, newNameObject);
            RubySymbol oldName = toSymbolNode.execute(this, oldNameObject);
            return AliasMethodNode.aliasMethod(module, newName, oldName, this);
        }

        @CompilerDirectives.TruffleBoundary
        static RubySymbol aliasMethod(RubyModule module, RubySymbol newName, RubySymbol oldName, RubyNode node) {
            RubyContext context = RubyContext.get(node);
            module.fields.checkFrozen(context, node);
            InternalMethod method = module.fields.deepMethodSearch(context, oldName.getString());
            if (method == null) {
                throw new RaiseException(context, (RubyException)context.getCoreExceptions().nameErrorUndefinedMethod(oldName.getString(), module, node));
            }
            InternalMethod aliasMethod = method.withName(newName.getString());
            module.addMethodConsiderNameVisibility(context, aliasMethod, aliasMethod.getVisibility(), node);
            return newName;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsSubclassOfOrEqualToNode subclassNode;

        private Object isSubclass(RubyModule self, RubyModule other) {
            if (this.subclassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.subclassNode = (IsSubclassOfOrEqualToNode)this.insert(ModuleNodesFactory.IsSubclassOfOrEqualToNodeFactory.create(null));
            }
            return this.subclassNode.executeIsSubclassOfOrEqualTo(self, other);
        }

        @Specialization
        Object compare(RubyModule self, RubyModule other) {
            if (self == other) {
                return 0;
            }
            Object isSubclass = this.isSubclass(self, other);
            if (isSubclass == nil) {
                return nil;
            }
            return (Boolean)isSubclass != false ? -1 : 1;
        }

        @Specialization(guards={"!isRubyModule(other)"})
        Object compareOther(RubyModule self, Object other) {
            return nil;
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class IsSuperclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSuperclassOfOrEqualTo(VirtualFrame var1, RubyModule var2, Object var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object isSuperclassOfOrEqualTo(RubyModule self, RubyModule other) {
            if (self == other || ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return nil;
        }

        @Specialization(guards={"!isRubyModule(other)"})
        Object isSuperclassOfOrEqualToOther(RubyModule self, Object other) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class IsSuperclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSuperclassOf(VirtualFrame var1, RubyModule var2, Object var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object isSuperclassOf(RubyModule self, RubyModule other) {
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return nil;
        }

        @Specialization(guards={"!isRubyModule(other)"})
        Object isSuperclassOfOther(RubyModule self, Object other) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class IsSubclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSubclassOfOrEqualTo(RubyModule var1, Object var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object isSubclassOfOrEqualTo(RubyModule self, RubyModule other) {
            if (self == other || ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return nil;
        }

        @Specialization(guards={"!isRubyModule(other)"})
        Object isSubclassOfOrEqualToOther(RubyModule self, Object other) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class IsSubclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeIsSubclassOf(VirtualFrame var1, RubyModule var2, Object var3);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object isSubclassOf(RubyModule self, RubyModule other) {
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return nil;
        }

        @Specialization(guards={"!isRubyModule(other)"})
        Object isSubclassOfOther(RubyModule self, Object other) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class ContainsInstanceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode = IsANode.create();

        @Specialization
        boolean containsInstance(RubyModule module, Object instance) {
            return this.isANode.executeIsA(instance, module);
        }
    }
}

