/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.mutex;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.cast.DurationToNanoSecondsNode;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.core.mutex.RubyMutex;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Mutex", isClass=true)
public abstract class MutexNodes {

    @CoreMethod(names={"sleep"}, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        long sleep(RubyMutex mutex, Object maybeDuration, @Cached DurationToNanoSecondsNode durationToNanoSecondsNode, @Cached InlinedConditionProfile nilProfile, @Cached InlinedBranchProfile errorProfile) {
            if (nilProfile.profile((Node)this, maybeDuration == nil)) {
                maybeDuration = NotProvided.INSTANCE;
            }
            long durationInNanos = durationToNanoSecondsNode.execute(this, maybeDuration);
            ReentrantLock lock = mutex.lock;
            RubyThread thread = this.getLanguage().getCurrentThread();
            MutexOperations.checkOwnedMutex(this.getContext(), lock, this, errorProfile);
            thread.wakeUp.set(false);
            MutexOperations.unlock(lock, thread);
            try {
                long l = KernelNodes.SleepNode.sleepFor(this.getContext(), thread, durationInNanos, this);
                return l;
            }
            finally {
                MutexOperations.lockEvenWithExceptions(this.getContext(), lock, thread, this);
            }
        }
    }

    @CoreMethod(names={"synchronize"}, needsBlock=true)
    public static abstract class SynchronizeNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object synchronize(RubyMutex mutex, RubyProc block, @Cached InlinedBranchProfile errorProfile, @Cached CallBlockNode yieldNode) {
            ReentrantLock lock = mutex.lock;
            RubyThread thread = this.getLanguage().getCurrentThread();
            if (lock.isHeldByCurrentThread()) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().threadErrorRecursiveLocking(this));
            }
            MutexOperations.lock(this.getContext(), lock, thread, this);
            try {
                Object object = yieldNode.yield(this, block, new Object[0]);
                return object;
            }
            finally {
                MutexOperations.checkOwnedMutex(this.getContext(), lock, this, errorProfile);
                MutexOperations.unlock(lock, thread);
            }
        }
    }

    @CoreMethod(names={"unlock"})
    public static abstract class UnlockNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyMutex unlock(RubyMutex mutex, @Cached InlinedBranchProfile errorProfile) {
            ReentrantLock lock = mutex.lock;
            RubyThread thread = this.getLanguage().getCurrentThread();
            MutexOperations.checkOwnedMutex(this.getContext(), lock, this, errorProfile);
            MutexOperations.unlock(lock, thread);
            return mutex;
        }
    }

    @CoreMethod(names={"try_lock"})
    public static abstract class TryLockNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean tryLock(RubyMutex mutex, @Cached InlinedConditionProfile heldByCurrentThreadProfile) {
            ReentrantLock lock = mutex.lock;
            RubyThread thread = this.getLanguage().getCurrentThread();
            if (heldByCurrentThreadProfile.profile((Node)this, lock.isHeldByCurrentThread())) {
                return false;
            }
            return MutexOperations.tryLock(lock, thread);
        }
    }

    @CoreMethod(names={"owned?"})
    public static abstract class IsOwnedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isOwned(RubyMutex mutex) {
            return mutex.lock.isHeldByCurrentThread();
        }
    }

    @CoreMethod(names={"locked?"})
    public static abstract class IsLockedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isLocked(RubyMutex mutex) {
            return mutex.lock.isLocked();
        }
    }

    @CoreMethod(names={"lock"})
    public static abstract class LockNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyMutex lock(RubyMutex mutex, @Cached InlinedBranchProfile errorProfile) {
            ReentrantLock lock = mutex.lock;
            if (lock.isHeldByCurrentThread()) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().threadErrorRecursiveLocking(this));
            }
            RubyThread thread = this.getLanguage().getCurrentThread();
            MutexOperations.lock(this.getContext(), lock, thread, this);
            return mutex;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyMutex allocate(RubyClass rubyClass) {
            ReentrantLock lock = MutexOperations.newReentrantLock();
            RubyMutex instance = new RubyMutex(rubyClass, this.getLanguage().mutexShape, lock);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

