/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.numeric.BignumOperations;
import org.truffleruby.core.numeric.RubyBignum;

public final class BigIntegerOps {
    @CompilerDirectives.TruffleBoundary
    public static BigInteger create(byte[] value) {
        return new BigInteger(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger valueOf(long value) {
        return BigInteger.valueOf(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger negate(BigInteger value) {
        return value.negate();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger negate(long value) {
        return BigIntegerOps.valueOf(value).negate();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger add(BigInteger a, BigInteger b) {
        return a.add(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger add(long a, long b) {
        return BigIntegerOps.valueOf(a).add(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger add(BigInteger a, long b) {
        return a.add(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger subtract(BigInteger a, BigInteger b) {
        return a.subtract(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger subtract(long a, long b) {
        return BigIntegerOps.valueOf(a).subtract(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger subtract(BigInteger a, long b) {
        return a.subtract(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger subtract(long a, BigInteger b) {
        return BigIntegerOps.valueOf(a).subtract(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger multiply(BigInteger a, BigInteger b) {
        return a.multiply(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger multiply(long a, long b) {
        return BigIntegerOps.valueOf(a).multiply(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger multiply(BigInteger a, long b) {
        return a.multiply(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger not(BigInteger value) {
        return value.not();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger and(BigInteger a, BigInteger b) {
        return a.and(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger and(BigInteger a, long b) {
        return a.and(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger or(BigInteger a, BigInteger b) {
        return a.or(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger or(BigInteger a, long b) {
        return a.or(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger xor(BigInteger a, BigInteger b) {
        return a.xor(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger xor(BigInteger a, long b) {
        return a.xor(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger shiftLeft(BigInteger value, int n) {
        return value.shiftLeft(n);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger shiftLeft(long value, int n) {
        return BigIntegerOps.valueOf(value).shiftLeft(n);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger shiftRight(BigInteger value, int n) {
        return value.shiftRight(n);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger shiftRight(long value, int n) {
        return BigIntegerOps.valueOf(value).shiftRight(n);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger pow(BigInteger value, int exponent) {
        return value.pow(exponent);
    }

    @CompilerDirectives.TruffleBoundary
    public static double pow(BigInteger value, double exponent) {
        return Math.pow(value.doubleValue(), exponent);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger modPow(BigInteger base, BigInteger exponent, BigInteger m) {
        return base.modPow(exponent, m);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger abs(BigInteger value) {
        return value.abs();
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger abs(long value) {
        return BigIntegerOps.valueOf(value).abs();
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(BigInteger a, BigInteger b) {
        return a.compareTo(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(BigInteger a, long b) {
        return a.compareTo(BigIntegerOps.valueOf(b));
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(long a, BigInteger b) {
        return BigIntegerOps.valueOf(a).compareTo(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(BigInteger a, double b) {
        if (Double.isInfinite(b)) {
            return b < 0.0 ? 1 : -1;
        }
        int cmp = a.compareTo(BigIntegerOps.fromDouble(b));
        double fractional = b % 1.0;
        return cmp != 0 || fractional == 0.0 ? cmp : (fractional < 0.0 ? -1 : 1);
    }

    @CompilerDirectives.TruffleBoundary
    @SuppressFBWarnings(value={"RV"})
    public static int compare(double a, BigInteger b) {
        return -BigIntegerOps.compare(b, a);
    }

    public static int compare(long a, RubyBignum b) {
        return BigIntegerOps.compare(a, b.value);
    }

    public static int compare(RubyBignum a, long b) {
        return BigIntegerOps.compare(a.value, b);
    }

    public static int compare(RubyBignum a, RubyBignum b) {
        return BigIntegerOps.compare(a.value, b.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean less(RubyBignum a, double b) {
        return !Double.isNaN(b) && BigIntegerOps.compare(a.value, b) < 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean lessEqual(RubyBignum a, double b) {
        return !Double.isNaN(b) && BigIntegerOps.compare(a.value, b) <= 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equal(RubyBignum a, double b) {
        return !Double.isNaN(b) && BigIntegerOps.compare(a.value, b) == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean greaterEqual(RubyBignum a, double b) {
        return !Double.isNaN(b) && BigIntegerOps.compare(a.value, b) >= 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean greater(RubyBignum a, double b) {
        return !Double.isNaN(b) && BigIntegerOps.compare(a.value, b) > 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean less(double a, RubyBignum b) {
        return !Double.isNaN(a) && BigIntegerOps.compare(a, b.value) < 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean lessEqual(double a, RubyBignum b) {
        return !Double.isNaN(a) && BigIntegerOps.compare(a, b.value) <= 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equal(double a, RubyBignum b) {
        return !Double.isNaN(a) && BigIntegerOps.compare(a, b.value) == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean greaterEqual(double a, RubyBignum b) {
        return !Double.isNaN(a) && BigIntegerOps.compare(a, b.value) >= 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean greater(double a, RubyBignum b) {
        return !Double.isNaN(a) && BigIntegerOps.compare(a, b.value) > 0;
    }

    public static boolean isPositive(RubyBignum value) {
        return value.value.signum() > 0;
    }

    public static boolean isNegative(RubyBignum value) {
        return value.value.signum() < 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static int bitLength(BigInteger value) {
        return value.bitLength();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean testBit(BigInteger value, int n) {
        return value.testBit(n);
    }

    @CompilerDirectives.TruffleBoundary
    public static double doubleValue(BigInteger value) {
        return value.doubleValue();
    }

    public static double doubleValue(RubyBignum value) {
        return BigIntegerOps.doubleValue(value.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static long longValue(BigInteger value) {
        return value.longValue();
    }

    public static long longValue(RubyBignum value) {
        return BigIntegerOps.longValue(value.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger fromDouble(double value) {
        return new BigDecimal(value).toBigInteger();
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] toByteArray(BigInteger value) {
        return value.toByteArray();
    }

    public static Object asUnsignedFixnumOrBignum(long value) {
        return value >= 0L ? Long.valueOf(value) : BignumOperations.createBignum(BigIntegerOps.negativeValueAsUnsignedBigInteger(value));
    }

    public static Object asUnsignedPrimitiveOrBigInteger(long value) {
        return value >= 0L ? Long.valueOf(value) : BigIntegerOps.negativeValueAsUnsignedBigInteger(value);
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger negativeValueAsUnsignedBigInteger(long value) {
        assert (value < 0L);
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(BigInteger a, BigInteger b) {
        return a.equals(b);
    }

    @CompilerDirectives.TruffleBoundary
    public static int hashCode(BigInteger value) {
        return value.hashCode();
    }

    public static int hashCode(RubyBignum value) {
        return BigIntegerOps.hashCode(value.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(BigInteger value) {
        return value.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(BigInteger value, int base) {
        return value.toString(base);
    }
}

