/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.math.BigInteger;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.FixnumOrBignumNodeGen;
import org.truffleruby.language.RubyBaseNode;

@GenerateCached(value=false)
@GenerateInline
@GenerateUncached
public abstract class FixnumOrBignumNode
extends RubyBaseNode {
    private static final BigInteger LONG_MIN_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);

    public static Object executeUncached(BigInteger value) {
        return FixnumOrBignumNodeGen.getUncached().execute(null, value);
    }

    public abstract Object execute(Node var1, BigInteger var2);

    @Specialization
    static Object fixnumOrBignum(Node node, BigInteger value, @Cached InlinedConditionProfile lowerProfile, @Cached InlinedConditionProfile intProfile) {
        if (lowerProfile.profile(node, FixnumOrBignumNode.fitsIntoLong(value))) {
            long longValue = BigIntegerOps.longValue(value);
            if (intProfile.profile(node, CoreLibrary.fitsIntoInteger(longValue))) {
                return (int)longValue;
            }
            return longValue;
        }
        return FixnumOrBignumNode.createBignum(value);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean fitsIntoLong(BigInteger value) {
        return value.compareTo(LONG_MIN_BIGINT) >= 0 && value.compareTo(LONG_MAX_BIGINT) <= 0;
    }
}

