/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.BigIntegerCastNode;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.FloatToIntegerNode;
import org.truffleruby.core.cast.ToRubyIntegerNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.core.numeric.FloatNodes;
import org.truffleruby.core.numeric.GeneralDivModNode;
import org.truffleruby.core.numeric.IntegerNodesFactory;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.NoImplicitCastsToLong;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.WarnNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Integer", isClass=true)
public abstract class IntegerNodes {

    @CoreMethod(names={"upto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class UpToNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode uptoInternalCall;
        private final LoopConditionProfile loopProfile = LoopConditionProfile.create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object upto(int from, int to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode) {
            int i = from;
            try {
                while (this.loopProfile.inject(i <= to)) {
                    yieldNode.yield(this, block, i);
                    ++i;
                }
            }
            finally {
                this.profileAndReportLoopCount(this.loopProfile, i - from + 1);
            }
            return nil;
        }

        @Specialization
        Object upto(int from, double to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode) {
            return this.upto(from, (int)Math.floor(to), block, yieldNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object upto(long from, long to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode) {
            long i;
            try {
                for (i = from; i <= to; ++i) {
                    yieldNode.yield(this, block, i);
                }
            }
            finally {
                this.profileAndReportLoopCount(this.loopProfile, i - from + 1L);
            }
            return nil;
        }

        @Specialization
        Object upto(long from, double to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode) {
            return this.upto(from, (long)Math.floor(to), block, yieldNode);
        }

        @Specialization(guards={"isRubyBignum(from) || !isImplicitLongOrDouble(to)"})
        Object upto(Object from, Object to, RubyProc block) {
            if (this.uptoInternalCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.uptoInternalCall = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.uptoInternalCall.callWithBlock(from, "upto_internal", block, to);
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int toI(int n) {
            return n;
        }

        @Specialization
        long toI(long n) {
            return n;
        }

        @Specialization
        RubyBignum toI(RubyBignum n) {
            return n;
        }
    }

    @CoreMethod(names={"downto"}, needsBlock=true, required=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class DownToNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode downtoInternalCall;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object downto(int from, int to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode, @Cached @Cached.Shared InlinedLoopConditionProfile loopProfile) {
            int i = from;
            try {
                while (loopProfile.inject((Node)this, i >= to)) {
                    yieldNode.yield(this, block, i);
                    --i;
                }
            }
            finally {
                DownToNode.profileAndReportLoopCount((Node)this, loopProfile, from - i + 1);
            }
            return nil;
        }

        @Specialization
        Object downto(int from, double to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode, @Cached @Cached.Shared InlinedLoopConditionProfile loopProfile) {
            return this.downto(from, (int)Math.ceil(to), block, yieldNode, loopProfile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object downto(long from, long to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode, @Cached @Cached.Shared InlinedLoopConditionProfile loopProfile) {
            long i;
            try {
                for (i = from; i >= to; --i) {
                    yieldNode.yield(this, block, i);
                }
            }
            finally {
                DownToNode.profileAndReportLoopCount((Node)this, loopProfile, from - i + 1L);
            }
            return nil;
        }

        @Specialization
        Object downto(long from, double to, RubyProc block, @Cached @Cached.Shared CallBlockNode yieldNode, @Cached @Cached.Shared InlinedLoopConditionProfile loopProfile) {
            return this.downto(from, (long)Math.ceil(to), block, yieldNode, loopProfile);
        }

        @Specialization(guards={"isRubyBignum(from) || !isImplicitLongOrDouble(to)"})
        Object downto(Object from, Object to, RubyProc block) {
            if (this.downtoInternalCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.downtoInternalCall = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.downtoInternalCall.callWithBlock(from, "downto_internal", block, to);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ModPowNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, BigInteger var2, BigInteger var3, BigInteger var4);

        @Specialization(guards={"modulo.signum() < 0"})
        static Object mod_pow_neg(Node node, BigInteger base, BigInteger exponent, BigInteger modulo, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignum) {
            BigInteger result = BigIntegerOps.modPow(base, exponent, BigIntegerOps.negate(modulo));
            return fixnumOrBignum.execute(node, result.signum() == 1 ? BigIntegerOps.add(result, modulo) : result);
        }

        @Specialization(guards={"modulo.signum() > 0"})
        static Object mod_pow_pos(Node node, BigInteger base, BigInteger exponent, BigInteger modulo, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignum) {
            BigInteger result = BigIntegerOps.modPow(base, exponent, modulo);
            return fixnumOrBignum.execute(node, result);
        }

        @Specialization(guards={"modulo.signum() == 0"})
        static Object mod_pow_zero(Node node, BigInteger base, BigInteger exponent, BigInteger modulo) {
            throw new RaiseException(ModPowNode.getContext(node), ModPowNode.coreExceptions(node).zeroDivisionError(node));
        }
    }

    @Primitive(name="mod_pow")
    public static abstract class ModPowNodePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object doModPow(Object baseObject, Object exponentObject, Object moduloObject, @Cached BigIntegerCastNode baseCastNode, @Cached BigIntegerCastNode exponentCastNode, @Cached BigIntegerCastNode moduloCastNode, @Cached ModPowNode modPowNode) {
            BigInteger base = baseCastNode.execute(this, baseObject);
            BigInteger exponent = exponentCastNode.execute(this, exponentObject);
            BigInteger modulo = moduloCastNode.execute(this, moduloObject);
            return modPowNode.execute(this, base, exponent, modulo);
        }
    }

    @Primitive(name="integer_pow", lowerFixnum={0, 1})
    @ReportPolymorphism
    public static abstract class PowNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private PowNode recursivePowNode;
        private static final int BIGLEN_LIMIT = 0x2000000;

        public abstract Object executePow(Object var1, Object var2);

        protected Object recursivePow(Object a, Object b) {
            if (this.recursivePowNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.recursivePowNode = (PowNode)this.insert(IntegerNodesFactory.PowNodeFactory.create(null));
            }
            return this.recursivePowNode.executePow(a, b);
        }

        @Specialization(guards={"base == 2", "exponent >= 0", "exponent <= 30"})
        int powTwoInt(int base, int exponent) {
            return 1 << exponent;
        }

        @Specialization(guards={"base == 2", "exponent >= 0", "exponent <= 62"}, replaces={"powTwoInt"})
        long powTwoLong(int base, int exponent) {
            return 1L << exponent;
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
        @Specialization(guards={"isImplicitLong(base)", "exponent == cachedExponent", "cachedExponent >= 0", "cachedExponent <= 10"}, limit="getLimit()")
        Object powConstantExponent(Object base, int exponent, @Cached(value="exponent") int cachedExponent, @Cached @Cached.Shared InlinedBranchProfile overflowProfile, @Cached @Cached.Exclusive MulNode mulNode) {
            Object result = 1;
            int exp = cachedExponent;
            while (exp > 0) {
                if ((exp & 1) == 0) {
                    base = mulNode.executeMul(base, base);
                    exp >>= 1;
                    if (!(base instanceof RubyBignum)) continue;
                    overflowProfile.enter((Node)this);
                    Object bignumResult = this.recursivePow(base, exp);
                    return mulNode.executeMul(result, bignumResult);
                }
                result = mulNode.executeMul(base, result);
                --exp;
            }
            return result;
        }

        @Specialization(guards={"isImplicitLong(base)", "exponent >= 0"})
        Object powLoop(Object base, long exponent, @Cached @Cached.Shared InlinedBranchProfile overflowProfile, @Cached @Cached.Exclusive MulNode mulNode) {
            Object result = 1;
            long exp = exponent;
            while (exp > 0L) {
                if ((exp & 1L) == 0L) {
                    base = mulNode.executeMul(base, base);
                    exp >>= 1;
                    if (!(base instanceof RubyBignum)) continue;
                    overflowProfile.enter((Node)this);
                    Object bignumResult = this.recursivePow(base, exp);
                    return mulNode.executeMul(result, bignumResult);
                }
                result = mulNode.executeMul(base, result);
                --exp;
            }
            return result;
        }

        @Specialization(guards={"exponent < 0"})
        Object pow(long base, long exponent) {
            return FAILURE;
        }

        @Specialization
        Object powDouble(long base, double exponent, @Cached @Cached.Exclusive InlinedConditionProfile complexProfile) {
            if (complexProfile.profile((Node)this, base < 0L)) {
                return FAILURE;
            }
            return Math.pow(base, exponent);
        }

        @Specialization
        Object powBignum(long base, RubyBignum exponent, @Cached @Cached.Shared WarnNode warnNode) {
            if (base == 0L) {
                return 0;
            }
            if (base == 1L) {
                return 1;
            }
            if (base == -1L) {
                if (BigIntegerOps.testBit(exponent.value, 0)) {
                    return -1;
                }
                return 1;
            }
            if (BigIntegerOps.compare(exponent.value, BigInteger.ZERO) < 0) {
                return FAILURE;
            }
            if (warnNode.shouldWarn()) {
                warnNode.warningMessage(this.getContext().getCallStack().getTopMostUserSourceSection(), "in a**b, b may be too big");
            }
            return Double.POSITIVE_INFINITY;
        }

        @Specialization
        Object pow(RubyBignum base, long exponent, @Cached @Cached.Exclusive InlinedConditionProfile negativeProfile, @Cached @Cached.Exclusive InlinedConditionProfile maybeTooBigProfile, @Cached @Cached.Shared WarnNode warnNode) {
            if (negativeProfile.profile((Node)this, exponent < 0L)) {
                return FAILURE;
            }
            BigInteger bigIntegerBase = base.value;
            int baseBitLength = BigIntegerOps.bitLength(bigIntegerBase);
            if (maybeTooBigProfile.profile((Node)this, baseBitLength > 0x2000000 || (long)baseBitLength * exponent > 0x2000000L)) {
                if (warnNode.shouldWarn()) {
                    warnNode.warningMessage(this.getContext().getCallStack().getTopMostUserSourceSection(), "in a**b, b may be too big");
                }
                return BigIntegerOps.pow(bigIntegerBase, exponent);
            }
            return PowNode.createBignum(BigIntegerOps.pow(bigIntegerBase, (int)exponent));
        }

        @Specialization
        Object pow(RubyBignum base, double exponent) {
            double doublePow = BigIntegerOps.pow(base.value, exponent);
            if (Double.isNaN(doublePow)) {
                return FAILURE;
            }
            return doublePow;
        }

        @Specialization
        Object pow(RubyBignum base, RubyBignum exponent) {
            return FAILURE;
        }

        @Specialization(guards={"!isRubyNumber(exponent)"})
        Object pow(Object base, Object exponent) {
            return FAILURE;
        }

        protected int getLimit() {
            return this.getLanguage().options.POW_CACHE;
        }
    }

    @Primitive(name="integer_ulong_from_bignum")
    public static abstract class IntegerULongFromBigNumNode
    extends PrimitiveArrayArgumentsNode {
        private static final BigInteger TWO_POW_64 = BigInteger.valueOf(1L).shiftLeft(64);
        private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        long uLongFromBignum(RubyBignum b, @Cached InlinedConditionProfile doesNotNeedsConversion) {
            BigInteger value = b.value;
            assert (value.signum() >= 0);
            if (doesNotNeedsConversion.profile((Node)this, value.compareTo(LONG_MAX) < 1)) {
                return value.longValue();
            }
            return value.subtract(TWO_POW_64).longValue();
        }
    }

    @Primitive(name="integer_lower")
    public static abstract class IntegerLowerNode
    extends PrimitiveArrayArgumentsNode {
        public static IntegerLowerNode create() {
            return IntegerNodesFactory.IntegerLowerNodeFactory.create(null);
        }

        public abstract Object executeLower(Object var1);

        @Specialization
        int lower(int value) {
            return value;
        }

        @Specialization(guards={"fitsInInteger(value)"})
        int lower(long value) {
            return (int)value;
        }

        @Specialization(guards={"!fitsInInteger(value)"})
        long lowerFails(long value) {
            return value;
        }
    }

    @Primitive(name="integer_fits_into_ulong?")
    public static abstract class IntegerFitsIntoULongNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean fitsIntoULongInt(int a) {
            return true;
        }

        @Specialization
        boolean fitsIntoULongLong(long a) {
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean fitsIntoULongBignum(RubyBignum a) {
            BigInteger bigInt = a.value;
            if (bigInt.signum() >= 0) {
                return bigInt.bitLength() <= 64;
            }
            return false;
        }
    }

    @Primitive(name="integer_fits_into_long?")
    public static abstract class IntegerFitsIntoLongNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean fitsIntoLongInt(int a) {
            return true;
        }

        @Specialization
        boolean fitsIntoLongLong(long a) {
            return true;
        }

        @Specialization
        boolean fitsIntoLongBignum(RubyBignum a) {
            return false;
        }
    }

    @Primitive(name="integer_fits_into_uint?")
    public static abstract class IntegerFitsIntoUIntNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean fitsIntoUIntInt(int a) {
            return true;
        }

        @Specialization
        boolean fitsIntoUIntLong(long a) {
            return CoreLibrary.fitsIntoUnsignedInteger(a);
        }

        @Specialization
        boolean fitsIntoUIntBignum(RubyBignum a) {
            return false;
        }
    }

    @Primitive(name="integer_fits_into_int?")
    public static abstract class FixnumFitsIntoIntNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean fitsIntoIntInt(int a) {
            return true;
        }

        @Specialization
        boolean fitsIntoIntLong(long a) {
            return CoreLibrary.fitsIntoInteger(a);
        }

        @Specialization
        boolean fitsIntoIntBignum(RubyBignum a) {
            return false;
        }
    }

    @Primitive(name="ruby_integer?")
    public static abstract class IsRubyIntegerNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean doInt(int a) {
            return true;
        }

        @Specialization
        boolean doLong(long a) {
            return true;
        }

        @Specialization
        boolean doBignum(RubyBignum a) {
            return true;
        }

        @Fallback
        boolean other(Object a) {
            return false;
        }
    }

    @CoreMethod(names={"to_s", "inspect"}, optional=1, lowerFixnum={1})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString defaultBase10(long n, NotProvided base, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode) {
            TruffleString tstring = fromLongNode.execute(n, Encodings.US_ASCII.tencoding, true);
            return this.createString(tstring, Encodings.US_ASCII);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString toS(RubyBignum value, NotProvided base, @Cached @Cached.Shared TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, BigIntegerOps.toString(value.value), Encodings.US_ASCII);
        }

        @Specialization(guards={"base == 10"})
        RubyString base10(long n, int base, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode) {
            return this.defaultBase10(n, NotProvided.INSTANCE, fromLongNode);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"base != 10"})
        RubyString toS(long n, int base, @Cached @Cached.Shared TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (base < 2 || base > 36) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorInvalidRadix(base, this));
            }
            return this.createString(fromJavaStringNode, Long.toString(n, base), Encodings.US_ASCII);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString toS(RubyBignum value, int base, @Cached @Cached.Shared TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (base < 2 || base > 36) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorInvalidRadix(base, this));
            }
            return this.createString(fromJavaStringNode, BigIntegerOps.toString(value.value, base), Encodings.US_ASCII);
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double toF(int n) {
            return n;
        }

        @Specialization
        double toF(long n) {
            return n;
        }

        @Specialization
        double toF(RubyBignum value) {
            return BigIntegerOps.doubleValue(value.value);
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int size(long value) {
            return 8;
        }

        @Specialization
        int size(RubyBignum value) {
            return (BigIntegerOps.bitLength(value.value) + 7) / 8;
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int bitLength(int n) {
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            }
            return 32 - Integer.numberOfLeadingZeros(n);
        }

        @Specialization
        int bitLength(long n) {
            if (n < 0L) {
                n ^= 0xFFFFFFFFFFFFFFFFL;
            }
            return 64 - Long.numberOfLeadingZeros(n);
        }

        @Specialization
        int bitLength(RubyBignum value) {
            return BigIntegerOps.bitLength(value.value);
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeAbs(Object var1);

        @Specialization(rewriteOn={ArithmeticException.class})
        int absIntInBounds(int n) {
            return n < 0 ? Math.negateExact(n) : n;
        }

        @Specialization(replaces={"absIntInBounds"})
        Object abs(int n) {
            if (n == Integer.MIN_VALUE) {
                return -((long)n);
            }
            return n < 0 ? -n : n;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        long absInBounds(long n) {
            return n < 0L ? Math.subtractExact(0L, n) : n;
        }

        @Specialization(replaces={"absInBounds"})
        Object abs(long n) {
            if (n == Long.MIN_VALUE) {
                return AbsNode.createBignum(BigIntegerOps.abs(n));
            }
            return n < 0L ? -n : n;
        }

        @Specialization
        Object abs(RubyBignum value, @Cached FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.abs(value.value));
        }
    }

    @CoreMethod(names={">>"}, required=1, lowerFixnum={1})
    public static abstract class RightShiftNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private NegNode negNode;
        @Node.Child
        private LeftShiftNode leftShiftNode;
        static final long MAX_INT = Integer.MAX_VALUE;

        public static RightShiftNode create() {
            return IntegerNodesFactory.RightShiftNodeFactory.create(null);
        }

        public abstract Object executeRightShift(Object var1, Object var2);

        @Specialization(guards={"b >= 0"})
        int rightShift(int a, int b, @Cached @Cached.Exclusive InlinedConditionProfile profile) {
            if (profile.profile((Node)this, b >= 31)) {
                return a < 0 ? -1 : 0;
            }
            return a >> b;
        }

        @Specialization(guards={"b >= 0"})
        Object rightShift(long a, int b, @Cached @Cached.Exclusive InlinedConditionProfile profile) {
            if (profile.profile((Node)this, b >= 63)) {
                return a < 0L ? -1 : 0;
            }
            return a >> b;
        }

        @Specialization(guards={"b >= 0"})
        Object rightShift(RubyBignum a, int b, @Cached FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.shiftRight(a.value, b));
        }

        @Specialization(guards={"b > MAX_INT"})
        int rightShift(long a, long b) {
            return a < 0L ? -1 : 0;
        }

        @Specialization(guards={"b > MAX_INT"})
        int rightShift(RubyBignum a, long b) {
            return a.value.signum() < 0 ? -1 : 0;
        }

        @Specialization(guards={"isPositive(b)"})
        int rightShift(long a, RubyBignum b) {
            return a < 0L ? -1 : 0;
        }

        @Specialization(guards={"isPositive(b)"})
        int rightShift(RubyBignum a, RubyBignum b) {
            return a.value.signum() < 0 ? -1 : 0;
        }

        @Specialization(guards={"b < 0"})
        Object rightShiftNeg(Object a, int b) {
            return this.negateAndLeftShift(a, b);
        }

        @Specialization(guards={"b < 0"})
        Object rightShiftNeg(Object a, long b) {
            return this.negateAndLeftShift(a, b);
        }

        @Specialization(guards={"!isPositive(b)"})
        Object rightShiftNeg(Object a, RubyBignum b) {
            return this.negateAndLeftShift(a, b);
        }

        @Specialization(guards={"!isRubyInteger(b)"})
        static Object rightShiftCoerced(Object a, Object b, @Cached ToRubyIntegerNode toRubyIntNode, @Cached RightShiftNode rightShiftNode, @Bind(value="this") Node node) {
            return rightShiftNode.executeRightShift(a, toRubyIntNode.execute(node, b));
        }

        private Object negateAndLeftShift(Object a, Object b) {
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.leftShiftNode = (LeftShiftNode)this.insert(IntegerNodesFactory.LeftShiftNodeFactory.create(null));
            }
            if (this.negNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.negNode = (NegNode)this.insert(IntegerNodesFactory.NegNodeFactory.create(null));
            }
            Object negated = this.negNode.executeNeg(b);
            return this.leftShiftNode.executeLeftShift(a, negated);
        }

        static boolean isPositive(RubyBignum b) {
            return b.value.signum() >= 0;
        }
    }

    @CoreMethod(names={"<<"}, required=1, lowerFixnum={1})
    public static abstract class LeftShiftNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private NegNode negNode;
        @Node.Child
        private RightShiftNode rightShiftNode;
        static final long MAX_INT = Integer.MAX_VALUE;

        public static LeftShiftNode create() {
            return IntegerNodesFactory.LeftShiftNodeFactory.create(null);
        }

        public abstract Object executeLeftShift(Object var1, Object var2);

        @Specialization(guards={"b >= 0", "canShiftIntoInt(a, b)"})
        int leftShift(int a, int b) {
            return a << b;
        }

        @Specialization(guards={"b >= 0", "canShiftLongIntoInt(a, b)"})
        int leftShift(long a, int b) {
            return (int)(a << b);
        }

        @Specialization(guards={"b >= 0", "canShiftIntoLong(a, b)"})
        long leftShiftToLong(long a, int b) {
            return a << b;
        }

        @Specialization(guards={"b >= 0"})
        Object leftShiftWithOverflow(long a, int b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            if (LeftShiftNode.canShiftIntoLong(a, b)) {
                return this.leftShiftToLong(a, b);
            }
            return fixnumOrBignumNode.execute(this, BigIntegerOps.shiftLeft(a, b));
        }

        @Specialization(guards={"b >= 0"})
        Object leftShift(RubyBignum a, int b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.shiftLeft(a.value, b));
        }

        @Specialization(guards={"b > MAX_INT"})
        int leftShift(long a, long b, @Cached @Cached.Shared InlinedConditionProfile zeroProfile) {
            if (zeroProfile.profile((Node)this, a == 0L)) {
                return 0;
            }
            throw this.shiftWidthTooBig();
        }

        @Specialization(guards={"b > MAX_INT"})
        int leftShift(RubyBignum a, long b) {
            throw this.shiftWidthTooBig();
        }

        @Specialization(guards={"isPositive(b)"})
        int leftShift(long a, RubyBignum b, @Cached @Cached.Shared InlinedConditionProfile zeroProfile) {
            if (zeroProfile.profile((Node)this, a == 0L)) {
                return 0;
            }
            throw this.shiftWidthTooBig();
        }

        @Specialization(guards={"isPositive(b)"})
        int leftShift(RubyBignum a, RubyBignum b) {
            throw this.shiftWidthTooBig();
        }

        private RaiseException shiftWidthTooBig() {
            return new RaiseException(this.getContext(), this.coreExceptions().rangeError("shift width too big", (Node)this));
        }

        @Specialization(guards={"b < 0"})
        Object leftShiftNeg(Object a, int b) {
            return this.negateAndRightShift(a, b);
        }

        @Specialization(guards={"b < 0"})
        Object leftShiftNeg(Object a, long b) {
            return this.negateAndRightShift(a, b);
        }

        @Specialization(guards={"!isPositive(b)"})
        Object leftShiftNeg(Object a, RubyBignum b) {
            return this.negateAndRightShift(a, b);
        }

        @Specialization(guards={"!isRubyInteger(b)"})
        static Object leftShiftCoerced(Object a, Object b, @Cached ToRubyIntegerNode toRubyIntNode, @Cached LeftShiftNode leftShiftNode, @Bind(value="this") Node node) {
            return leftShiftNode.executeLeftShift(a, toRubyIntNode.execute(node, b));
        }

        private Object negateAndRightShift(Object a, Object b) {
            if (this.rightShiftNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.rightShiftNode = (RightShiftNode)this.insert(IntegerNodesFactory.RightShiftNodeFactory.create(null));
            }
            if (this.negNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.negNode = (NegNode)this.insert(IntegerNodesFactory.NegNodeFactory.create(null));
            }
            Object negated = this.negNode.executeNeg(b);
            return this.rightShiftNode.executeRightShift(a, negated);
        }

        static boolean canShiftIntoInt(int a, int b) {
            return Integer.numberOfLeadingZeros(a) - b > 0;
        }

        static boolean canShiftLongIntoInt(long a, int b) {
            return Long.numberOfLeadingZeros(a) - 32 - b > 0;
        }

        static boolean canShiftIntoLong(long a, int b) {
            return Long.numberOfLeadingZeros(a) - b > 0;
        }

        static boolean isPositive(RubyBignum b) {
            return b.value.signum() >= 0;
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int bitXOr(int a, int b) {
            return a ^ b;
        }

        @Specialization
        long bitXOr(long a, long b) {
            return a ^ b;
        }

        @Specialization
        Object bitXOr(long a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.xor(b.value, a));
        }

        @Specialization
        Object bitXOr(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.xor(a.value, b));
        }

        @Specialization
        Object bitXOr(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.xor(a.value, b.value));
        }

        @Specialization(guards={"!isRubyInteger(b)"})
        Object bitXOrCoerced(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_bit_coerced", this.coreSymbols().CIRCUMFLEX, b);
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeBitOr(Object var1, Object var2);

        @Specialization
        int bitOr(int a, int b) {
            return a | b;
        }

        @Specialization
        long bitOr(long a, long b) {
            return a | b;
        }

        @Specialization
        Object bitOr(long a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.or(b.value, a));
        }

        @Specialization
        Object bitOr(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.or(a.value, b));
        }

        @Specialization
        Object bitOr(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.or(a.value, b.value));
        }

        @Specialization(guards={"!isRubyInteger(b)"})
        Object bitOrCoerced(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_bit_coerced", this.coreSymbols().PIPE, b);
        }
    }

    @CoreMethod(names={"&"}, required=1)
    @TypeSystemReference(value=NoImplicitCastsToLong.class)
    public static abstract class BitAndNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeBitAnd(Object var1, Object var2);

        @Specialization
        int bitAndIntInt(int a, int b) {
            return a & b;
        }

        @Specialization(guards={"a >= 0"})
        int bitAndIntLong(int a, long b) {
            return a & (int)b;
        }

        @Specialization(guards={"a < 0"})
        long bitAndIntLongNegative(int a, long b) {
            return (long)a & b;
        }

        @Specialization(guards={"b >= 0"})
        int bitAndLongInt(long a, int b) {
            return (int)a & b;
        }

        @Specialization(guards={"b < 0"})
        long bitAndLongIntNegative(long a, int b) {
            return a & (long)b;
        }

        @Specialization
        long bitAndLongLong(long a, long b) {
            return a & b;
        }

        @Specialization
        Object bitAndBignum(int a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.and(b.value, a));
        }

        @Specialization
        Object bitAndBignum(long a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.and(b.value, a));
        }

        @Specialization
        Object bitAnd(RubyBignum a, int b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.and(a.value, b));
        }

        @Specialization
        Object bitAnd(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.and(a.value, b));
        }

        @Specialization
        Object bitAnd(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.and(a.value, b.value));
        }

        @Specialization(guards={"!isRubyInteger(b)"})
        Object bitAndCoerced(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_bit_coerced", this.coreSymbols().AMPERSAND, b);
        }
    }

    @CoreMethod(names={"~"})
    public static abstract class ComplementNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int complement(int n) {
            return ~n;
        }

        @Specialization
        long complement(long n) {
            return n ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Specialization
        Object complement(RubyBignum value, @Cached FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.not(value.value));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean greater(int a, int b) {
            return a > b;
        }

        @Specialization
        boolean greater(long a, long b) {
            return a > b;
        }

        @Specialization
        boolean greater(long a, double b) {
            return (double)a > b;
        }

        @Specialization
        boolean greater(long a, RubyBignum b) {
            return BigIntegerOps.isNegative(b);
        }

        @Specialization
        boolean greater(RubyBignum a, long b) {
            return BigIntegerOps.isPositive(a);
        }

        @Specialization
        boolean greater(RubyBignum a, double b) {
            return BigIntegerOps.greater(a, b);
        }

        @Specialization
        boolean greater(RubyBignum a, RubyBignum b) {
            return BigIntegerOps.compare(a, b) > 0;
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object greaterCoerced(Object a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().GREATER_THAN, b);
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean greaterEqual(int a, int b) {
            return a >= b;
        }

        @Specialization
        boolean greaterEqual(long a, long b) {
            return a >= b;
        }

        @Specialization
        boolean greaterEqual(long a, double b) {
            return (double)a >= b;
        }

        @Specialization
        boolean greaterEqual(long a, RubyBignum b) {
            return BigIntegerOps.isNegative(b);
        }

        @Specialization
        boolean greaterEqual(RubyBignum a, long b) {
            return BigIntegerOps.isPositive(a);
        }

        @Specialization
        boolean greaterEqual(RubyBignum a, double b) {
            return BigIntegerOps.greaterEqual(a, b);
        }

        @Specialization
        boolean greaterEqual(RubyBignum a, RubyBignum b) {
            return BigIntegerOps.compare(a, b) >= 0;
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object greaterEqualCoerced(Object a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().GEQ, b);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int compare(int a, int b, @Cached @Cached.Shared InlinedConditionProfile smallerProfile, @Cached @Cached.Shared InlinedConditionProfile equalProfile) {
            if (smallerProfile.profile((Node)this, a < b)) {
                return -1;
            }
            if (equalProfile.profile((Node)this, a == b)) {
                return 0;
            }
            return 1;
        }

        @Specialization
        int compare(long a, long b, @Cached @Cached.Shared InlinedConditionProfile smallerProfile, @Cached @Cached.Shared InlinedConditionProfile equalProfile) {
            if (smallerProfile.profile((Node)this, a < b)) {
                return -1;
            }
            if (equalProfile.profile((Node)this, a == b)) {
                return 0;
            }
            return 1;
        }

        @Specialization(guards={"isNaN(b)"})
        Object compareNaN(long a, double b) {
            return nil;
        }

        @Specialization(guards={"!isNaN(b)"})
        int compare(long a, double b, @Cached @Cached.Exclusive InlinedConditionProfile equalProfile) {
            return FloatNodes.CompareNode.compareDoubles(a, b, equalProfile, this);
        }

        @Specialization
        int compare(long a, RubyBignum b) {
            return BigIntegerOps.compare(a, b);
        }

        @Specialization
        int compare(RubyBignum a, long b) {
            return BigIntegerOps.compare(a, b);
        }

        @Specialization(guards={"isNaN(b)"})
        Object compareNaN(RubyBignum a, double b) {
            return nil;
        }

        @Specialization(guards={"!isNaN(b)"})
        int compare(RubyBignum a, double b) {
            return BigIntegerOps.compare(a.value, b);
        }

        @Specialization
        int compare(RubyBignum a, RubyBignum b) {
            return BigIntegerOps.compare(a, b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object compare(Object a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare_no_error", b);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class EqualInternalNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization
        boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization
        boolean equal(int a, RubyBignum b) {
            return false;
        }

        @Specialization
        boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        boolean equal(long a, double b) {
            return (double)a == b;
        }

        @Specialization
        boolean equal(long a, RubyBignum b) {
            return false;
        }

        @Specialization
        boolean equal(RubyBignum a, long b) {
            return false;
        }

        @Specialization
        boolean equal(RubyBignum a, double b) {
            return BigIntegerOps.equal(a, b);
        }

        @Specialization
        boolean equal(RubyBignum a, RubyBignum b) {
            return BigIntegerOps.equals(a.value, b.value);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        static Object equal(Node node, Object a, Object b, @Cached(inline=false) DispatchNode reverseCallNode, @Cached BooleanCastNode booleanCastNode) {
            Object reversedResult = reverseCallNode.call(b, "==", a);
            return booleanCastNode.execute(node, reversedResult);
        }
    }

    @CoreMethod(names={"==", "==="}, required=1, alwaysInlined=true)
    @GenerateUncached
    public static abstract class EqualNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        static Object equal(Object self, Object[] rubyArgs, RootCallTarget target, @Cached EqualInternalNode equalInternalNode, @Bind(value="this") Node node) {
            Object other = RubyArguments.getArgument(rubyArgs, 0);
            return equalInternalNode.execute(node, self, other);
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean lessEqual(int a, int b) {
            return a <= b;
        }

        @Specialization
        boolean lessEqual(long a, long b) {
            return a <= b;
        }

        @Specialization
        boolean lessEqual(long a, double b) {
            return (double)a <= b;
        }

        @Specialization
        boolean lessEqual(long a, RubyBignum b) {
            return BigIntegerOps.isPositive(b);
        }

        @Specialization
        boolean lessEqual(RubyBignum a, long b) {
            return BigIntegerOps.isNegative(a);
        }

        @Specialization
        boolean lessEqual(RubyBignum a, double b) {
            return BigIntegerOps.lessEqual(a, b);
        }

        @Specialization
        boolean lessEqual(RubyBignum a, RubyBignum b) {
            return BigIntegerOps.compare(a, b) <= 0;
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object lessEqualCoerced(Object a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().LEQ, b);
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean less(int a, int b) {
            return a < b;
        }

        @Specialization
        boolean less(long a, long b) {
            return a < b;
        }

        @Specialization
        boolean less(long a, double b) {
            return (double)a < b;
        }

        @Specialization
        boolean less(long a, RubyBignum b) {
            return BigIntegerOps.isPositive(b);
        }

        @Specialization
        boolean less(RubyBignum a, long b) {
            return BigIntegerOps.isNegative(a);
        }

        @Specialization
        boolean less(RubyBignum a, double b) {
            return BigIntegerOps.less(a, b);
        }

        @Specialization
        boolean less(RubyBignum a, RubyBignum b) {
            return BigIntegerOps.compare(a, b) < 0;
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object lessCoerced(Object a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().LESS_THAN, b);
        }
    }

    @Primitive(name="integer_divmod")
    public static abstract class DivModNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyArray divMod(long a, long b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a, b);
        }

        @Specialization
        RubyArray divMod(long a, RubyBignum b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a, b.value);
        }

        @Specialization
        RubyArray divMod(long a, double b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a, b);
        }

        @Specialization
        RubyArray divMod(RubyBignum a, long b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a.value, b);
        }

        @Specialization
        RubyArray divMod(RubyBignum a, double b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a.value, b);
        }

        @Specialization
        RubyArray divMod(RubyBignum a, RubyBignum b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a.value, b.value);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object divModOther(Object a, Object b) {
            return FAILURE;
        }
    }

    @CoreMethod(names={"%", "modulo"}, required=1, split=Split.ALWAYS)
    public static abstract class ModNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile adjustProfile = BranchProfile.create();

        public abstract Object executeMod(Object var1, Object var2);

        @Specialization(guards={"a >= 0", "b == cachedB", "isPowerOfTwo(cachedB)"}, limit="getDefaultCacheLimit()")
        int modPowerOfTwo(int a, int b, @Cached(value="b") int cachedB) {
            return a & cachedB - 1;
        }

        @Idempotent
        protected static boolean isPowerOfTwo(int n) {
            return n > 0 && (n & n - 1) == 0;
        }

        @Specialization(replaces={"modPowerOfTwo"})
        int mod(int a, int b, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (b == 0) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            int mod = a % b;
            if (mod < 0 && b > 0 || mod > 0 && b < 0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        double mod(long a, double b, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (b == 0.0) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            double mod = (double)a % b;
            if (mod < 0.0 && b > 0.0 || mod > 0.0 && b < 0.0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        long mod(long a, long b, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (b == 0L) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            long mod = a % b;
            if (mod < 0L && b > 0L || mod > 0L && b < 0L) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object mod(long a, RubyBignum b) {
            long mod = BigInteger.valueOf(a).mod(b.value).longValue();
            if (mod < 0L && b.value.compareTo(BigInteger.ZERO) > 0 || mod > 0L && b.value.compareTo(BigInteger.ZERO) < 0) {
                return ModNode.createBignum(BigInteger.valueOf(mod).add(b.value));
            }
            return mod;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object mod(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            if (b == 0L) {
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            if (b < 0L) {
                BigInteger bigint = BigInteger.valueOf(b);
                BigInteger mod = a.value.mod(bigint.negate());
                return fixnumOrBignumNode.execute(this, mod.add(bigint));
            }
            return fixnumOrBignumNode.execute(this, a.value.mod(BigInteger.valueOf(b)));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        double mod(RubyBignum a, double b) {
            if (b == 0.0) {
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            double mod = a.value.doubleValue() % b;
            if (mod < 0.0 && b > 0.0 || mod > 0.0 && b < 0.0) {
                mod += b;
            }
            return mod;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object mod(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            BigInteger bigint = b.value;
            int compare = bigint.compareTo(BigInteger.ZERO);
            if (compare == 0) {
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            if (compare < 0) {
                BigInteger mod = a.value.mod(bigint.negate());
                return fixnumOrBignumNode.execute(this, mod.add(bigint));
            }
            return fixnumOrBignumNode.execute(this, a.value.mod(b.value));
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object modCoerced(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().MODULO, b);
        }
    }

    @CoreMethod(names={"div"}, required=1)
    public static abstract class IDivNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DivNode divNode = IntegerNodesFactory.DivNodeFactory.create(null);

        @Specialization
        Object idiv(Object a, Object b, @Cached InlinedConditionProfile zeroProfile, @Cached FloatToIntegerNode floatToIntegerNode, @Cached DispatchNode floorNode) {
            Object quotient = this.divNode.executeDiv(a, b);
            if (quotient instanceof Double) {
                if (zeroProfile.profile((Node)this, (Double)b == 0.0)) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
                }
                return floatToIntegerNode.execute(this, Math.floor((Double)quotient));
            }
            if (RubyGuards.isRubyInteger(quotient)) {
                return quotient;
            }
            return floorNode.call(quotient, "floor");
        }
    }

    @CoreMethod(names={"/"}, required=1)
    public static abstract class DivNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile bGreaterZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroAGreaterEqualZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroALessZero = BranchProfile.create();
        private final BranchProfile aGreaterZero = BranchProfile.create();
        private final BranchProfile bMinusOne = BranchProfile.create();
        private final BranchProfile bMinusOneAMinimum = BranchProfile.create();
        private final BranchProfile bMinusOneANotMinimum = BranchProfile.create();
        private final BranchProfile finalCase = BranchProfile.create();

        public abstract Object executeDiv(Object var1, Object var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        Object divInt(int a, int b) {
            if (b > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b - 1;
            }
            if (b == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return 0x80000000L;
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        Object divIntFallback(int a, int b, @Cached @Cached.Shared InlinedConditionProfile zeroProfile) {
            if (zeroProfile.profile((Node)this, b == 0)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            return this.divInt(a, b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        Object divLong(long a, long b) {
            if (b > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b - 1L;
            }
            if (b == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return DivNode.createBignum(BigIntegerOps.negate(a));
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        Object divLongFallback(long a, long b, @Cached @Cached.Shared InlinedConditionProfile zeroProfile) {
            if (zeroProfile.profile((Node)this, b == 0L)) {
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            return this.divLong(a, b);
        }

        @Specialization
        double div(long a, double b) {
            return (double)a / b;
        }

        @Specialization
        Object divBignum(long a, RubyBignum b) {
            return a == 0L || Long.signum(a) == b.value.signum() ? 0 : -1;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object div(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            if (b == 0L) {
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            BigInteger aBigInt = a.value;
            BigInteger bBigInt = BigInteger.valueOf(b);
            BigInteger result = aBigInt.divide(bBigInt);
            if (result.signum() == -1 && !aBigInt.mod(bBigInt.abs()).equals(BigInteger.ZERO)) {
                return fixnumOrBignumNode.execute(this, result.subtract(BigInteger.ONE));
            }
            return fixnumOrBignumNode.execute(this, result);
        }

        @Specialization
        double div(RubyBignum a, double b) {
            return BigIntegerOps.doubleValue(a) / b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object div(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            BigInteger aBigInt = a.value;
            BigInteger bBigInt = b.value;
            BigInteger result = aBigInt.divide(bBigInt);
            if (result.signum() == -1 && !aBigInt.mod(bBigInt.abs()).equals(BigInteger.ZERO)) {
                return fixnumOrBignumNode.execute(this, result.subtract(BigInteger.ONE));
            }
            return fixnumOrBignumNode.execute(this, result);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object divCoerced(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().DIVIDE, b);
        }
    }

    @Primitive(name="integer_fdiv")
    public static abstract class FDivNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double fDivIntInt(int num, int den) {
            return (double)num / (double)den;
        }

        @Specialization
        double fDivLongLong(long num, long den) {
            return (double)num / (double)den;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        double fDivLongBig(long num, RubyBignum den) {
            return new BigDecimal(num).divide(new BigDecimal(den.value), 323, RoundingMode.HALF_UP).doubleValue();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        double fDivBigLong(RubyBignum num, long den) {
            return new BigDecimal(num.value).divide(new BigDecimal(den), 323, RoundingMode.HALF_UP).doubleValue();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        double fDivBigBig(RubyBignum num, RubyBignum den) {
            return new BigDecimal(num.value).divide(new BigDecimal(den.value), 323, RoundingMode.HALF_UP).doubleValue();
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        @NeverDefault
        public static MulNode create() {
            return IntegerNodesFactory.MulNodeFactory.create(null);
        }

        public abstract Object executeMul(Object var1, Object var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        int mul(int a, int b) {
            return Math.multiplyExact(a, b);
        }

        @Specialization
        long mulWithOverflow(int a, int b) {
            return (long)a * (long)b;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        long mul(long a, long b) {
            return Math.multiplyExact(a, b);
        }

        @Specialization
        Object mulWithOverflow(long a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.multiply(a, b));
        }

        @Specialization
        double mul(long a, double b) {
            return (double)a * b;
        }

        @Specialization
        Object mul(long a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.multiply(b.value, a));
        }

        @Specialization
        Object mul(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.multiply(a.value, b));
        }

        @Specialization
        double mul(RubyBignum a, double b) {
            return BigIntegerOps.doubleValue(a.value) * b;
        }

        @Specialization
        Object mul(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.multiply(a.value, b.value));
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object mul(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().MULTIPLY, b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(rewriteOn={ArithmeticException.class})
        int sub(int a, int b) {
            return Math.subtractExact(a, b);
        }

        @Specialization
        long subWithOverflow(int a, int b) {
            return (long)a - (long)b;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        long sub(long a, long b) {
            return Math.subtractExact(a, b);
        }

        @Specialization
        Object subWithOverflow(long a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.subtract(a, b));
        }

        @Specialization
        double sub(long a, double b) {
            return (double)a - b;
        }

        @Specialization
        Object sub(long a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.subtract(a, b.value));
        }

        @Specialization
        Object sub(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.subtract(a.value, b));
        }

        @Specialization
        double sub(RubyBignum a, double b) {
            return BigIntegerOps.doubleValue(a.value) - b;
        }

        @Specialization
        Object sub(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.subtract(a.value, b.value));
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object subCoerced(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().MINUS, b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(rewriteOn={ArithmeticException.class})
        int add(int a, int b) {
            return Math.addExact(a, b);
        }

        @Specialization
        long addWithOverflow(int a, int b) {
            return (long)a + (long)b;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        long add(long a, long b) {
            return Math.addExact(a, b);
        }

        @Specialization
        Object addWithOverflow(long a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.add(a, b));
        }

        @Specialization
        double add(long a, double b) {
            return (double)a + b;
        }

        @Specialization
        Object add(long a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.add(b.value, a));
        }

        @Specialization
        Object add(RubyBignum a, long b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.add(a.value, b));
        }

        @Specialization
        double add(RubyBignum a, double b) {
            return BigIntegerOps.doubleValue(a.value) + b;
        }

        @Specialization
        Object add(RubyBignum a, RubyBignum b, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.add(a.value, b.value));
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object addCoerced(Object a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().PLUS, b);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeNeg(Object var1);

        @Specialization(rewriteOn={ArithmeticException.class})
        int doInt(int value) {
            return Math.negateExact(value);
        }

        @Specialization(replaces={"doInt"})
        Object doIntWithOverflow(int value) {
            if (value == Integer.MIN_VALUE) {
                return -((long)value);
            }
            return -value;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        long doLong(long value) {
            return Math.subtractExact(0L, value);
        }

        @Specialization(replaces={"doLong"})
        Object doLongWithOverflow(long value, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.negate(value));
        }

        @Specialization
        Object doObject(RubyBignum value, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.execute(this, BigIntegerOps.negate(value.value));
        }
    }
}

