/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.objectspace;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.truffleruby.Layouts;
import org.truffleruby.RubyLanguage;
import org.truffleruby.language.RubyDynamicObject;

public final class ObjectSpaceManager {
    @CompilerDirectives.CompilationFinal
    private boolean isTracing = false;
    private final AtomicInteger tracingAssumptionActivations = new AtomicInteger(0);
    private final AtomicInteger tracingGeneration = new AtomicInteger(0);
    private final ThreadLocal<Boolean> tracingPaused = ThreadLocal.withInitial(() -> false);
    public static final long INITIAL_LANGUAGE_OBJECT_ID = 16L;
    public static final long OBJECT_ID_INCREMENT_BY = 16L;
    private static final long INITIAL_CONTEXT_OBJECT_ID = 8L;
    private final AtomicLong nextObjectID = new AtomicLong(8L);

    public void traceAllocationsStart(RubyLanguage language) {
        if (this.tracingAssumptionActivations.incrementAndGet() == 1) {
            this.isTracing = true;
            language.invalidateTracingAssumption();
        }
    }

    public void traceAllocationsStop(RubyLanguage language) {
        if (this.tracingAssumptionActivations.decrementAndGet() == 0) {
            this.isTracing = false;
            language.invalidateTracingAssumption();
        }
    }

    public void traceAllocationsClear() {
        this.tracingGeneration.incrementAndGet();
    }

    public boolean isTracing(RubyLanguage language) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)language));
        if (!language.getTracingAssumption().isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        return this.isTracing;
    }

    public boolean isTracingPaused() {
        return this.tracingPaused.get();
    }

    public void setTracingPaused(boolean tracingPaused) {
        this.tracingPaused.set(tracingPaused);
    }

    public int getTracingGeneration() {
        return this.tracingGeneration.get();
    }

    public static long readObjectID(RubyDynamicObject object, DynamicObjectLibrary objectLibrary) {
        try {
            return objectLibrary.getLongOrDefault((DynamicObject)object, (Object)Layouts.OBJECT_ID_IDENTIFIER, (Object)0L);
        }
        catch (UnexpectedResultException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    public long getNextObjectID() {
        long id = this.nextObjectID.getAndAdd(16L);
        if (id == -8L) {
            throw CompilerDirectives.shouldNotReachHere((String)"Object IDs exhausted");
        }
        return id;
    }

    public static int getCollectionCount() {
        int count = 0;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            count += Math.toIntExact(bean.getCollectionCount());
        }
        return count;
    }
}

