/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.range;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.range.RubyIntOrLongRange;
import org.truffleruby.core.string.StringUtils;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyIntRange
extends RubyIntOrLongRange {
    public final int begin;
    public final int end;

    public RubyIntRange(boolean excludedEnd, int begin, int end) {
        super(excludedEnd);
        this.begin = begin;
        this.end = end;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.excludedEnd) {
            return StringUtils.format("%d...%d", this.begin, this.end);
        }
        return StringUtils.format("%d..%d", this.begin, this.end);
    }

    @Override
    @ExportMessage
    public String toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    public RubyClass getMetaObject(@CachedLibrary(value="this") InteropLibrary node) {
        return RubyContext.get((Node)node).getCoreLibrary().rangeClass;
    }
}

