/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.cast.ToSNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.InterpolatedRegexpNodeGen;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.PerformanceWarningNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.library.RubyStringLibrary;

public abstract class InterpolatedRegexpNode
extends RubyContextSourceNode {
    @Node.Children
    private final ToSNode[] children;
    public final RubyEncoding encoding;
    public final RegexpOptions options;

    public InterpolatedRegexpNode(RubyEncoding encoding, RegexpOptions options, ToSNode[] children) {
        this.encoding = encoding;
        this.options = options;
        this.children = children;
    }

    @Specialization
    RubyRegexp interpolatedRegexp(VirtualFrame frame, @Bind(value="this") Node node, @Cached(value="create(encoding, options)") RegexpBuilderNode builderNode, @Cached TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached RubyStringLibrary libString) {
        return builderNode.execute(this.childrenToStrings(frame, node, libString, asTruffleStringNode));
    }

    @ExplodeLoop
    protected TStringWithEncoding[] childrenToStrings(VirtualFrame frame, Node node, RubyStringLibrary libString, TruffleString.AsTruffleStringNode asTruffleStringNode) {
        TStringWithEncoding[] values = new TStringWithEncoding[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            Object value = this.children[i].execute(frame);
            values[i] = new TStringWithEncoding(asTruffleStringNode, libString.getTString(node, value), libString.getEncoding(node, value));
        }
        return values;
    }

    @Override
    public RubyNode cloneUninitialized() {
        InterpolatedRegexpNode copy = InterpolatedRegexpNodeGen.create(this.encoding, this.options, InterpolatedRegexpNode.cloneUninitialized(this.children));
        return copy.copyFlags(this);
    }

    protected static ToSNode[] cloneUninitialized(ToSNode[] nodes) {
        ToSNode[] copies = new ToSNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            copies[i] = (ToSNode)nodes[i].cloneUninitialized();
        }
        return copies;
    }

    public static abstract class RegexpBuilderNode
    extends RubyBaseNode {
        @Node.Child
        private TruffleString.EqualNode equalNode = TruffleString.EqualNode.create();
        private final RubyEncoding encoding;
        private final RegexpOptions options;

        @NeverDefault
        public static RegexpBuilderNode create(RubyEncoding encoding, RegexpOptions options) {
            return InterpolatedRegexpNodeGen.RegexpBuilderNodeGen.create(encoding, options);
        }

        public RegexpBuilderNode(RubyEncoding encoding, RegexpOptions options) {
            this.encoding = encoding;
            this.options = options;
        }

        public abstract RubyRegexp execute(TStringWithEncoding[] var1);

        @Specialization(guards={"tstringsWithEncodingsMatch(cachedParts, parts)"}, limit="getDefaultCacheLimit()")
        RubyRegexp fast(TStringWithEncoding[] parts, @Cached(value="parts", dimensions=1) TStringWithEncoding[] cachedParts, @Cached(value="createRegexp(cachedParts)") RubyRegexp regexp) {
            return regexp;
        }

        @Specialization(replaces={"fast"})
        RubyRegexp slow(TStringWithEncoding[] parts, @Cached PerformanceWarningNode performanceWarningNode) {
            performanceWarningNode.warn("unstable interpolated regexps cause deoptimization loops which hurt performance significantly, avoid creating regexps dynamically where possible or cache them to fix this");
            return this.createRegexp(parts);
        }

        @ExplodeLoop
        protected boolean tstringsWithEncodingsMatch(TStringWithEncoding[] a, TStringWithEncoding[] b) {
            for (int i = 0; i < a.length; ++i) {
                RubyEncoding aEncoding = a[i].encoding;
                if (aEncoding != b[i].encoding) {
                    return false;
                }
                if (this.equalNode.execute((AbstractTruffleString)a[i].tstring, (AbstractTruffleString)b[i].tstring, aEncoding.tencoding)) continue;
                return false;
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        protected RubyRegexp createRegexp(TStringWithEncoding[] strings) {
            TStringWithEncoding[] stringsWithPrefix = new TStringWithEncoding[1 + strings.length];
            stringsWithPrefix[0] = new TStringWithEncoding(this.encoding.tencoding.getEmpty(), this.encoding);
            System.arraycopy(strings, 0, stringsWithPrefix, 1, strings.length);
            try {
                TStringWithEncoding preprocessed = ClassicRegexp.preprocessDRegexp(this.getContext(), stringsWithPrefix, this.options);
                return RubyRegexp.create(this.getLanguage(), preprocessed.tstring, preprocessed.encoding, this.options, this);
            }
            catch (DeferredRaiseException dre) {
                throw dre.getException(this.getContext());
            }
        }
    }
}

