/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.StringHelperNodes;

public final class StringGuards {
    private static final int CASE_FULL_UNICODE = 0;

    public static boolean is7Bit(AbstractTruffleString tstring, RubyEncoding encoding, TruffleString.GetByteCodeRangeNode codeRangeNode) {
        return codeRangeNode.execute(tstring, encoding.tencoding) == TruffleString.CodeRange.ASCII;
    }

    public static boolean is7BitUncached(AbstractTruffleString tstring, RubyEncoding encoding) {
        CompilerAsserts.neverPartOfCompilation((String)"Only behind @TruffleBoundary");
        return tstring.getByteCodeRangeUncached(encoding.tencoding) == TruffleString.CodeRange.ASCII;
    }

    public static boolean isValid(AbstractTruffleString tstring, RubyEncoding encoding, TruffleString.GetByteCodeRangeNode codeRangeNode) {
        return codeRangeNode.execute(tstring, encoding.tencoding) == TruffleString.CodeRange.VALID;
    }

    public static boolean isBrokenCodeRange(AbstractTruffleString string, RubyEncoding encoding, TruffleString.GetByteCodeRangeNode codeRangeNode) {
        return codeRangeNode.execute(string, encoding.tencoding) == TruffleString.CodeRange.BROKEN;
    }

    public static boolean isBrokenCodeRange(AbstractTruffleString string, TruffleString.Encoding encoding, TruffleString.GetByteCodeRangeNode codeRangeNode) {
        return codeRangeNode.execute(string, encoding) == TruffleString.CodeRange.BROKEN;
    }

    public static boolean isSingleByteOptimizable(Node node, AbstractTruffleString tString, RubyEncoding encoding, StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode) {
        return singleByteOptimizableNode.execute(node, tString, encoding);
    }

    public static boolean isAsciiCompatible(RubyEncoding encoding) {
        return encoding.isAsciiCompatible;
    }

    public static boolean isFixedWidthEncoding(RubyEncoding encoding) {
        return encoding.isFixedWidth;
    }

    private static boolean isAsciiCompatMapping(int caseMappingOptions) {
        return caseMappingOptions == 0 || caseMappingOptions == 0x400000;
    }

    private static boolean isAsciiCodePointsMapping(Node node, AbstractTruffleString tstring, RubyEncoding encoding, int caseMappingOptions, StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode) {
        return StringGuards.isSingleByteOptimizable(node, tstring, encoding, singleByteOptimizableNode) ? StringGuards.isAsciiCompatMapping(caseMappingOptions) : caseMappingOptions == 0x400000 && StringGuards.isAsciiCompatible(encoding);
    }

    public static boolean isComplexCaseMapping(Node node, AbstractTruffleString tstring, RubyEncoding encoding, int caseMappingOptions, StringHelperNodes.SingleByteOptimizableNode singleByteOptimizableNode) {
        return !StringGuards.isAsciiCodePointsMapping(node, tstring, encoding, caseMappingOptions, singleByteOptimizableNode);
    }
}

