/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Locale;
import org.truffleruby.core.string.StringOperations;

public abstract class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    @CompilerDirectives.TruffleBoundary
    public static String toString(Object value) {
        return String.valueOf(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(Locale locale, String format, Object ... args) {
        return String.format(locale, format, args);
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(String format, Object ... args) {
        return String.format(format, args);
    }

    public static byte[] formatASCIIBytes(String format, Object ... args) {
        return StringOperations.encodeAsciiBytes(StringUtils.format(format, args));
    }

    @CompilerDirectives.TruffleBoundary
    public static String replace(String string, char oldChar, char newChar) {
        return string.replace(oldChar, newChar);
    }

    @CompilerDirectives.TruffleBoundary
    public static String replace(String string, CharSequence target, CharSequence replacement) {
        return string.replace(target, replacement);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    @CompilerDirectives.TruffleBoundary
    public static String join(Object[] elements, String separator) {
        return StringUtils.join(elements, separator, "", "");
    }

    @CompilerDirectives.TruffleBoundary
    public static String join(Object[] elements, String separator, String prefix, String suffix) {
        StringBuilder builder = new StringBuilder(prefix);
        for (int i = 0; i < elements.length; ++i) {
            builder.append(elements[i]);
            if (i == elements.length - 1) continue;
            builder.append(separator);
        }
        builder.append(suffix);
        return builder.toString();
    }
}

