/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.symbol;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Map;
import org.graalvm.collections.Pair;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.symbol.SymbolNodesFactory;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyLambdaRootNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.SymbolProcNode;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;
import org.truffleruby.parser.ArgumentDescriptor;

@CoreModule(value="Symbol", isClass=true)
public abstract class SymbolNodes {

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        ImmutableRubyString toS(RubySymbol symbol) {
            return symbol.getName(this.getLanguage());
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString toS(RubySymbol symbol) {
            return this.createString(symbol.tstring, symbol.encoding);
        }
    }

    @CoreMethod(names={"to_proc"}, alwaysInlined=true)
    @GenerateUncached
    @ImportStatic(value={DeclarationContext.class})
    public static abstract class ToProcNode
    extends AlwaysInlinedMethodNode {
        public static final Arity ARITY = new Arity(1, 0, true);

        public static ToProcNode create() {
            return SymbolNodesFactory.ToProcNodeFactory.create();
        }

        @Specialization(guards={"isSingleContext()", "symbol == cachedSymbol", "getRefinements(callerFrame) == cachedRefinements"}, limit="1")
        RubyProc toProcCached(Frame callerFrame, RubySymbol symbol, Object[] rubyArgs, RootCallTarget target, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="getRefinements(callerFrame)") Map<RubyModule, RubyModule[]> cachedRefinements, @Cached(value="getOrCreateCallTarget(getContext(), getLanguage(), cachedSymbol, cachedRefinements)") RootCallTarget callTarget, @Cached(value="createProc(getContext(), getLanguage(), cachedRefinements, callTarget)") RubyProc cachedProc) {
            return cachedProc;
        }

        @Specialization(guards={"symbol == cachedSymbol", "getRefinements(callerFrame) == NO_REFINEMENTS"}, limit="1")
        RubyProc toProcCachedNoRefinements(Frame callerFrame, RubySymbol symbol, Object[] rubyArgs, RootCallTarget target, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="getOrCreateCallTarget(getContext(), getLanguage(), cachedSymbol, NO_REFINEMENTS)") RootCallTarget callTarget) {
            return ToProcNode.createProc(this.getContext(), this.getLanguage(), DeclarationContext.NO_REFINEMENTS, callTarget);
        }

        @Specialization(replaces={"toProcCached", "toProcCachedNoRefinements"})
        RubyProc toProcUncached(Frame callerFrame, RubySymbol symbol, Object[] rubyArgs, RootCallTarget target) {
            Map<RubyModule, RubyModule[]> refinements = this.getRefinements(callerFrame);
            RootCallTarget callTarget = ToProcNode.getOrCreateCallTarget(this.getContext(), this.getLanguage(), symbol, refinements);
            return ToProcNode.createProc(this.getContext(), this.getLanguage(), refinements, callTarget);
        }

        @CompilerDirectives.TruffleBoundary
        public static RootCallTarget getOrCreateCallTarget(RubyContext context, RubyLanguage language, RubySymbol symbol, Map<RubyModule, RubyModule[]> refinements) {
            if (refinements == DeclarationContext.NO_REFINEMENTS) {
                return symbol.getCallTargetNoRefinements(language);
            }
            return ConcurrentOperations.getOrCompute(context.cachedSymbolToProcTargetsWithRefinements, Pair.create((Object)symbol, refinements), key -> ToProcNode.createCallTarget(language, symbol, refinements));
        }

        public static RubyProc createProc(RubyContext context, RubyLanguage language, Map<RubyModule, RubyModule[]> refinements, RootCallTarget callTarget) {
            InternalMethod method = context.getCoreMethods().SYMBOL_TO_PROC;
            DeclarationContext declarationContext = refinements == DeclarationContext.NO_REFINEMENTS ? DeclarationContext.NONE : new DeclarationContext(Visibility.PUBLIC, null, refinements);
            Object[] args = RubyArguments.pack(null, null, method, declarationContext, null, nil, nil, NoKeywordArgumentsDescriptor.INSTANCE, EMPTY_ARGUMENTS);
            SpecialVariableStorage variables = new SpecialVariableStorage();
            MaterializedFrame declarationFrame = language.createEmptyDeclarationFrame(args, variables);
            return ProcOperations.createRubyProc(context.getCoreLibrary().procClass, language.procShape, ProcType.LAMBDA, RubyRootNode.of(callTarget).getSharedMethodInfo(), new ProcCallTargets(callTarget), declarationFrame, variables, method, null, declarationContext);
        }

        public static RootCallTarget createCallTarget(RubyLanguage language, RubySymbol symbol, Map<RubyModule, RubyModule[]> refinements) {
            SourceSection sourceSection = CoreLibrary.UNAVAILABLE_SOURCE_SECTION;
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, LexicalScope.IGNORE, ARITY, symbol.getString(), 0, "&:" + symbol.getString(), "Symbol#to_proc", ArgumentDescriptor.AT_LEAST_ONE_UNNAMED);
            RubyLambdaRootNode rootNode = new RubyLambdaRootNode(language, sourceSection, new FrameDescriptor((Object)nil), sharedMethodInfo, new SymbolProcNode(symbol.getString()), Split.HEURISTIC, ReturnID.INVALID, BreakID.INVALID, ARITY);
            return rootNode.getCallTarget();
        }

        protected Map<RubyModule, RubyModule[]> getRefinements(Frame callerFrame) {
            DeclarationContext declarationContext = RubyArguments.tryGetDeclarationContext(callerFrame);
            return declarationContext != null ? declarationContext.getRefinements() : DeclarationContext.NONE.getRefinements();
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.SYMBOL_TO_PROC_CACHE;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public static HashNode create() {
            return SymbolNodesFactory.HashNodeFactory.create(null);
        }

        public abstract long execute(RubySymbol var1);

        @Specialization
        long hash(RubySymbol symbol, @Cached HashSymbolNode hash) {
            return hash.execute(this, symbol);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HashSymbolNode
    extends RubyBaseNode {
        public abstract long execute(Node var1, RubySymbol var2);

        @Specialization(guards={"isSingleContext()", "symbol == cachedSymbol", "!preInitializing"}, limit="1")
        static long hashCached(Node node, RubySymbol symbol, @Cached(value="isPreInitializing(getContext())") boolean preInitializing, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="hash(node, cachedSymbol)") long cachedHash) {
            return cachedHash;
        }

        @Specialization(replaces={"hashCached"})
        static long hash(Node node, RubySymbol symbol) {
            return symbol.computeHashCode(HashSymbolNode.getContext(node).getHashing());
        }

        protected boolean isPreInitializing(RubyContext context) {
            return context.isPreInitializing();
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean equal(RubySymbol a, Object b) {
            return a == b;
        }
    }

    @CoreMethod(names={"all_symbols"}, onSingleton=true)
    public static abstract class AllSymbolsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray allSymbols() {
            return this.createArray(this.getLanguage().symbolTable.allSymbols().toArray());
        }
    }
}

