/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.symbol;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.collections.WeakValueCache;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.TStringCache;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.symbol.CoreSymbols;
import org.truffleruby.core.symbol.RubySymbol;

public final class SymbolTable {
    private final TStringCache tstringCache;
    private final WeakValueCache<String, RubySymbol> stringToSymbolCache = new WeakValueCache();
    private final WeakValueCache<TStringWithEncoding, RubySymbol> symbolMap = new WeakValueCache();
    private final ConcurrentHashMap<TStringWithEncoding, RubySymbol> preservedSymbolMap = new ConcurrentHashMap();

    public SymbolTable(TStringCache tstringCache, CoreSymbols coreSymbols) {
        this.tstringCache = tstringCache;
        this.addCoreSymbols(coreSymbols);
    }

    private void addCoreSymbols(CoreSymbols coreSymbols) {
        for (RubySymbol symbol : coreSymbols.CORE_SYMBOLS) {
            TruffleString tstring = symbol.tstring;
            TStringWithEncoding lookup = this.normalizeForLookup((AbstractTruffleString)tstring, symbol.encoding);
            assert (tstring == lookup.tstring);
            assert (tstring == this.tstringCache.getTString(symbol.tstring, symbol.encoding));
            RubySymbol existing = this.symbolMap.put(lookup, symbol);
            if (existing != null) {
                throw new AssertionError((Object)("Duplicate Symbol in SymbolTable: " + String.valueOf(existing)));
            }
            RubySymbol old = this.stringToSymbolCache.put(symbol.getString(), symbol);
            if (old != null) {
                throw new AssertionError((Object)("Duplicate Symbol in SymbolTable: " + String.valueOf(old)));
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public RubySymbol getSymbol(String string) {
        RubyEncoding encoding;
        TruffleString str;
        RubySymbol symbol = this.stringToSymbolCache.get(string);
        if (symbol != null) {
            return symbol;
        }
        if (StringOperations.isAsciiOnly(string)) {
            str = TStringUtils.usAsciiString(string);
            encoding = Encodings.US_ASCII;
        } else {
            str = TStringUtils.utf8TString(string);
            encoding = Encodings.UTF_8;
        }
        symbol = this.getSymbol((AbstractTruffleString)str, encoding, false);
        this.stringToSymbolCache.addInCacheIfAbsent(string, symbol);
        return symbol;
    }

    @CompilerDirectives.TruffleBoundary
    public RubySymbol getSymbol(AbstractTruffleString tstring, RubyEncoding originalEncoding, boolean preserveSymbol) {
        TStringWithEncoding key = this.normalizeForLookup(tstring, originalEncoding);
        RubySymbol symbol = this.preservedSymbolMap.get(key);
        if (symbol != null) {
            return symbol;
        }
        symbol = this.symbolMap.get(key);
        if (symbol != null) {
            if (preserveSymbol) {
                this.preservedSymbolMap.put(key, symbol);
            }
            return symbol;
        }
        RubyEncoding symbolEncoding = key.encoding;
        TruffleString cachedTString = this.tstringCache.getTString(key.tstring, symbolEncoding);
        RubySymbol newSymbol = this.createSymbol(cachedTString, symbolEncoding);
        RubySymbol savedSymbol = this.symbolMap.addInCacheIfAbsent(new TStringWithEncoding(cachedTString, symbolEncoding), newSymbol);
        if (preserveSymbol) {
            this.preservedSymbolMap.put(key, savedSymbol);
        }
        return savedSymbol;
    }

    @CompilerDirectives.TruffleBoundary
    public RubySymbol getSymbolIfExists(AbstractTruffleString tstring, RubyEncoding encoding) {
        TStringWithEncoding key = this.normalizeForLookup(tstring, encoding);
        return this.symbolMap.get(key);
    }

    private TStringWithEncoding normalizeForLookup(AbstractTruffleString tstring, RubyEncoding encoding) {
        TruffleString string = tstring.asManagedTruffleStringUncached(encoding.tencoding);
        TStringWithEncoding strEnc = new TStringWithEncoding(string, encoding);
        if (strEnc.isAsciiOnly() && encoding != Encodings.US_ASCII) {
            strEnc = strEnc.forceEncoding(Encodings.US_ASCII);
        }
        return strEnc;
    }

    private RubySymbol createSymbol(TruffleString truffleString, RubyEncoding encoding) {
        return new RubySymbol(truffleString.toString(), truffleString, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<RubySymbol> allSymbols() {
        return this.symbolMap.values();
    }
}

