/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.array.ArrayToObjectArrayNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.core.thread.ThreadManager;
import org.truffleruby.core.thread.ThreadNodes;
import org.truffleruby.interop.ForeignToRubyNode;
import org.truffleruby.interop.ForeignToRubyNodeGen;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.interop.TranslateInteropExceptionNodeGen;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyTypes;
import org.truffleruby.language.RubyTypesGen;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.language.yield.CallBlockNodeGen;

@GeneratedBy(value=ThreadNodes.class)
public final class ThreadNodesFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    public static List<NodeFactory<? extends RubyContextSourceNode>> getFactories() {
        return List.of(AllocateNodeFactory.getInstance(), AliveNodeFactory.getInstance(), BacktraceNodeFactory.getInstance(), AllFibersBacktracesNodeFactory.getInstance(), BacktraceLocationsNodeFactory.getInstance(), CurrentNodeFactory.getInstance(), GroupNodeFactory.getInstance(), KillNodeFactory.getInstance(), PendingInterruptNodeFactory.getInstance(), HandleInterruptNodeFactory.getInstance(), ThreadAllocateNodeFactory.getInstance(), ThreadIsInitializedNodeFactory.getInstance(), ThreadInitializeNodeFactory.getInstance(), JoinNodeFactory.getInstance(), MainNodeFactory.getInstance(), PassNodeFactory.getInstance(), StatusNodeFactory.getInstance(), ThreadSetStatusPrimitiveNodeFactory.getInstance(), NativeThreadIdNodeFactory.getInstance(), StopNodeFactory.getInstance(), ValueNodeFactory.getInstance(), WakeupNodeFactory.getInstance(), CallWithUnblockingFunctionNodeFactory.getInstance(), ListNodeFactory.getInstance(), ThreadLocalVariablesPrimitiveNodeFactory.getInstance(), ThreadRandomizerPrimitiveNodeFactory.getInstance(), ThreadRecursiveObjectsPrimitiveNodeFactory.getInstance(), ThreadDetectRecursionSingleNodeFactory.getInstance(), ThreadGetReportOnExceptionPrimitiveNodeFactory.getInstance(), ThreadSetReportOnExceptionPrimitiveNodeFactory.getInstance(), ThreadGetAbortOnExceptionPrimitiveNodeFactory.getInstance(), ThreadSetAbortOnExceptionPrimitiveNodeFactory.getInstance(), ThreadRaisePrimitiveNodeFactory.getInstance(), ThreadSourceLocationNodeFactory.getInstance(), ThreadNameNodeFactory.getInstance(), ThreadSetNamePrimitiveNodeFactory.getInstance(), ThreadGetPriorityPrimitiveNodeFactory.getInstance(), ThreadSetPriorityPrimitiveNodeFactory.getInstance(), ThreadSetGroupPrimitiveNodeFactory.getInstance(), ThreadGetReturnCodeNodeFactory.getInstance(), SetThreadLocalReturnCodeNodeFactory.getInstance(), ThreadGetFiberLocalsNodeFactory.getInstance(), ThreadRunBlockingSystemCallNodeFactory.getInstance(), EachCallerLocationNodeFactory.getInstance());
    }

    @GeneratedBy(value=ThreadNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<ThreadNodes.AllocateNode> {
        private static final AllocateNodeFactory ALLOCATE_NODE_FACTORY_INSTANCE = new AllocateNodeFactory();

        private AllocateNodeFactory() {
        }

        public Class<ThreadNodes.AllocateNode> getNodeClass() {
            return ThreadNodes.AllocateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AllocateNode> getInstance() {
            return ALLOCATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.AllocateNode create(RubyNode[] argumentNodes) {
            return new AllocateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends ThreadNodes.AllocateNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AllocateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    return this.allocate(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.allocate(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AliveNode.class)
    public static final class AliveNodeFactory
    implements NodeFactory<ThreadNodes.AliveNode> {
        private static final AliveNodeFactory ALIVE_NODE_FACTORY_INSTANCE = new AliveNodeFactory();

        private AliveNodeFactory() {
        }

        public Class<ThreadNodes.AliveNode> getNodeClass() {
            return ThreadNodes.AliveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.AliveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AliveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AliveNode> getInstance() {
            return ALIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.AliveNode create(RubyNode[] argumentNodes) {
            return new AliveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.AliveNode.class)
        public static final class AliveNodeGen
        extends ThreadNodes.AliveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AliveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.alive(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.alive(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.BacktraceNode.class)
    public static final class BacktraceNodeFactory
    implements NodeFactory<ThreadNodes.BacktraceNode> {
        private static final BacktraceNodeFactory BACKTRACE_NODE_FACTORY_INSTANCE = new BacktraceNodeFactory();

        private BacktraceNodeFactory() {
        }

        public Class<ThreadNodes.BacktraceNode> getNodeClass() {
            return ThreadNodes.BacktraceNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.BacktraceNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BacktraceNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.BacktraceNode> getInstance() {
            return BACKTRACE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.BacktraceNode create(RubyNode[] argumentNodes) {
            return new BacktraceNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.BacktraceNode.class)
        public static final class BacktraceNodeGen
        extends ThreadNodes.BacktraceNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private BacktraceNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Integer) {
                        int argumentNodes1Value__ = (Integer)argumentNodes1Value_;
                        if ((state_0 & 1) != 0 && RubyTypes.isNotProvided(argumentNodes2Value_)) {
                            NotProvided argumentNodes2Value__ = RubyTypes.asNotProvided(argumentNodes2Value_);
                            return this.backtrace(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__);
                        }
                        if ((state_0 & 2) != 0 && argumentNodes2Value_ instanceof Integer) {
                            int argumentNodes2Value__ = (Integer)argumentNodes2Value_;
                            return this.backtrace(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Integer) {
                        int argumentNodes1Value_ = (Integer)argumentNodes1Value;
                        if (RubyTypes.isNotProvided(argumentNodes2Value)) {
                            NotProvided argumentNodes2Value_ = RubyTypes.asNotProvided(argumentNodes2Value);
                            this.state_0_ = state_0 |= 1;
                            return this.backtrace(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
                        }
                        if (argumentNodes2Value instanceof Integer) {
                            int argumentNodes2Value_ = (Integer)argumentNodes2Value;
                            this.state_0_ = state_0 |= 2;
                            return this.backtrace(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AllFibersBacktracesNode.class)
    public static final class AllFibersBacktracesNodeFactory
    implements NodeFactory<ThreadNodes.AllFibersBacktracesNode> {
        private static final AllFibersBacktracesNodeFactory ALL_FIBERS_BACKTRACES_NODE_FACTORY_INSTANCE = new AllFibersBacktracesNodeFactory();

        private AllFibersBacktracesNodeFactory() {
        }

        public Class<ThreadNodes.AllFibersBacktracesNode> getNodeClass() {
            return ThreadNodes.AllFibersBacktracesNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.AllFibersBacktracesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllFibersBacktracesNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.AllFibersBacktracesNode> getInstance() {
            return ALL_FIBERS_BACKTRACES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.AllFibersBacktracesNode create(RubyNode[] argumentNodes) {
            return new AllFibersBacktracesNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.AllFibersBacktracesNode.class)
        public static final class AllFibersBacktracesNodeGen
        extends ThreadNodes.AllFibersBacktracesNode {
            private AllFibersBacktracesNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.allFibersBacktraces();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.BacktraceLocationsNode.class)
    public static final class BacktraceLocationsNodeFactory
    implements NodeFactory<ThreadNodes.BacktraceLocationsNode> {
        private static final BacktraceLocationsNodeFactory BACKTRACE_LOCATIONS_NODE_FACTORY_INSTANCE = new BacktraceLocationsNodeFactory();

        private BacktraceLocationsNodeFactory() {
        }

        public Class<ThreadNodes.BacktraceLocationsNode> getNodeClass() {
            return ThreadNodes.BacktraceLocationsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.BacktraceLocationsNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BacktraceLocationsNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.BacktraceLocationsNode> getInstance() {
            return BACKTRACE_LOCATIONS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.BacktraceLocationsNode create(RubyNode[] argumentNodes) {
            return new BacktraceLocationsNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.BacktraceLocationsNode.class)
        public static final class BacktraceLocationsNodeGen
        extends ThreadNodes.BacktraceLocationsNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private BacktraceLocationsNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Integer) {
                        int argumentNodes1Value__ = (Integer)argumentNodes1Value_;
                        if ((state_0 & 1) != 0 && RubyTypes.isNotProvided(argumentNodes2Value_)) {
                            NotProvided argumentNodes2Value__ = RubyTypes.asNotProvided(argumentNodes2Value_);
                            return this.backtraceLocations(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__);
                        }
                        if ((state_0 & 2) != 0 && argumentNodes2Value_ instanceof Integer) {
                            int argumentNodes2Value__ = (Integer)argumentNodes2Value_;
                            return this.backtraceLocations(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Integer) {
                        int argumentNodes1Value_ = (Integer)argumentNodes1Value;
                        if (RubyTypes.isNotProvided(argumentNodes2Value)) {
                            NotProvided argumentNodes2Value_ = RubyTypes.asNotProvided(argumentNodes2Value);
                            this.state_0_ = state_0 |= 1;
                            return this.backtraceLocations(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
                        }
                        if (argumentNodes2Value instanceof Integer) {
                            int argumentNodes2Value_ = (Integer)argumentNodes2Value;
                            this.state_0_ = state_0 |= 2;
                            return this.backtraceLocations(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.CurrentNode.class)
    public static final class CurrentNodeFactory
    implements NodeFactory<ThreadNodes.CurrentNode> {
        private static final CurrentNodeFactory CURRENT_NODE_FACTORY_INSTANCE = new CurrentNodeFactory();

        private CurrentNodeFactory() {
        }

        public Class<ThreadNodes.CurrentNode> getNodeClass() {
            return ThreadNodes.CurrentNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.CurrentNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CurrentNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.CurrentNode> getInstance() {
            return CURRENT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.CurrentNode create(RubyNode[] argumentNodes) {
            return new CurrentNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.CurrentNode.class)
        public static final class CurrentNodeGen
        extends ThreadNodes.CurrentNode {
            private CurrentNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.current();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.GroupNode.class)
    public static final class GroupNodeFactory
    implements NodeFactory<ThreadNodes.GroupNode> {
        private static final GroupNodeFactory GROUP_NODE_FACTORY_INSTANCE = new GroupNodeFactory();

        private GroupNodeFactory() {
        }

        public Class<ThreadNodes.GroupNode> getNodeClass() {
            return ThreadNodes.GroupNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.GroupNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GroupNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.GroupNode> getInstance() {
            return GROUP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.GroupNode create(RubyNode[] argumentNodes) {
            return new GroupNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.GroupNode.class)
        public static final class GroupNodeGen
        extends ThreadNodes.GroupNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private GroupNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.group(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.group(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.KillNode.class)
    public static final class KillNodeFactory
    implements NodeFactory<ThreadNodes.KillNode> {
        private static final KillNodeFactory KILL_NODE_FACTORY_INSTANCE = new KillNodeFactory();

        private KillNodeFactory() {
        }

        public Class<ThreadNodes.KillNode> getNodeClass() {
            return ThreadNodes.KillNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.KillNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return KillNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.KillNode> getInstance() {
            return KILL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.KillNode create(RubyNode[] argumentNodes) {
            return new KillNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.KillNode.class)
        public static final class KillNodeGen
        extends ThreadNodes.KillNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private KillNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.kill(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyThread executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.kill(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.PendingInterruptNode.class)
    public static final class PendingInterruptNodeFactory
    implements NodeFactory<ThreadNodes.PendingInterruptNode> {
        private static final PendingInterruptNodeFactory PENDING_INTERRUPT_NODE_FACTORY_INSTANCE = new PendingInterruptNodeFactory();

        private PendingInterruptNodeFactory() {
        }

        public Class<ThreadNodes.PendingInterruptNode> getNodeClass() {
            return ThreadNodes.PendingInterruptNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.PendingInterruptNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PendingInterruptNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.PendingInterruptNode> getInstance() {
            return PENDING_INTERRUPT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.PendingInterruptNode create(RubyNode[] argumentNodes) {
            return new PendingInterruptNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.PendingInterruptNode.class)
        public static final class PendingInterruptNodeGen
        extends ThreadNodes.PendingInterruptNode {
            private static final InlineSupport.StateField STATE_0_PendingInterruptNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_ERROR_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_PendingInterruptNode_UPDATER.subUpdater(1, 1)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private PendingInterruptNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.pendingInterrupt(argumentNodes0Value__, INLINED_ERROR_PROFILE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.pendingInterrupt(argumentNodes0Value_, INLINED_ERROR_PROFILE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.HandleInterruptNode.class)
    public static final class HandleInterruptNodeFactory
    implements NodeFactory<ThreadNodes.HandleInterruptNode> {
        private static final HandleInterruptNodeFactory HANDLE_INTERRUPT_NODE_FACTORY_INSTANCE = new HandleInterruptNodeFactory();

        private HandleInterruptNodeFactory() {
        }

        public Class<ThreadNodes.HandleInterruptNode> getNodeClass() {
            return ThreadNodes.HandleInterruptNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.HandleInterruptNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return HandleInterruptNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.HandleInterruptNode> getInstance() {
            return HANDLE_INTERRUPT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.HandleInterruptNode create(RubyNode[] argumentNodes) {
            return new HandleInterruptNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.HandleInterruptNode.class)
        public static final class HandleInterruptNodeGen
        extends ThreadNodes.HandleInterruptNode {
            private static final InlineSupport.StateField STATE_0_HandleInterruptNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_BEFORE_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_HandleInterruptNode_UPDATER.subUpdater(1, 1)}));
            private static final InlinedBranchProfile INLINED_AFTER_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_HandleInterruptNode_UPDATER.subUpdater(2, 1)}));
            private static final CallBlockNode INLINED_YIELD_NODE_ = CallBlockNodeGen.inline(InlineSupport.InlineTarget.create(CallBlockNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_HandleInterruptNode_UPDATER.subUpdater(3, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field2_;

            private HandleInterruptNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value__ = (RubySymbol)argumentNodes1Value_;
                        if (argumentNodes2Value_ instanceof RubyProc) {
                            RubyProc argumentNodes2Value__ = (RubyProc)argumentNodes2Value_;
                            return this.handleInterrupt(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__, INLINED_BEFORE_PROFILE_, INLINED_AFTER_PROFILE_, INLINED_YIELD_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value_ = (RubySymbol)argumentNodes1Value;
                        if (argumentNodes2Value instanceof RubyProc) {
                            RubyProc argumentNodes2Value_ = (RubyProc)argumentNodes2Value;
                            this.state_0_ = state_0 |= 1;
                            return this.handleInterrupt(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_, INLINED_BEFORE_PROFILE_, INLINED_AFTER_PROFILE_, INLINED_YIELD_NODE_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadAllocateNode.class)
    public static final class ThreadAllocateNodeFactory
    implements NodeFactory<ThreadNodes.ThreadAllocateNode> {
        private static final ThreadAllocateNodeFactory THREAD_ALLOCATE_NODE_FACTORY_INSTANCE = new ThreadAllocateNodeFactory();

        private ThreadAllocateNodeFactory() {
        }

        public Class<ThreadNodes.ThreadAllocateNode> getNodeClass() {
            return ThreadNodes.ThreadAllocateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadAllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadAllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadAllocateNode> getInstance() {
            return THREAD_ALLOCATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadAllocateNode create(RubyNode[] argumentNodes) {
            return new ThreadAllocateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadAllocateNode.class)
        public static final class ThreadAllocateNodeGen
        extends ThreadNodes.ThreadAllocateNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadAllocateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    return this.allocate(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyThread executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.allocate(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadIsInitializedNode.class)
    public static final class ThreadIsInitializedNodeFactory
    implements NodeFactory<ThreadNodes.ThreadIsInitializedNode> {
        private static final ThreadIsInitializedNodeFactory THREAD_IS_INITIALIZED_NODE_FACTORY_INSTANCE = new ThreadIsInitializedNodeFactory();

        private ThreadIsInitializedNodeFactory() {
        }

        public Class<ThreadNodes.ThreadIsInitializedNode> getNodeClass() {
            return ThreadNodes.ThreadIsInitializedNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadIsInitializedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadIsInitializedNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadIsInitializedNode> getInstance() {
            return THREAD_IS_INITIALIZED_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadIsInitializedNode create(RubyNode[] argumentNodes) {
            return new ThreadIsInitializedNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadIsInitializedNode.class)
        public static final class ThreadIsInitializedNodeGen
        extends ThreadNodes.ThreadIsInitializedNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadIsInitializedNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.isInitialized(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isInitialized(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadInitializeNode.class)
    public static final class ThreadInitializeNodeFactory
    implements NodeFactory<ThreadNodes.ThreadInitializeNode> {
        private static final ThreadInitializeNodeFactory THREAD_INITIALIZE_NODE_FACTORY_INSTANCE = new ThreadInitializeNodeFactory();

        private ThreadInitializeNodeFactory() {
        }

        public Class<ThreadNodes.ThreadInitializeNode> getNodeClass() {
            return ThreadNodes.ThreadInitializeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadInitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadInitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadInitializeNode> getInstance() {
            return THREAD_INITIALIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadInitializeNode create(RubyNode[] argumentNodes) {
            return new ThreadInitializeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadInitializeNode.class)
        public static final class ThreadInitializeNodeGen
        extends ThreadNodes.ThreadInitializeNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadInitializeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.initialize(frameValue, argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, argumentNodes0Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.initialize(frameValue, argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.JoinNode.class)
    public static final class JoinNodeFactory
    implements NodeFactory<ThreadNodes.JoinNode> {
        private static final JoinNodeFactory JOIN_NODE_FACTORY_INSTANCE = new JoinNodeFactory();

        private JoinNodeFactory() {
        }

        public Class<ThreadNodes.JoinNode> getNodeClass() {
            return ThreadNodes.JoinNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.JoinNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return JoinNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.JoinNode> getInstance() {
            return JOIN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.JoinNode create(RubyNode[] argumentNodes) {
            return new JoinNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        public static final class JoinNodeGen
        extends ThreadNodes.JoinNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private JoinNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 0x3F) != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if ((state_0 & 1) != 0 && RubyTypes.isNotProvided(argumentNodes1Value_)) {
                        NotProvided argumentNodes1Value__ = RubyTypes.asNotProvided(argumentNodes1Value_);
                        return this.join(argumentNodes0Value__, argumentNodes1Value__);
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes1Value_)) {
                        Nil argumentNodes1Value__ = RubyTypes.asNil(argumentNodes1Value_);
                        return this.join(argumentNodes0Value__, argumentNodes1Value__);
                    }
                    if ((state_0 & 4) != 0 && argumentNodes1Value_ instanceof Integer) {
                        int argumentNodes1Value__ = (Integer)argumentNodes1Value_;
                        return this.join(argumentNodes0Value__, argumentNodes1Value__);
                    }
                    if ((state_0 & 8) != 0 && RubyTypesGen.isImplicitLong((state_0 & 0xC0) >>> 6, argumentNodes1Value_)) {
                        long argumentNodes1Value__ = RubyTypesGen.asImplicitLong((state_0 & 0xC0) >>> 6, argumentNodes1Value_);
                        return this.join(argumentNodes0Value__, argumentNodes1Value__);
                    }
                    if ((state_0 & 0x10) != 0 && argumentNodes1Value_ instanceof RubyBignum) {
                        RubyBignum argumentNodes1Value__ = (RubyBignum)argumentNodes1Value_;
                        return this.join(argumentNodes0Value__, argumentNodes1Value__);
                    }
                    if ((state_0 & 0x20) != 0 && argumentNodes1Value_ instanceof Double) {
                        double argumentNodes1Value__ = (Double)argumentNodes1Value_;
                        return this.join(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (RubyTypes.isNotProvided(argumentNodes1Value)) {
                        NotProvided argumentNodes1Value_ = RubyTypes.asNotProvided(argumentNodes1Value);
                        this.state_0_ = state_0 |= 1;
                        return this.join(argumentNodes0Value_, argumentNodes1Value_);
                    }
                    if (RubyTypes.isNil(argumentNodes1Value)) {
                        Nil argumentNodes1Value_ = RubyTypes.asNil(argumentNodes1Value);
                        this.state_0_ = state_0 |= 2;
                        return this.join(argumentNodes0Value_, argumentNodes1Value_);
                    }
                    if (argumentNodes1Value instanceof Integer) {
                        int argumentNodes1Value_ = (Integer)argumentNodes1Value;
                        this.state_0_ = state_0 |= 4;
                        return this.join(argumentNodes0Value_, argumentNodes1Value_);
                    }
                    int longCast1 = RubyTypesGen.specializeImplicitLong(argumentNodes1Value);
                    if (longCast1 != 0) {
                        long argumentNodes1Value_ = RubyTypesGen.asImplicitLong(longCast1, argumentNodes1Value);
                        state_0 |= longCast1 << 6;
                        this.state_0_ = state_0 |= 8;
                        return this.join(argumentNodes0Value_, argumentNodes1Value_);
                    }
                    if (argumentNodes1Value instanceof RubyBignum) {
                        RubyBignum argumentNodes1Value_ = (RubyBignum)argumentNodes1Value;
                        this.state_0_ = state_0 |= 0x10;
                        return this.join(argumentNodes0Value_, argumentNodes1Value_);
                    }
                    if (argumentNodes1Value instanceof Double) {
                        double argumentNodes1Value_ = (Double)argumentNodes1Value;
                        this.state_0_ = state_0 |= 0x20;
                        return this.join(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.MainNode.class)
    public static final class MainNodeFactory
    implements NodeFactory<ThreadNodes.MainNode> {
        private static final MainNodeFactory MAIN_NODE_FACTORY_INSTANCE = new MainNodeFactory();

        private MainNodeFactory() {
        }

        public Class<ThreadNodes.MainNode> getNodeClass() {
            return ThreadNodes.MainNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.MainNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MainNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.MainNode> getInstance() {
            return MAIN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.MainNode create(RubyNode[] argumentNodes) {
            return new MainNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.MainNode.class)
        public static final class MainNodeGen
        extends ThreadNodes.MainNode {
            private MainNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.main();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.PassNode.class)
    public static final class PassNodeFactory
    implements NodeFactory<ThreadNodes.PassNode> {
        private static final PassNodeFactory PASS_NODE_FACTORY_INSTANCE = new PassNodeFactory();

        private PassNodeFactory() {
        }

        public Class<ThreadNodes.PassNode> getNodeClass() {
            return ThreadNodes.PassNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.PassNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PassNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.PassNode> getInstance() {
            return PASS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.PassNode create(RubyNode[] argumentNodes) {
            return new PassNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.PassNode.class)
        public static final class PassNodeGen
        extends ThreadNodes.PassNode {
            private PassNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.pass();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StatusNode.class)
    public static final class StatusNodeFactory
    implements NodeFactory<ThreadNodes.StatusNode> {
        private static final StatusNodeFactory STATUS_NODE_FACTORY_INSTANCE = new StatusNodeFactory();

        private StatusNodeFactory() {
        }

        public Class<ThreadNodes.StatusNode> getNodeClass() {
            return ThreadNodes.StatusNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.StatusNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return StatusNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.StatusNode> getInstance() {
            return STATUS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.StatusNode create(RubyNode[] argumentNodes) {
            return new StatusNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.StatusNode.class)
        public static final class StatusNodeGen
        extends ThreadNodes.StatusNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private StatusNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.status(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.status(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetStatusPrimitiveNode.class)
    public static final class ThreadSetStatusPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetStatusPrimitiveNode> {
        private static final ThreadSetStatusPrimitiveNodeFactory THREAD_SET_STATUS_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadSetStatusPrimitiveNodeFactory();

        private ThreadSetStatusPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetStatusPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetStatusPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetStatusPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetStatusPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetStatusPrimitiveNode> getInstance() {
            return THREAD_SET_STATUS_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadSetStatusPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadSetStatusPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetStatusPrimitiveNode.class)
        public static final class ThreadSetStatusPrimitiveNodeGen
        extends ThreadNodes.ThreadSetStatusPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadSetStatusPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value__ = (RubySymbol)argumentNodes1Value_;
                        return this.threadSetStatus(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubySymbol) {
                        RubySymbol argumentNodes1Value_ = (RubySymbol)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.threadSetStatus(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.NativeThreadIdNode.class)
    public static final class NativeThreadIdNodeFactory
    implements NodeFactory<ThreadNodes.NativeThreadIdNode> {
        private static final NativeThreadIdNodeFactory NATIVE_THREAD_ID_NODE_FACTORY_INSTANCE = new NativeThreadIdNodeFactory();

        private NativeThreadIdNodeFactory() {
        }

        public Class<ThreadNodes.NativeThreadIdNode> getNodeClass() {
            return ThreadNodes.NativeThreadIdNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.NativeThreadIdNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NativeThreadIdNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.NativeThreadIdNode> getInstance() {
            return NATIVE_THREAD_ID_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.NativeThreadIdNode create(RubyNode[] argumentNodes) {
            return new NativeThreadIdNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.NativeThreadIdNode.class)
        public static final class NativeThreadIdNodeGen
        extends ThreadNodes.NativeThreadIdNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private NativeThreadIdNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.nativeThreadId(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.nativeThreadId(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StopNode.class)
    public static final class StopNodeFactory
    implements NodeFactory<ThreadNodes.StopNode> {
        private static final StopNodeFactory STOP_NODE_FACTORY_INSTANCE = new StopNodeFactory();

        private StopNodeFactory() {
        }

        public Class<ThreadNodes.StopNode> getNodeClass() {
            return ThreadNodes.StopNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.StopNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return StopNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.StopNode> getInstance() {
            return STOP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.StopNode create(RubyNode[] argumentNodes) {
            return new StopNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.StopNode.class)
        public static final class StopNodeGen
        extends ThreadNodes.StopNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private StopNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.stop(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.stop(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ValueNode.class)
    public static final class ValueNodeFactory
    implements NodeFactory<ThreadNodes.ValueNode> {
        private static final ValueNodeFactory VALUE_NODE_FACTORY_INSTANCE = new ValueNodeFactory();

        private ValueNodeFactory() {
        }

        public Class<ThreadNodes.ValueNode> getNodeClass() {
            return ThreadNodes.ValueNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ValueNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ValueNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ValueNode> getInstance() {
            return VALUE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ValueNode create(RubyNode[] argumentNodes) {
            return new ValueNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ValueNode.class)
        public static final class ValueNodeGen
        extends ThreadNodes.ValueNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ValueNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.value(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.value(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.WakeupNode.class)
    public static final class WakeupNodeFactory
    implements NodeFactory<ThreadNodes.WakeupNode> {
        private static final WakeupNodeFactory WAKEUP_NODE_FACTORY_INSTANCE = new WakeupNodeFactory();

        private WakeupNodeFactory() {
        }

        public Class<ThreadNodes.WakeupNode> getNodeClass() {
            return ThreadNodes.WakeupNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.WakeupNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return WakeupNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.WakeupNode> getInstance() {
            return WAKEUP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.WakeupNode create(RubyNode[] argumentNodes) {
            return new WakeupNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.WakeupNode.class)
        public static final class WakeupNodeGen
        extends ThreadNodes.WakeupNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private WakeupNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.wakeup(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyThread executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.wakeup(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.CallWithUnblockingFunctionNode.class)
    public static final class CallWithUnblockingFunctionNodeFactory
    implements NodeFactory<ThreadNodes.CallWithUnblockingFunctionNode> {
        private static final CallWithUnblockingFunctionNodeFactory CALL_WITH_UNBLOCKING_FUNCTION_NODE_FACTORY_INSTANCE = new CallWithUnblockingFunctionNodeFactory();

        private CallWithUnblockingFunctionNodeFactory() {
        }

        public Class<ThreadNodes.CallWithUnblockingFunctionNode> getNodeClass() {
            return ThreadNodes.CallWithUnblockingFunctionNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.CallWithUnblockingFunctionNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CallWithUnblockingFunctionNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.CallWithUnblockingFunctionNode> getInstance() {
            return CALL_WITH_UNBLOCKING_FUNCTION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.CallWithUnblockingFunctionNode create(RubyNode[] argumentNodes) {
            return new CallWithUnblockingFunctionNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.CallWithUnblockingFunctionNode.class)
        public static final class CallWithUnblockingFunctionNodeGen
        extends ThreadNodes.CallWithUnblockingFunctionNode {
            private static final InlineSupport.StateField CALL0_CALL_WITH_UNBLOCKING_FUNCTION_NODE_CALL0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Call0Data.lookup_(), (String)"call0_state_0_");
            private static final InlineSupport.StateField STATE_0_CallWithUnblockingFunctionNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            static final InlineSupport.ReferenceField<Call0Data> CALL0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"call0_cache", Call0Data.class);
            private static final TranslateInteropExceptionNode INLINED_CALL0_TRANSLATE_INTEROP_EXCEPTION_NODE_ = TranslateInteropExceptionNodeGen.inline(InlineSupport.InlineTarget.create(TranslateInteropExceptionNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CALL0_CALL_WITH_UNBLOCKING_FUNCTION_NODE_CALL0_STATE_0_UPDATER.subUpdater(0, 8)}));
            private static final TranslateInteropExceptionNode INLINED_CALL1_TRANSLATE_INTEROP_EXCEPTION_NODE_ = TranslateInteropExceptionNodeGen.inline(InlineSupport.InlineTarget.create(TranslateInteropExceptionNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CallWithUnblockingFunctionNode_UPDATER.subUpdater(6, 8)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @Node.Child
            private RubyNode argumentNodes3_;
            @Node.Child
            private RubyNode argumentNodes4_;
            @Node.Child
            private RubyNode argumentNodes5_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Call0Data call0_cache;
            @CompilerDirectives.CompilationFinal
            private ThreadManager.BlockingCallInterruptible call1_blockingCallInterruptible_;

            private CallWithUnblockingFunctionNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
                this.argumentNodes3_ = argumentNodes != null && 3 < argumentNodes.length ? argumentNodes[3] : null;
                this.argumentNodes4_ = argumentNodes != null && 4 < argumentNodes.length ? argumentNodes[4] : null;
                this.argumentNodes5_ = argumentNodes != null && 5 < argumentNodes.length ? argumentNodes[5] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_, this.argumentNodes3_, this.argumentNodes4_, this.argumentNodes5_};
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                Object argumentNodes3Value_ = this.argumentNodes3_.execute(frameValue);
                Object argumentNodes4Value_ = this.argumentNodes4_.execute(frameValue);
                Object argumentNodes5Value_ = this.argumentNodes5_.execute(frameValue);
                if ((state_0 & 3) != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (RubyTypesGen.isImplicitLong((state_0 & 0xC) >>> 2, argumentNodes4Value_)) {
                        long argumentNodes4Value__ = RubyTypesGen.asImplicitLong((state_0 & 0xC) >>> 2, argumentNodes4Value_);
                        if (RubyTypesGen.isImplicitLong((state_0 & 0x30) >>> 4, argumentNodes5Value_)) {
                            ThreadManager.BlockingCallInterruptible blockingCallInterruptible__;
                            long argumentNodes5Value__ = RubyTypesGen.asImplicitLong((state_0 & 0x30) >>> 4, argumentNodes5Value_);
                            if ((state_0 & 1) != 0) {
                                Call0Data s0_ = this.call0_cache;
                                while (s0_ != null) {
                                    if (s0_.receivers_.accepts(argumentNodes1Value_)) {
                                        Call0Data node__ = s0_;
                                        return ThreadNodes.CallWithUnblockingFunctionNode.call(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_, argumentNodes4Value__, argumentNodes5Value__, s0_.receivers_, INLINED_CALL0_TRANSLATE_INTEROP_EXCEPTION_NODE_, node__, s0_.blockingCallInterruptible_);
                                    }
                                    s0_ = s0_.next_;
                                }
                            }
                            if ((state_0 & 2) != 0 && (blockingCallInterruptible__ = this.call1_blockingCallInterruptible_) != null) {
                                return this.call1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_, argumentNodes4Value__, argumentNodes5Value__, blockingCallInterruptible__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_, argumentNodes4Value_, argumentNodes5Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object call1Boundary(int state_0, RubyThread argumentNodes0Value__, Object argumentNodes1Value_, Object argumentNodes2Value_, Object argumentNodes3Value_, long argumentNodes4Value__, long argumentNodes5Value__, ThreadManager.BlockingCallInterruptible blockingCallInterruptible__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary receivers__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(argumentNodes1Value_);
                    CallWithUnblockingFunctionNodeGen node__ = this;
                    Object object = ThreadNodes.CallWithUnblockingFunctionNode.call(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, argumentNodes3Value_, argumentNodes4Value__, argumentNodes5Value__, receivers__, INLINED_CALL1_TRANSLATE_INTEROP_EXCEPTION_NODE_, node__, blockingCallInterruptible__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * Exception decompiling
             */
            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value, Object argumentNodes3Value, Object argumentNodes4Value, Object argumentNodes5Value) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 7[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @GeneratedBy(value=ThreadNodes.CallWithUnblockingFunctionNode.class)
            @DenyReplace
            private static final class Call0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Call0Data next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int call0_state_0_;
                @Node.Child
                InteropLibrary receivers_;
                @CompilerDirectives.CompilationFinal
                ThreadManager.BlockingCallInterruptible blockingCallInterruptible_;

                Call0Data(Call0Data next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ListNode.class)
    public static final class ListNodeFactory
    implements NodeFactory<ThreadNodes.ListNode> {
        private static final ListNodeFactory LIST_NODE_FACTORY_INSTANCE = new ListNodeFactory();

        private ListNodeFactory() {
        }

        public Class<ThreadNodes.ListNode> getNodeClass() {
            return ThreadNodes.ListNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ListNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ListNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ListNode> getInstance() {
            return LIST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ListNode create(RubyNode[] argumentNodes) {
            return new ListNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ListNode.class)
        public static final class ListNodeGen
        extends ThreadNodes.ListNode {
            private ListNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadLocalVariablesPrimitiveNode.class)
    public static final class ThreadLocalVariablesPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadLocalVariablesPrimitiveNode> {
        private static final ThreadLocalVariablesPrimitiveNodeFactory THREAD_LOCAL_VARIABLES_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadLocalVariablesPrimitiveNodeFactory();

        private ThreadLocalVariablesPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadLocalVariablesPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadLocalVariablesPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadLocalVariablesPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadLocalVariablesPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadLocalVariablesPrimitiveNode> getInstance() {
            return THREAD_LOCAL_VARIABLES_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadLocalVariablesPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadLocalVariablesPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadLocalVariablesPrimitiveNode.class)
        public static final class ThreadLocalVariablesPrimitiveNodeGen
        extends ThreadNodes.ThreadLocalVariablesPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadLocalVariablesPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.threadLocalVariables(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyHash executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.threadLocalVariables(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadRandomizerPrimitiveNode.class)
    public static final class ThreadRandomizerPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadRandomizerPrimitiveNode> {
        private static final ThreadRandomizerPrimitiveNodeFactory THREAD_RANDOMIZER_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadRandomizerPrimitiveNodeFactory();

        private ThreadRandomizerPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadRandomizerPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadRandomizerPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadRandomizerPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadRandomizerPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadRandomizerPrimitiveNode> getInstance() {
            return THREAD_RANDOMIZER_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadRandomizerPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadRandomizerPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadRandomizerPrimitiveNode.class)
        public static final class ThreadRandomizerPrimitiveNodeGen
        extends ThreadNodes.ThreadRandomizerPrimitiveNode {
            private ThreadRandomizerPrimitiveNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.randomizer();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadRecursiveObjectsPrimitiveNode.class)
    public static final class ThreadRecursiveObjectsPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadRecursiveObjectsPrimitiveNode> {
        private static final ThreadRecursiveObjectsPrimitiveNodeFactory THREAD_RECURSIVE_OBJECTS_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadRecursiveObjectsPrimitiveNodeFactory();

        private ThreadRecursiveObjectsPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadRecursiveObjectsPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadRecursiveObjectsPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadRecursiveObjectsPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadRecursiveObjectsPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadRecursiveObjectsPrimitiveNode> getInstance() {
            return THREAD_RECURSIVE_OBJECTS_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadRecursiveObjectsPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadRecursiveObjectsPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadRecursiveObjectsPrimitiveNode.class)
        public static final class ThreadRecursiveObjectsPrimitiveNodeGen
        extends ThreadNodes.ThreadRecursiveObjectsPrimitiveNode {
            private ThreadRecursiveObjectsPrimitiveNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.recursiveObjects();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadDetectRecursionSingleNode.class)
    public static final class ThreadDetectRecursionSingleNodeFactory
    implements NodeFactory<ThreadNodes.ThreadDetectRecursionSingleNode> {
        private static final ThreadDetectRecursionSingleNodeFactory THREAD_DETECT_RECURSION_SINGLE_NODE_FACTORY_INSTANCE = new ThreadDetectRecursionSingleNodeFactory();

        private ThreadDetectRecursionSingleNodeFactory() {
        }

        public Class<ThreadNodes.ThreadDetectRecursionSingleNode> getNodeClass() {
            return ThreadNodes.ThreadDetectRecursionSingleNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadDetectRecursionSingleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadDetectRecursionSingleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadDetectRecursionSingleNode> getInstance() {
            return THREAD_DETECT_RECURSION_SINGLE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadDetectRecursionSingleNode create(RubyNode[] argumentNodes) {
            return new ThreadDetectRecursionSingleNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadDetectRecursionSingleNode.class)
        public static final class ThreadDetectRecursionSingleNodeGen
        extends ThreadNodes.ThreadDetectRecursionSingleNode {
            private static final InlineSupport.StateField STATE_0_ThreadDetectRecursionSingleNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedConditionProfile INLINED_INSERTED_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThreadDetectRecursionSingleNode_UPDATER.subUpdater(1, 2)}));
            private static final CallBlockNode INLINED_YIELD_NODE_ = CallBlockNodeGen.inline(InlineSupport.InlineTarget.create(CallBlockNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThreadDetectRecursionSingleNode_UPDATER.subUpdater(3, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"yieldNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node yieldNode__field2_;

            private ThreadDetectRecursionSingleNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes1Value_ instanceof RubyProc) {
                    RubyProc argumentNodes1Value__ = (RubyProc)argumentNodes1Value_;
                    return this.detectRecursionSingle(argumentNodes0Value_, argumentNodes1Value__, INLINED_INSERTED_PROFILE_, INLINED_YIELD_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes1Value instanceof RubyProc) {
                    RubyProc argumentNodes1Value_ = (RubyProc)argumentNodes1Value;
                    this.state_0_ = state_0 |= 1;
                    return this.detectRecursionSingle(argumentNodes0Value, argumentNodes1Value_, INLINED_INSERTED_PROFILE_, INLINED_YIELD_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode.class)
    public static final class ThreadGetReportOnExceptionPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode> {
        private static final ThreadGetReportOnExceptionPrimitiveNodeFactory THREAD_GET_REPORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadGetReportOnExceptionPrimitiveNodeFactory();

        private ThreadGetReportOnExceptionPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetReportOnExceptionPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode> getInstance() {
            return THREAD_GET_REPORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadGetReportOnExceptionPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode.class)
        public static final class ThreadGetReportOnExceptionPrimitiveNodeGen
        extends ThreadNodes.ThreadGetReportOnExceptionPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadGetReportOnExceptionPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.getReportOnException(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getReportOnException(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode.class)
    public static final class ThreadSetReportOnExceptionPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode> {
        private static final ThreadSetReportOnExceptionPrimitiveNodeFactory THREAD_SET_REPORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadSetReportOnExceptionPrimitiveNodeFactory();

        private ThreadSetReportOnExceptionPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetReportOnExceptionPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode> getInstance() {
            return THREAD_SET_REPORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadSetReportOnExceptionPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode.class)
        public static final class ThreadSetReportOnExceptionPrimitiveNodeGen
        extends ThreadNodes.ThreadSetReportOnExceptionPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadSetReportOnExceptionPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Boolean) {
                        boolean argumentNodes1Value__ = (Boolean)argumentNodes1Value_;
                        return this.setReportOnException(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyThread executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Boolean) {
                        boolean argumentNodes1Value_ = (Boolean)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.setReportOnException(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode.class)
    public static final class ThreadGetAbortOnExceptionPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode> {
        private static final ThreadGetAbortOnExceptionPrimitiveNodeFactory THREAD_GET_ABORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadGetAbortOnExceptionPrimitiveNodeFactory();

        private ThreadGetAbortOnExceptionPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetAbortOnExceptionPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode> getInstance() {
            return THREAD_GET_ABORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadGetAbortOnExceptionPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode.class)
        public static final class ThreadGetAbortOnExceptionPrimitiveNodeGen
        extends ThreadNodes.ThreadGetAbortOnExceptionPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadGetAbortOnExceptionPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.getAbortOnException(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getAbortOnException(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode.class)
    public static final class ThreadSetAbortOnExceptionPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode> {
        private static final ThreadSetAbortOnExceptionPrimitiveNodeFactory THREAD_SET_ABORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadSetAbortOnExceptionPrimitiveNodeFactory();

        private ThreadSetAbortOnExceptionPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetAbortOnExceptionPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode> getInstance() {
            return THREAD_SET_ABORT_ON_EXCEPTION_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadSetAbortOnExceptionPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode.class)
        public static final class ThreadSetAbortOnExceptionPrimitiveNodeGen
        extends ThreadNodes.ThreadSetAbortOnExceptionPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadSetAbortOnExceptionPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Boolean) {
                        boolean argumentNodes1Value__ = (Boolean)argumentNodes1Value_;
                        return this.setAbortOnException(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private RubyThread executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Boolean) {
                        boolean argumentNodes1Value_ = (Boolean)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.setAbortOnException(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadRaisePrimitiveNode.class)
    public static final class ThreadRaisePrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadRaisePrimitiveNode> {
        private static final ThreadRaisePrimitiveNodeFactory THREAD_RAISE_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadRaisePrimitiveNodeFactory();

        private ThreadRaisePrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadRaisePrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadRaisePrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadRaisePrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadRaisePrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadRaisePrimitiveNode> getInstance() {
            return THREAD_RAISE_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadRaisePrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadRaisePrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadRaisePrimitiveNode.class)
        public static final class ThreadRaisePrimitiveNodeGen
        extends ThreadNodes.ThreadRaisePrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadRaisePrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubyException) {
                        RubyException argumentNodes1Value__ = (RubyException)argumentNodes1Value_;
                        return this.raise(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubyException) {
                        RubyException argumentNodes1Value_ = (RubyException)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.raise(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSourceLocationNode.class)
    public static final class ThreadSourceLocationNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSourceLocationNode> {
        private static final ThreadSourceLocationNodeFactory THREAD_SOURCE_LOCATION_NODE_FACTORY_INSTANCE = new ThreadSourceLocationNodeFactory();

        private ThreadSourceLocationNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSourceLocationNode> getNodeClass() {
            return ThreadNodes.ThreadSourceLocationNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadSourceLocationNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSourceLocationNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSourceLocationNode> getInstance() {
            return THREAD_SOURCE_LOCATION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadSourceLocationNode create(RubyNode[] argumentNodes) {
            return new ThreadSourceLocationNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSourceLocationNode.class)
        public static final class ThreadSourceLocationNodeGen
        extends ThreadNodes.ThreadSourceLocationNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadSourceLocationNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.sourceLocation(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyString executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.sourceLocation(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadNameNode.class)
    public static final class ThreadNameNodeFactory
    implements NodeFactory<ThreadNodes.ThreadNameNode> {
        private static final ThreadNameNodeFactory THREAD_NAME_NODE_FACTORY_INSTANCE = new ThreadNameNodeFactory();

        private ThreadNameNodeFactory() {
        }

        public Class<ThreadNodes.ThreadNameNode> getNodeClass() {
            return ThreadNodes.ThreadNameNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadNameNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadNameNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadNameNode> getInstance() {
            return THREAD_NAME_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadNameNode create(RubyNode[] argumentNodes) {
            return new ThreadNameNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadNameNode.class)
        public static final class ThreadNameNodeGen
        extends ThreadNodes.ThreadNameNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadNameNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.getName(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getName(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetNamePrimitiveNode.class)
    public static final class ThreadSetNamePrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetNamePrimitiveNode> {
        private static final ThreadSetNamePrimitiveNodeFactory THREAD_SET_NAME_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadSetNamePrimitiveNodeFactory();

        private ThreadSetNamePrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetNamePrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetNamePrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetNamePrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetNamePrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetNamePrimitiveNode> getInstance() {
            return THREAD_SET_NAME_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadSetNamePrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadSetNamePrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetNamePrimitiveNode.class)
        public static final class ThreadSetNamePrimitiveNodeGen
        extends ThreadNodes.ThreadSetNamePrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadSetNamePrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.setName(argumentNodes0Value__, argumentNodes1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.setName(argumentNodes0Value_, argumentNodes1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetPriorityPrimitiveNode.class)
    public static final class ThreadGetPriorityPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetPriorityPrimitiveNode> {
        private static final ThreadGetPriorityPrimitiveNodeFactory THREAD_GET_PRIORITY_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadGetPriorityPrimitiveNodeFactory();

        private ThreadGetPriorityPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetPriorityPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadGetPriorityPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetPriorityPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetPriorityPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetPriorityPrimitiveNode> getInstance() {
            return THREAD_GET_PRIORITY_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadGetPriorityPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadGetPriorityPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetPriorityPrimitiveNode.class)
        public static final class ThreadGetPriorityPrimitiveNodeGen
        extends ThreadNodes.ThreadGetPriorityPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadGetPriorityPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.getPriority(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private int executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getPriority(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
    public static final class ThreadSetPriorityPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetPriorityPrimitiveNode> {
        private static final ThreadSetPriorityPrimitiveNodeFactory THREAD_SET_PRIORITY_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadSetPriorityPrimitiveNodeFactory();

        private ThreadSetPriorityPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetPriorityPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetPriorityPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetPriorityPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetPriorityPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetPriorityPrimitiveNode> getInstance() {
            return THREAD_SET_PRIORITY_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadSetPriorityPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadSetPriorityPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetPriorityPrimitiveNode.class)
        public static final class ThreadSetPriorityPrimitiveNodeGen
        extends ThreadNodes.ThreadSetPriorityPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadSetPriorityPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Integer) {
                        int argumentNodes1Value__ = (Integer)argumentNodes1Value_;
                        return this.getPriority(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private int executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Integer) {
                        int argumentNodes1Value_ = (Integer)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.getPriority(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadSetGroupPrimitiveNode.class)
    public static final class ThreadSetGroupPrimitiveNodeFactory
    implements NodeFactory<ThreadNodes.ThreadSetGroupPrimitiveNode> {
        private static final ThreadSetGroupPrimitiveNodeFactory THREAD_SET_GROUP_PRIMITIVE_NODE_FACTORY_INSTANCE = new ThreadSetGroupPrimitiveNodeFactory();

        private ThreadSetGroupPrimitiveNodeFactory() {
        }

        public Class<ThreadNodes.ThreadSetGroupPrimitiveNode> getNodeClass() {
            return ThreadNodes.ThreadSetGroupPrimitiveNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadSetGroupPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadSetGroupPrimitiveNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadSetGroupPrimitiveNode> getInstance() {
            return THREAD_SET_GROUP_PRIMITIVE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadSetGroupPrimitiveNode create(RubyNode[] argumentNodes) {
            return new ThreadSetGroupPrimitiveNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadSetGroupPrimitiveNode.class)
        public static final class ThreadSetGroupPrimitiveNodeGen
        extends ThreadNodes.ThreadSetGroupPrimitiveNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadSetGroupPrimitiveNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.setGroup(argumentNodes0Value__, argumentNodes1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.setGroup(argumentNodes0Value_, argumentNodes1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetReturnCodeNode.class)
    public static final class ThreadGetReturnCodeNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetReturnCodeNode> {
        private static final ThreadGetReturnCodeNodeFactory THREAD_GET_RETURN_CODE_NODE_FACTORY_INSTANCE = new ThreadGetReturnCodeNodeFactory();

        private ThreadGetReturnCodeNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetReturnCodeNode> getNodeClass() {
            return ThreadNodes.ThreadGetReturnCodeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of();
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetReturnCodeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetReturnCodeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetReturnCodeNode> getInstance() {
            return THREAD_GET_RETURN_CODE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadGetReturnCodeNode create(RubyNode[] argumentNodes) {
            return new ThreadGetReturnCodeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetReturnCodeNode.class)
        public static final class ThreadGetReturnCodeNodeGen
        extends ThreadNodes.ThreadGetReturnCodeNode {
            private ThreadGetReturnCodeNodeGen(RubyNode[] argumentNodes) {
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[0];
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.getExitCode();
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.SetThreadLocalReturnCodeNode.class)
    public static final class SetThreadLocalReturnCodeNodeFactory
    implements NodeFactory<ThreadNodes.SetThreadLocalReturnCodeNode> {
        private static final SetThreadLocalReturnCodeNodeFactory SET_THREAD_LOCAL_RETURN_CODE_NODE_FACTORY_INSTANCE = new SetThreadLocalReturnCodeNodeFactory();

        private SetThreadLocalReturnCodeNodeFactory() {
        }

        public Class<ThreadNodes.SetThreadLocalReturnCodeNode> getNodeClass() {
            return ThreadNodes.SetThreadLocalReturnCodeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.SetThreadLocalReturnCodeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetThreadLocalReturnCodeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.SetThreadLocalReturnCodeNode> getInstance() {
            return SET_THREAD_LOCAL_RETURN_CODE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.SetThreadLocalReturnCodeNode create(RubyNode[] argumentNodes) {
            return new SetThreadLocalReturnCodeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.SetThreadLocalReturnCodeNode.class)
        public static final class SetThreadLocalReturnCodeNodeGen
        extends ThreadNodes.SetThreadLocalReturnCodeNode {
            @Node.Child
            private RubyNode argumentNodes0_;

            private SetThreadLocalReturnCodeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                return this.getException(argumentNodes0Value_);
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadGetFiberLocalsNode.class)
    public static final class ThreadGetFiberLocalsNodeFactory
    implements NodeFactory<ThreadNodes.ThreadGetFiberLocalsNode> {
        private static final ThreadGetFiberLocalsNodeFactory THREAD_GET_FIBER_LOCALS_NODE_FACTORY_INSTANCE = new ThreadGetFiberLocalsNodeFactory();

        private ThreadGetFiberLocalsNodeFactory() {
        }

        public Class<ThreadNodes.ThreadGetFiberLocalsNode> getNodeClass() {
            return ThreadNodes.ThreadGetFiberLocalsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadGetFiberLocalsNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadGetFiberLocalsNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadGetFiberLocalsNode> getInstance() {
            return THREAD_GET_FIBER_LOCALS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadGetFiberLocalsNode create(RubyNode[] argumentNodes) {
            return new ThreadGetFiberLocalsNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadGetFiberLocalsNode.class)
        public static final class ThreadGetFiberLocalsNodeGen
        extends ThreadNodes.ThreadGetFiberLocalsNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private ThreadGetFiberLocalsNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyThread) {
                    RubyThread argumentNodes0Value__ = (RubyThread)argumentNodes0Value_;
                    return this.getFiberLocals(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyBasicObject executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyThread) {
                    RubyThread argumentNodes0Value_ = (RubyThread)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.getFiberLocals(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ThreadRunBlockingSystemCallNode.class)
    public static final class ThreadRunBlockingSystemCallNodeFactory
    implements NodeFactory<ThreadNodes.ThreadRunBlockingSystemCallNode> {
        private static final ThreadRunBlockingSystemCallNodeFactory THREAD_RUN_BLOCKING_SYSTEM_CALL_NODE_FACTORY_INSTANCE = new ThreadRunBlockingSystemCallNodeFactory();

        private ThreadRunBlockingSystemCallNodeFactory() {
        }

        public Class<ThreadNodes.ThreadRunBlockingSystemCallNode> getNodeClass() {
            return ThreadNodes.ThreadRunBlockingSystemCallNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.ThreadRunBlockingSystemCallNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ThreadRunBlockingSystemCallNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.ThreadRunBlockingSystemCallNode> getInstance() {
            return THREAD_RUN_BLOCKING_SYSTEM_CALL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.ThreadRunBlockingSystemCallNode create(RubyNode[] argumentNodes) {
            return new ThreadRunBlockingSystemCallNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.ThreadRunBlockingSystemCallNode.class)
        public static final class ThreadRunBlockingSystemCallNodeGen
        extends ThreadNodes.ThreadRunBlockingSystemCallNode {
            private static final InlineSupport.StateField STATE_0_ThreadRunBlockingSystemCallNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final TranslateInteropExceptionNode INLINED_TRANSLATE_INTEROP_EXCEPTION_NODE_ = TranslateInteropExceptionNodeGen.inline(InlineSupport.InlineTarget.create(TranslateInteropExceptionNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThreadRunBlockingSystemCallNode_UPDATER.subUpdater(1, 8)}));
            private static final ForeignToRubyNode INLINED_FOREIGN_TO_RUBY_NODE_ = ForeignToRubyNodeGen.inline(InlineSupport.InlineTarget.create(ForeignToRubyNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ThreadRunBlockingSystemCallNode_UPDATER.subUpdater(9, 4)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private ArrayToObjectArrayNode arrayToObjectArrayNode_;
            @Node.Child
            private InteropLibrary receivers_;
            @CompilerDirectives.CompilationFinal
            private ThreadManager.BlockingCallInterruptible blockingCallInterruptible_;

            private ThreadRunBlockingSystemCallNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes1Value_ instanceof RubyArray) {
                    ThreadManager.BlockingCallInterruptible blockingCallInterruptible__;
                    InteropLibrary receivers__;
                    RubyArray argumentNodes1Value__ = (RubyArray)argumentNodes1Value_;
                    ArrayToObjectArrayNode arrayToObjectArrayNode__ = this.arrayToObjectArrayNode_;
                    if (arrayToObjectArrayNode__ != null && (receivers__ = this.receivers_) != null && (blockingCallInterruptible__ = this.blockingCallInterruptible_) != null) {
                        return this.runBlockingSystemCall(argumentNodes0Value_, argumentNodes1Value__, arrayToObjectArrayNode__, receivers__, INLINED_TRANSLATE_INTEROP_EXCEPTION_NODE_, blockingCallInterruptible__, INLINED_FOREIGN_TO_RUBY_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes1Value instanceof RubyArray) {
                    RubyArray argumentNodes1Value_ = (RubyArray)argumentNodes1Value;
                    ArrayToObjectArrayNode arrayToObjectArrayNode__ = (ArrayToObjectArrayNode)this.insert(ArrayToObjectArrayNode.create());
                    Objects.requireNonNull(arrayToObjectArrayNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.arrayToObjectArrayNode_ = arrayToObjectArrayNode__;
                    InteropLibrary receivers__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(receivers__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.receivers_ = receivers__;
                    VarHandle.storeStoreFence();
                    this.blockingCallInterruptible_ = new ThreadManager.BlockingCallInterruptible(this, receivers__, INLINED_TRANSLATE_INTEROP_EXCEPTION_NODE_);
                    this.state_0_ = state_0 |= 1;
                    return this.runBlockingSystemCall(argumentNodes0Value, argumentNodes1Value_, arrayToObjectArrayNode__, receivers__, INLINED_TRANSLATE_INTEROP_EXCEPTION_NODE_, this.blockingCallInterruptible_, INLINED_FOREIGN_TO_RUBY_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.EachCallerLocationNode.class)
    public static final class EachCallerLocationNodeFactory
    implements NodeFactory<ThreadNodes.EachCallerLocationNode> {
        private static final EachCallerLocationNodeFactory EACH_CALLER_LOCATION_NODE_FACTORY_INSTANCE = new EachCallerLocationNodeFactory();

        private EachCallerLocationNodeFactory() {
        }

        public Class<ThreadNodes.EachCallerLocationNode> getNodeClass() {
            return ThreadNodes.EachCallerLocationNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ThreadNodes.EachCallerLocationNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachCallerLocationNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadNodes.EachCallerLocationNode> getInstance() {
            return EACH_CALLER_LOCATION_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadNodes.EachCallerLocationNode create(RubyNode[] argumentNodes) {
            return new EachCallerLocationNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ThreadNodes.EachCallerLocationNode.class)
        public static final class EachCallerLocationNodeGen
        extends ThreadNodes.EachCallerLocationNode {
            private static final InlineSupport.StateField STATE_0_EachCallerLocationNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final CallBlockNode INLINED_EACH_CALLER_LOCATION0_YIELD_NODE_ = CallBlockNodeGen.inline(InlineSupport.InlineTarget.create(CallBlockNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EachCallerLocationNode_UPDATER.subUpdater(2, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"eachCallerLocation0_yieldNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"eachCallerLocation0_yieldNode__field2_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node eachCallerLocation0_yieldNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node eachCallerLocation0_yieldNode__field2_;

            private EachCallerLocationNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyProc) {
                        RubyProc argumentNodes0Value__ = (RubyProc)argumentNodes0Value_;
                        return this.eachCallerLocation(frameValue, argumentNodes0Value__, INLINED_EACH_CALLER_LOCATION0_YIELD_NODE_);
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes0Value_)) {
                        Nil argumentNodes0Value__ = RubyTypes.asNil(argumentNodes0Value_);
                        return this.eachCallerLocation(frameValue, argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, argumentNodes0Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyProc) {
                    RubyProc argumentNodes0Value_ = (RubyProc)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.eachCallerLocation(frameValue, argumentNodes0Value_, INLINED_EACH_CALLER_LOCATION0_YIELD_NODE_);
                }
                if (RubyTypes.isNil(argumentNodes0Value)) {
                    Nil argumentNodes0Value_ = RubyTypes.asNil(argumentNodes0Value);
                    this.state_0_ = state_0 |= 2;
                    return this.eachCallerLocation(frameValue, argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }
        }
    }
}

