/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import org.truffleruby.RubyLanguage;

@ExportLibrary(value=InteropLibrary.class)
public final class TopScopeObject
implements TruffleObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final String[] NAMES = new String[]{"interactive local variables", "global variables", "main object"};
    static final int LIMIT = NAMES.length;
    private final Object[] objects;
    private final int scopeIndex;

    public TopScopeObject(Object[] objects) {
        this(objects, 0);
    }

    private TopScopeObject(Object[] objects, int index) {
        assert (objects.length == NAMES.length);
        this.objects = objects;
        this.scopeIndex = index;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return RubyLanguage.class;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return NAMES[this.scopeIndex];
    }

    @ExportMessage
    boolean hasScopeParent() {
        return this.scopeIndex < NAMES.length - 1;
    }

    @ExportMessage
    Object getScopeParent() throws UnsupportedMessageException {
        if (this.scopeIndex < NAMES.length - 1) {
            return new TopScopeObject(this.objects, this.scopeIndex + 1);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) throws UnsupportedMessageException {
        int length = NAMES.length;
        Object[] keys = new Object[length - this.scopeIndex];
        for (int i = this.scopeIndex; i < length; ++i) {
            keys[i - this.scopeIndex] = interop.getMembers(this.objects[i]);
        }
        return new MergedPropertyNames(keys);
    }

    @ExportMessage
    boolean isMemberReadable(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            if (!interop.isMemberReadable(this.objects[i], member)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    Object readMember(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) throws UnknownIdentifierException, UnsupportedMessageException {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (!interop.isMemberReadable(scope, member)) continue;
            return interop.readMember(scope, member);
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    boolean isMemberModifiable(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (!interop.isMemberModifiable(scope, member)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    boolean isMemberInsertable(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberInsertable(scope, member)) {
                return true;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            return false;
        }
        return false;
    }

    @ExportMessage
    boolean hasMemberReadSideEffects(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (!interop.isMemberReadable(scope, member)) continue;
            return interop.hasMemberReadSideEffects(scope, member);
        }
        return false;
    }

    @ExportMessage
    boolean hasMemberWriteSideEffects(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (!interop.isMemberWritable(scope, member)) continue;
            return interop.hasMemberWriteSideEffects(scope, member);
        }
        return false;
    }

    @ExportMessage
    void writeMember(String member, Object value, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) throws UnknownIdentifierException, UnsupportedMessageException, UnsupportedTypeException {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberModifiable(scope, member) || interop.isMemberInsertable(scope, member)) {
                interop.writeMember(scope, member, value);
                return;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            throw UnsupportedMessageException.create();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isMemberRemovable(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberRemovable(scope, member)) {
                return true;
            }
            if (!interop.isMemberExisting(scope, member)) continue;
            return false;
        }
        return false;
    }

    @ExportMessage
    void removeMember(String member, @CachedLibrary(limit="LIMIT") @Cached.Shared InteropLibrary interop) throws UnsupportedMessageException, UnknownIdentifierException {
        int length = NAMES.length;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.objects[i];
            if (interop.isMemberRemovable(scope, member)) {
                interop.removeMember(scope, member);
                return;
            }
            if (interop.isMemberExisting(scope, member)) break;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MergedPropertyNames
    implements TruffleObject {
        private final Object[] keys;
        private final long[] size;

        private MergedPropertyNames(Object[] keys) throws UnsupportedMessageException {
            this.keys = keys;
            this.size = new long[keys.length];
            long s = 0L;
            InteropLibrary interop = InteropLibrary.getUncached();
            for (int i = 0; i < keys.length; ++i) {
                this.size[i] = s += interop.getArraySize(keys[i]);
            }
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.size[this.size.length - 1];
        }

        @ExportMessage
        boolean isArrayElementReadable(long index, @CachedLibrary(limit="5") @Cached.Shared InteropLibrary interop) {
            if (index >= 0L) {
                for (int i = 0; i < this.keys.length; ++i) {
                    if (index >= this.size[i]) continue;
                    long start = i == 0 ? 0L : this.size[i - 1];
                    return interop.isArrayElementReadable(this.keys[i], index - start);
                }
            }
            return false;
        }

        @ExportMessage
        Object readArrayElement(long index, @CachedLibrary(limit="5") @Cached.Shared InteropLibrary interop) throws InvalidArrayIndexException, UnsupportedMessageException {
            if (index >= 0L) {
                for (int i = 0; i < this.keys.length; ++i) {
                    if (index >= this.size[i]) continue;
                    long start = i == 0 ? 0L : this.size[i - 1];
                    return interop.readArrayElement(this.keys[i], index - start);
                }
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }
}

