/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.interop.ForeignToRubyNode;
import org.truffleruby.interop.ForeignToRubyNodeGen;
import org.truffleruby.language.RubyBaseNode;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
@ReportPolymorphism
public abstract class ForeignToRubyArgumentsNode
extends RubyBaseNode {
    public abstract Object[] executeConvert(Node var1, Object[] var2);

    @ExplodeLoop
    @Specialization(guards={"args.length == cachedArgsLength", "cachedArgsLength <= MAX_EXPLODE_SIZE"}, limit="getLimit()")
    static Object[] convertCached(Object[] args, @Cached(value="args.length") int cachedArgsLength, @Cached(value="foreignToRubyNodes(cachedArgsLength)") ForeignToRubyNode[] foreignToRubyNodes) {
        Object[] convertedArgs = new Object[cachedArgsLength];
        for (int n = 0; n < cachedArgsLength; ++n) {
            convertedArgs[n] = foreignToRubyNodes[n].executeCached(args[n]);
        }
        return convertedArgs;
    }

    @Specialization(replaces={"convertCached"})
    static Object[] convertUncached(Node node, Object[] args, @Cached ForeignToRubyNode foreignToRubyNode) {
        Object[] convertedArgs = new Object[args.length];
        for (int n = 0; n < args.length; ++n) {
            convertedArgs[n] = foreignToRubyNode.execute(node, args[n]);
        }
        return convertedArgs;
    }

    protected static ForeignToRubyNode[] foreignToRubyNodes(int size) {
        ForeignToRubyNode[] foreignToRubyNodes = new ForeignToRubyNode[size];
        for (int i = 0; i < foreignToRubyNodes.length; ++i) {
            foreignToRubyNodes[i] = ForeignToRubyNodeGen.create();
        }
        return foreignToRubyNodes;
    }

    protected int getLimit() {
        return this.getLanguage().options.INTEROP_CONVERT_CACHE;
    }
}

