/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateInline
@GenerateCached(value=false)
public abstract class SymbolToByteOrderNode
extends RubyBaseNode {
    public abstract ByteOrder execute(Node var1, Object var2);

    @Specialization(guards={"symbol == coreSymbols().BIG"})
    static ByteOrder symbolToByteOrderBig(RubySymbol symbol) {
        return ByteOrder.BIG_ENDIAN;
    }

    @Specialization(guards={"symbol == coreSymbols().LITTLE"})
    static ByteOrder symbolToByteOrderLittle(RubySymbol symbol) {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Specialization(guards={"symbol == coreSymbols().NATIVE"})
    static ByteOrder symbolToByteOrderNative(RubySymbol symbol) {
        return ByteOrder.nativeOrder();
    }

    @Fallback
    static ByteOrder invalidByteOrder(Node node, Object value) {
        throw new RaiseException(SymbolToByteOrderNode.getContext(node), SymbolToByteOrderNode.coreExceptions(node).argumentError("byte order must be :big, :little, or :native symbol", node));
    }
}

