/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class SetTopLevelBindingNode
extends RubyContextSourceNode {
    @Override
    public Object execute(VirtualFrame frame) {
        MaterializedFrame mainScriptFrame = frame.materialize();
        this.updateTopLevelBindingFrame(mainScriptFrame);
        return nil;
    }

    @CompilerDirectives.TruffleBoundary
    private void updateTopLevelBindingFrame(MaterializedFrame mainScriptFrame) {
        ModuleFields fields = this.coreLibrary().objectClass.fields;
        RubyBinding toplevelBinding = (RubyBinding)fields.getConstant("TOPLEVEL_BINDING").getValue();
        BindingNodes.insertAncestorFrame(toplevelBinding, mainScriptFrame);
    }

    @Override
    public RubyNode cloneUninitialized() {
        SetTopLevelBindingNode copy = new SetTopLevelBindingNode();
        return copy.copyFlags(this);
    }
}

