/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.parser.ArgumentDescriptor;
import org.truffleruby.parser.ArgumentType;

public final class ArgumentDescriptorUtils {
    @CompilerDirectives.TruffleBoundary
    public static RubyArray argumentDescriptorsToParameters(RubyLanguage language, RubyContext context, ArgumentDescriptor[] argsDesc, boolean isLambda) {
        Object[] params = new Object[argsDesc.length];
        for (int i = 0; i < argsDesc.length; ++i) {
            params[i] = ArgumentDescriptorUtils.toArray(language, context, argsDesc[i], isLambda);
        }
        return ArrayHelpers.createArray(context, language, params);
    }

    private static RubyArray toArray(RubyLanguage language, RubyContext context, ArgumentDescriptor argDesc, boolean isLambda) {
        if (argDesc.type == ArgumentType.req && !isLambda) {
            return ArgumentDescriptorUtils.toArray(language, context, ArgumentType.opt, argDesc.name);
        }
        return ArgumentDescriptorUtils.toArray(language, context, argDesc.type, argDesc.name);
    }

    private static RubyArray toArray(RubyLanguage language, RubyContext context, ArgumentType argType, String name) {
        RubySymbol typeSymbol = language.getSymbol(argType.symbolicName);
        Object[] store = argType == ArgumentType.anonrest ? new Object[]{typeSymbol, language.coreSymbols.MULTIPLY} : (argType == ArgumentType.anonkeyrest ? new Object[]{typeSymbol, language.coreSymbols.POW} : (argType == ArgumentType.rest && name.equals("%forward_rest") ? new Object[]{typeSymbol, language.coreSymbols.MULTIPLY} : (argType == ArgumentType.keyrest && name.equals("%forward_kwrest") ? new Object[]{typeSymbol, language.coreSymbols.POW} : (argType == ArgumentType.block && name.equals("%forward_block") ? new Object[]{typeSymbol, language.coreSymbols.AMPERSAND} : (argType.anonymous || name == null ? new Object[]{typeSymbol} : new Object[]{typeSymbol, language.getSymbol(name)})))));
        return ArrayHelpers.createArray(context, language, store);
    }
}

