/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ReadUserKeywordsHashNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.Arity;

public final class MissingKeywordArgumentNode
extends RubyContextSourceNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final RubySymbol[] requiredKeywords;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    @Node.Child
    private HashStoreLibrary hashes;

    public MissingKeywordArgumentNode(RubyLanguage language, Arity arity) {
        this(MissingKeywordArgumentNode.requiredKeywordsAsSymbols(language, arity));
    }

    private MissingKeywordArgumentNode(RubySymbol[] requiredKeywords) {
        this.requiredKeywords = requiredKeywords;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode();
        this.hashes = (HashStoreLibrary)this.insert((Node)HashStoreLibrary.createDispatched());
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyHash actualKeywords = this.readUserKeywordsHashNode.execute(frame);
        throw new RaiseException(this.getContext(), this.missingKeywordsError(actualKeywords));
    }

    private static RubySymbol[] requiredKeywordsAsSymbols(RubyLanguage language, Arity arity) {
        String[] requiredKeywords = arity.getRequiredKeywordArguments();
        RubySymbol[] symbols = new RubySymbol[requiredKeywords.length];
        for (int i = 0; i < requiredKeywords.length; ++i) {
            symbols[i] = language.getSymbol(requiredKeywords[i]);
        }
        return symbols;
    }

    @CompilerDirectives.TruffleBoundary
    private RubyException missingKeywordsError(RubyHash actualKeywords) {
        Object[] missingKeywords = this.findMissingKeywordArguments(actualKeywords);
        return this.coreExceptions().argumentErrorMissingKeywords(missingKeywords, this);
    }

    @CompilerDirectives.TruffleBoundary
    private Object[] findMissingKeywordArguments(RubyHash actualKeywords) {
        if (actualKeywords == null) {
            return this.requiredKeywords;
        }
        ArrayList actualKeywordsAsList = new ArrayList();
        this.hashes.eachEntry(actualKeywords.store, actualKeywords, (index, key, value, state) -> ((ArrayList)state).add(key), actualKeywordsAsList);
        return ArrayUtils.subtract(this.requiredKeywords, actualKeywordsAsList.toArray());
    }

    @Override
    public RubyNode cloneUninitialized() {
        MissingKeywordArgumentNode copy = new MissingKeywordArgumentNode(this.requiredKeywords);
        return copy.copyFlags(this);
    }
}

