/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

public final class ShouldDestructureNode
extends RubyContextSourceNode {
    @Node.Child
    private DispatchNode respondToToAry;
    private final boolean keywordArguments;
    private final BranchProfile checkIsArrayProfile = BranchProfile.create();

    public ShouldDestructureNode(boolean keywordArguments) {
        this.keywordArguments = keywordArguments;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object respondToCallResult;
        if (RubyArguments.getDescriptor((Frame)frame) instanceof KeywordArgumentsDescriptor) {
            return false;
        }
        if (RubyArguments.getPositionalArgumentsCount((Frame)frame, this.keywordArguments) != 1) {
            return false;
        }
        this.checkIsArrayProfile.enter();
        Object singleArgument = RubyArguments.getArgument((Frame)frame, 0);
        if (RubyGuards.isRubyArray(singleArgument)) {
            return true;
        }
        if (this.respondToToAry == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.respondToToAry = (DispatchNode)this.insert(DispatchNode.create());
        }
        if ((respondToCallResult = this.respondToToAry.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, singleArgument, "respond_to?", (Object)this.getLanguage().coreSymbols.TO_ARY)) == DispatchNode.MISSING) {
            return false;
        }
        assert (respondToCallResult instanceof Boolean);
        return (boolean)((Boolean)respondToCallResult);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ShouldDestructureNode copy = new ShouldDestructureNode(this.keywordArguments);
        return copy.copyFlags(this);
    }
}

