/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import org.truffleruby.RubyContext;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.control.RubyThrowable;

@ExportLibrary(value=InteropLibrary.class, delegateTo="exception")
public final class RaiseException
extends AbstractTruffleException
implements RubyThrowable {
    final RubyException exception;

    public RaiseException(RubyContext context, RubyException exception) {
        this(context, exception, null);
    }

    public RaiseException(RubyContext context, RubyException exception, Throwable cause) {
        super(null, cause, -1, exception.getLocation());
        this.exception = exception;
        Backtrace backtrace = exception.backtrace;
        if (backtrace != null) {
            backtrace.setRaiseException(this);
        }
        if (context.getOptions().BACKTRACE_ON_RAISE) {
            context.getDefaultBacktraceFormatter().printRubyExceptionOnEnvStderr("raise: ", this);
        }
    }

    public RaiseException(RaiseException copy, RubyException exception) {
        super((AbstractTruffleException)copy);
        this.exception = exception;
    }

    public RubyException getException() {
        return this.exception;
    }

    public String getMessage() {
        return ExceptionOperations.messageFieldToString(this.exception);
    }
}

