/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class ReadMatchReferenceNodes
extends RubyContextSourceNode {

    public static final class SetNamedVariablesMatchNode
    extends RubyContextSourceNode {
        @Node.Child
        private RubyNode matchDataNode;
        @Node.Child
        private RubyNode readMatchNode;
        @Node.Children
        private final RubyNode[] setters;
        @Node.Children
        private final RubyNode[] nilSetters;
        private final ConditionProfile matchNilProfile = ConditionProfile.create();

        public SetNamedVariablesMatchNode(RubyNode matchDataNode, RubyNode readMatchNode, RubyNode[] setters, RubyNode[] nilSetters) {
            this.matchDataNode = matchDataNode;
            this.readMatchNode = readMatchNode;
            this.setters = setters;
            this.nilSetters = nilSetters;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object matchResult = this.matchDataNode.execute(frame);
            Object match = this.readMatchNode.execute(frame);
            if (this.matchNilProfile.profile(match == nil)) {
                this.setNamedForNil(frame);
            } else {
                this.setNamedForNonNil(frame);
            }
            return matchResult;
        }

        @ExplodeLoop
        private void setNamedForNonNil(VirtualFrame frame) {
            for (int n = 0; n < this.setters.length; ++n) {
                this.setters[n].execute(frame);
            }
        }

        @ExplodeLoop
        private void setNamedForNil(VirtualFrame frame) {
            for (int n = 0; n < this.setters.length; ++n) {
                this.nilSetters[n].execute(frame);
            }
        }

        @Override
        public RubyNode cloneUninitialized() {
            SetNamedVariablesMatchNode copy = new SetNamedVariablesMatchNode(this.matchDataNode.cloneUninitialized(), this.readMatchNode.cloneUninitialized(), SetNamedVariablesMatchNode.cloneUninitialized(this.setters), SetNamedVariablesMatchNode.cloneUninitialized(this.nilSetters));
            return copy.copyFlags(this);
        }
    }

    public static final class ReadNthMatchNode
    extends RubyContextSourceNode {
        @Node.Child
        private RubyNode readMatchNode;
        @Node.Child
        private DispatchNode getIndexNode;
        private final int index;
        private final ConditionProfile matchNilProfile = ConditionProfile.create();

        public ReadNthMatchNode(RubyNode readMatchNode, int index) {
            this.readMatchNode = readMatchNode;
            this.index = index;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object match = this.readMatchNode.execute(frame);
            if (this.matchNilProfile.profile(match == nil)) {
                return nil;
            }
            return this.callGetIndex(frame, match, this.index);
        }

        private Object callGetIndex(VirtualFrame frame, Object match, int index) {
            if (this.getIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIndexNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.getIndexNode.call(match, "[]", index);
        }

        @Override
        public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
            if (this.execute(frame) == nil) {
                return nil;
            }
            return FrozenStrings.GLOBAL_VARIABLE;
        }

        @Override
        public RubyNode cloneUninitialized() {
            ReadNthMatchNode copy = new ReadNthMatchNode(this.readMatchNode.cloneUninitialized(), this.index);
            return copy.copyFlags(this);
        }
    }
}

