/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.BreakException;
import org.truffleruby.language.control.BreakID;

public final class CatchBreakNode
extends RubyContextSourceNode {
    private final boolean isWhile;
    private final BreakID breakID;
    @Node.Child
    private RubyNode body;
    private final CountingConditionProfile matchingBreakProfile = CountingConditionProfile.create();
    private final ConditionProfile anyBlockProfile;

    public CatchBreakNode(BreakID breakID, RubyNode body, boolean isWhile) {
        assert (breakID != BreakID.INVALID);
        this.isWhile = isWhile;
        this.breakID = breakID;
        this.body = body;
        this.anyBlockProfile = isWhile ? null : ConditionProfile.create();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (BreakException e) {
            if (this.matchingBreakProfile.profile(e.getBreakID() == this.breakID)) {
                return e.getResult();
            }
            if (!this.isWhile && this.anyBlockProfile.profile(e.getBreakID() == BreakID.ANY_BLOCK)) {
                return e.getResult();
            }
            throw e;
        }
    }

    @Override
    public RubyNode cloneUninitialized() {
        CatchBreakNode copy = new CatchBreakNode(this.breakID, this.body.cloneUninitialized(), this.isWhile);
        return copy.copyFlags(this);
    }
}

