/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;

public final class ModuleBodyDefinition {
    private final String name;
    private final SharedMethodInfo sharedMethodInfo;
    private final RootCallTarget callTarget;
    private final LexicalScope staticLexicalScope;
    private final Map<RubyModule, LexicalScope> dynamicLexicalScopes;

    public ModuleBodyDefinition(String name, SharedMethodInfo sharedMethodInfo, RootCallTarget callTarget, LexicalScope staticLexicalScope) {
        this.name = name;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTarget = callTarget;
        this.staticLexicalScope = staticLexicalScope;
        this.dynamicLexicalScopes = staticLexicalScope != null ? null : new ConcurrentHashMap();
    }

    public InternalMethod createMethod(VirtualFrame frame, RubyModule module, RubyBaseNode node) {
        LexicalScope parentLexicalScope = RubyArguments.getMethod((Frame)frame).getLexicalScope();
        LexicalScope lexicalScope = this.prepareLexicalScope(this.staticLexicalScope, parentLexicalScope, module, node);
        DeclarationContext declarationContext = new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.FixedDefaultDefinee(module), RubyArguments.getDeclarationContext((Frame)frame).getRefinements());
        return new InternalMethod(RubyContext.get(node), this.sharedMethodInfo, lexicalScope, declarationContext, this.name, module, Visibility.PUBLIC, false, null, null, this.callTarget, null);
    }

    @CompilerDirectives.TruffleBoundary
    private LexicalScope prepareLexicalScope(LexicalScope staticLexicalScope, LexicalScope parentLexicalScope, RubyModule module, RubyBaseNode node) {
        if (staticLexicalScope != null) {
            staticLexicalScope.unsafeSetLiveModule(module);
            return staticLexicalScope;
        }
        if (RubyLanguage.get((Node)node).singleContext) {
            return ConcurrentOperations.getOrCompute(this.dynamicLexicalScopes, module, k -> new LexicalScope(parentLexicalScope, module));
        }
        return new LexicalScope(parentLexicalScope, module);
    }

    public RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public String toString() {
        return StringUtils.format("ModuleBodyDefinition(name = %s, sharedMethodInfo = %s, callTarget = %s, staticLexicalScope = %s, dynamicLexicalScopes = %s)", this.name, this.sharedMethodInfo.toStringWithDetails(), this.callTarget, this.staticLexicalScope, this.dynamicLexicalScopes);
    }
}

