/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.klass.ClassNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.LookupForExistingModuleNode;

public final class DefineClassNode
extends RubyContextSourceNode {
    private final String name;
    @Node.Child
    private RubyNode superClassNode;
    @Node.Child
    private RubyNode lexicalParentModule;
    @Node.Child
    private LookupForExistingModuleNode lookupForExistingModuleNode;
    @Node.Child
    private DispatchNode inheritedNode;
    private final ConditionProfile needToDefineProfile = ConditionProfile.create();
    private final ConditionProfile noSuperClassSupplied = ConditionProfile.create();
    private final BranchProfile errorProfile = BranchProfile.create();

    public DefineClassNode(String name, RubyNode lexicalParent, RubyNode superClass) {
        this.name = name;
        this.lexicalParentModule = lexicalParent;
        this.superClassNode = superClass;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyClass definedClass;
        Object lexicalParentObject = this.lexicalParentModule.execute(frame);
        if (!(lexicalParentObject instanceof RubyModule)) {
            this.errorProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotA(lexicalParentObject, "module", (Node)this));
        }
        RubyModule lexicalParentModule = (RubyModule)lexicalParentObject;
        RubyClass suppliedSuperClass = this.executeSuperClass(frame);
        Object existing = this.lookupForExistingModule(frame, this.name, lexicalParentModule);
        if (this.needToDefineProfile.profile(existing == null)) {
            RubyClass superClass = this.noSuperClassSupplied.profile(suppliedSuperClass == null) ? this.getContext().getCoreLibrary().objectClass : suppliedSuperClass;
            definedClass = ClassNodes.createInitializedRubyClass(this.getContext(), this.getEncapsulatingSourceSection(), lexicalParentModule, superClass, this.name, this);
            this.callInherited(frame, superClass, definedClass);
        } else {
            if (!(existing instanceof RubyClass)) {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotA(existing, "class", (Node)this));
            }
            definedClass = (RubyClass)existing;
            Object currentSuperClass = definedClass.superclass;
            if (suppliedSuperClass != null && currentSuperClass != suppliedSuperClass) {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().superclassMismatch(definedClass.fields.getName(), this));
            }
        }
        return definedClass;
    }

    private RubyClass executeSuperClass(VirtualFrame frame) {
        if (this.superClassNode == null) {
            return null;
        }
        Object superClassObject = this.superClassNode.execute(frame);
        if (!(superClassObject instanceof RubyClass)) {
            this.errorProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("superclass must be a Class", this));
        }
        RubyClass superClass = (RubyClass)superClassObject;
        if (superClass.isSingleton) {
            this.errorProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().typeError("can't make subclass of virtual class", this));
        }
        return superClass;
    }

    private void callInherited(VirtualFrame frame, RubyClass superClass, RubyClass childClass) {
        if (this.inheritedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.inheritedNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        this.inheritedNode.call((Object)superClass, "inherited", childClass);
    }

    private Object lookupForExistingModule(VirtualFrame frame, String name, RubyModule lexicalParent) {
        if (this.lookupForExistingModuleNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupForExistingModuleNode = (LookupForExistingModuleNode)this.insert(new LookupForExistingModuleNode());
        }
        return this.lookupForExistingModuleNode.lookupForExistingModule(frame, name, lexicalParent);
    }

    @Override
    public RubyNode cloneUninitialized() {
        DefineClassNode copy = new DefineClassNode(this.name, this.lexicalParentModule.cloneUninitialized(), DefineClassNode.cloneUninitialized(this.superClassNode));
        return copy.copyFlags(this);
    }
}

