/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.dispatch.DispatchNode;

@ReportPolymorphism
@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class ForeignClassNode
extends RubyBaseNode {
    public abstract RubyClass execute(Node var1, Object var2);

    @Specialization(guards={"getTraits(object, interop) == cachedTraits"}, limit="getInteropCacheLimit()")
    static RubyClass cached(Node node, Object object, @CachedLibrary(value="object") InteropLibrary interop, @Cached(value="getTraits(object, interop)") int cachedTraits) {
        assert (RubyGuards.isForeignObject(object));
        return ForeignClassNode.classForTraits(node, cachedTraits);
    }

    @Specialization(replaces={"cached"}, limit="getInteropCacheLimit()")
    static RubyClass uncached(Node node, Object object, @CachedLibrary(value="object") InteropLibrary interop) {
        assert (RubyGuards.isForeignObject(object));
        return ForeignClassNode.classForTraits(node, ForeignClassNode.getTraits(object, interop));
    }

    protected static int getTraits(Object object, InteropLibrary interop) {
        return (interop.hasHashEntries(object) ? Trait.HASH.bit : 0) + (interop.hasArrayElements(object) ? Trait.ARRAY.bit : 0) + (interop.isException(object) ? Trait.EXCEPTION.bit : 0) + (interop.isExecutable(object) ? Trait.EXECUTABLE.bit : 0) + (interop.isInstantiable(object) ? Trait.INSTANTIABLE.bit : 0) + (interop.isIterator(object) ? Trait.ITERATOR.bit : 0) + (interop.hasIterator(object) ? Trait.ITERABLE.bit : 0) + (interop.isMetaObject(object) ? Trait.META_OBJECT.bit : 0) + (interop.isNull(object) ? Trait.NULL.bit : 0) + (interop.isNumber(object) ? Trait.NUMBER.bit : 0) + (interop.isPointer(object) ? Trait.POINTER.bit : 0) + (interop.isString(object) ? Trait.STRING.bit : 0);
    }

    private static RubyClass classForTraits(Node node, int traits) {
        RubyClass rubyClass = ForeignClassNode.coreLibrary((Node)node).polyglotForeignClasses[traits];
        if (rubyClass == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ForeignClassNode.coreLibrary((Node)node).polyglotForeignClasses[traits] = rubyClass = ForeignClassNode.resolvePolyglotForeignClass(node, traits);
        }
        return rubyClass;
    }

    private static RubyClass resolvePolyglotForeignClass(Node node, int traits) {
        ArrayList<RubySymbol> traitsList = new ArrayList<RubySymbol>();
        for (Trait trait : Trait.VALUES) {
            if (!trait.isSet(traits)) continue;
            traitsList.add(ForeignClassNode.getSymbol(node, trait.name));
        }
        Object[] traitSymbols = traitsList.toArray();
        return (RubyClass)DispatchNode.getUncached().call((Object)ForeignClassNode.coreLibrary((Node)node).truffleInteropOperationsModule, "resolve_polyglot_class", traitSymbols);
    }

    public static enum Trait {
        HASH("Hash"),
        ARRAY("Array"),
        EXCEPTION("Exception"),
        EXECUTABLE("Executable"),
        INSTANTIABLE("Instantiable"),
        ITERATOR("Iterator"),
        ITERABLE("Iterable"),
        META_OBJECT("MetaObject"),
        NULL("Null"),
        NUMBER("Number"),
        POINTER("Pointer"),
        STRING("String");

        public static final Trait[] VALUES;
        public static final int COMBINATIONS;
        final String name;
        final int bit;

        private Trait(String name) {
            this.name = name;
            this.bit = 1 << this.ordinal();
        }

        boolean isSet(int traits) {
            return (traits & this.bit) != 0;
        }

        static {
            VALUES = Trait.values();
            COMBINATIONS = 1 << VALUES.length;
        }
    }
}

